<?php

namespace App\Livewire\Report;

use Livewire\Component;
use Livewire\WithPagination;
use App\Exports\ExportARInvoiceDetail;
use App\Exports\ExportARItemDetail;
use App\Exports\ExportInvoice;
use App\Exports\ExportInvoiceDetail;
use App\Exports\ExportReturnDetail;
use App\Models\DetailInvoice;
use App\Models\Invoice as ModelsInvoice;
use App\Models\ItemTemp;
use App\Models\ItemTransTemp;
use App\Models\Member;
use App\Models\Settings;
use App\Models\Warehouse;
use Carbon\Carbon;
use Exception;
use GuzzleHttp\Client;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Schema;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Maatwebsite\Excel\Facades\Excel;
use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\CapabilityProfile;
use Mike42\Escpos\Printer;
use Illuminate\Pagination\LengthAwarePaginator;


class Bjrs extends Component
{
    use LivewireAlert;
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    
    public $page = 1;
    public $perPage = 10;
    public $search = '';
    public $sortField = 'created_at';
    public $sortDirection = 'DESC';

    protected $queryString = [
        'page' => ['except' => 1],
        'perPage' => ['except' => 10],
        'search' => ['except' => ''],
        'startDate' => ['except' => ''],
        'endDate' => ['except' => ''],
        'type' => ['except' => ''],
        'sortField' => ['except' => 'created_at'],
        'sortDirection' => ['except' => 'DESC']
    ];

    public function updatedPerPage()
    {
        $this->resetPage();
    }

    public function updatedSearch()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = ($this->sortDirection === 'DESC') ? 'ASC' : 'DESC';
            return;
        }
        $this->sortField = $field;
        $this->sortDirection = 'ASC';
    }

    public $startDate;
    public $endDate;
    public $type = 'All';

    // Add resetPage method
    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingPerPage()
    {
        $this->resetPage();
    }

    public function updatingType()
    {
        $this->resetPage();
    }

    public function updatingStartDate()
    {
        $this->resetPage();
    }

    public function updatingEndDate()
    {
        $this->resetPage();
    }

    public function paginationView()
    {
        return 'vendor.livewire.bootstrap';
    }

    public function getUpdatesQueryString()
    {
        return array_merge([
            'page' => ['except' => 1],
            'perPage' => ['except' => 10],
            'search' => ['except' => ''],
            'startDate' => ['except' => ''],
            'endDate' => ['except' => ''],
            'type' => ['except' => ''],
            'sortField' => ['except' => 'created_at'],
            'sortDirection' => ['except' => 'DESC'],
        ], $this->queryString);
    }

    public $invoiceNo = false;
    public $checkboxes = [];
    public $selectAll = false;
    public $datadetail;
    public $isloadingsync = false;
    public $isloadingreturn = false;
    public $loadingsap = false;
    public $selectedType = false;
    public $processing = false;
    public $conn = '';
    public $whs_code;
    public $isEnableService;
    
    /** @var \Illuminate\Pagination\LengthAwarePaginator */
    protected $paginatedData;

    /** @var \Illuminate\Support\Collection */
    protected $invoices;

    public function mount()
    {
        $this->initializeComponent();
    }

    public function initializeComponent()
    {
        if (auth()->user()->role == 'Admin') {
            $warehouse = Warehouse::where('company_code', auth()->user()->company_code)->first();
            $user = auth()->user();
            if($user->whs_code == '-')
            {
                DB::table('Luv2_user')
                    ->where('id', $user->id)
                    ->update(['whs_code' => $warehouse->code]);
            }
        }

        // Get company settings for service feature
        $settings = DB::table('Luv2_company')->where('code', auth()->user()->company_code)->first();
        $this->isEnableService = $settings ? ($settings->service === 'Y') : false;

        // Set initial dates to today
        $this->startDate = Carbon::now()->format('Y-m-d');
        $this->endDate = Carbon::now()->format('Y-m-d');

        // Check if data exists for today
        $hasDataToday = DB::table('Luv2_invoice')
            ->where('whs_code', auth()->user()->whs_code)
            ->whereDate('created_at', Carbon::now()->format('Y-m-d'))
            ->exists();

        // If no data today, get the latest date with data
        if (!$hasDataToday) {
            $latestDate = DB::table('Luv2_invoice')
                ->where('whs_code', auth()->user()->whs_code)
                ->orderBy('created_at', 'DESC')
                ->value('created_at');

            if ($latestDate) {
                $this->startDate = Carbon::parse($latestDate)->format('Y-m-d');
                $this->endDate = Carbon::parse($latestDate)->format('Y-m-d');
                $this->dispatch('noDataToday');
            }
        }

        $query = DB::table('Luv2_invoice')
            ->leftJoin('Luv2_salesemp', 'Luv2_invoice.sales_code', '=', 'Luv2_salesemp.code')
            ->leftJoin('Luv2_user', 'Luv2_invoice.user_code', '=', 'Luv2_user.code')
            ->select(
                'Luv2_invoice.*',
                'Luv2_salesemp.name as sales_name',
                'Luv2_user.username as users_name'
            )
            ->where('Luv2_invoice.whs_code', auth()->user()->whs_code)
            ->where(function ($query) {
                if ($this->startDate === $this->endDate) {
                    $query->whereDate('Luv2_invoice.created_at', '=', $this->startDate);
                } else {
                    $endDate = date('Y-m-d 23:59:59', strtotime($this->endDate));
                    $query->whereBetween('Luv2_invoice.created_at', [$this->startDate, $endDate]);
                }

                if ($this->type == 'BJ') {
                    $query->whereNull('Luv2_invoice.no_inv');
                } elseif ($this->type == 'RS') {
                    $query->whereNotNull('Luv2_invoice.no_inv');
                }
            })
            ->orderBy($this->sortField, $this->sortDirection);

        $paginatedResults = $query->paginate($this->perPage);
        
        // Transform the data
        $transformedData = collect($paginatedResults->items())->map(function ($item) {
            $item = (object)$item;
            
            if ($item->note) {
                $invoiceNote = json_decode($item->note, true);
                $item->cash = (float)($invoiceNote['cash'] ?? 0);
                $item->transfer = (float)($invoiceNote['transfer'] ?? 0);
            } else {
                $item->cash = 0;
                $item->transfer = 0;
            }
            
            if ($item->cashback !== 'N') {
                $cekvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $item->cashback)->first();
                $item->value = $cekvoucher ? (float)$cekvoucher->value : 0;
            } else {
                $item->value = 0;
            }

            if ($this->isEnableService) {
                $item->service_amount = (float)($item->service ?? 0);
                $item->service_percent = (float)($item->service_percent ?? 0);
            }

            return [
                'id' => $item->id,
                'no' => $item->no,
                'no_inv' => $item->no_inv,
                'created_at' => $item->created_at,
                'users_name' => $item->users_name,
                'sales_name' => $item->sales_name,
                'total_qty' => (float)$item->total_qty,
                'subtotal' => (float)$item->subtotal,
                'disc_total' => (float)$item->disc_total,
                'must_paid' => (float)$item->must_paid,
                'payment' => $item->payment,
                'grandtotal' => (float)$item->must_paid,
                'cash' => (float)$item->cash,
                'transfer' => (float)$item->transfer,
                'value' => (float)$item->value,
                'service_amount' => (float)($item->service_amount ?? 0),
                'service_percent' => (float)($item->service_percent ?? 0),
                'cashback' => $item->cashback,
                'sandbox' => $item->sandbox,
                'sync' => $item->sync ?? 'N'
            ];
        })->toArray();

        // Create new paginator with transformed data
        $this->paginatedData = new LengthAwarePaginator(
            $transformedData,
            $paginatedResults->total(),
            $paginatedResults->perPage(),
            $paginatedResults->currentPage(),
            ['path' => request()->url()]
        );

        // Handle return sales
        $this->returnsale = collect($transformedData)
            ->filter(function($invoice) {
                return !is_null($invoice['no_inv']);
            })
            ->map(function ($returnsale) {
                return [
                    'id' => $returnsale['id'],
                    'no' => $returnsale['no'],
                    'no_inv' => $returnsale['no_inv'],
                    'subtotal' => $returnsale['subtotal'],
                    'price' => abs($returnsale['subtotal']),
                    'created_at' => $returnsale['created_at'],
                    'payment' => $returnsale['payment'],
                    'cash' => $returnsale['cash'],
                    'transfer' => $returnsale['transfer'],
                    'value' => $returnsale['value'],
                    'service_amount' => $returnsale['service_amount'],
                    'service_percent' => $returnsale['service_percent']
                ];
            })
            ->values()
            ->toArray();

        $this->dispatch('refreshjs');
    }

    #[On('syncCompleted')]
    public function refresh()
    {
        $this->initializeComponent();
    }

    public function updateCheckboxes($crdcd)
    {
        $this->checkboxes[$crdcd] = !$this->checkboxes[$crdcd];
    }

    public function clearFilter()
    {
        $this->reset(['startDate', 'endDate', 'type', 'search']);
        $this->initializeComponent();
    }

    public function filterInvoices()
    {
        $this->resetPage(); // Reset to first page when filtering
        
        $query = DB::table('Luv2_invoice')
            ->leftJoin('Luv2_salesemp', 'Luv2_invoice.sales_code', '=', 'Luv2_salesemp.code')
            ->leftJoin('Luv2_user', 'Luv2_invoice.user_code', '=', 'Luv2_user.code')
            ->select(
                'Luv2_invoice.*',
                'Luv2_salesemp.name as sales_name',
                'Luv2_user.username as users_name'
            )
            ->where('Luv2_invoice.whs_code', auth()->user()->whs_code);

        // Apply search filter
        if ($this->search) {
            $query->where(function($q) {
                $q->where('Luv2_invoice.no', 'like', '%' . $this->search . '%')
                  ->orWhere('Luv2_user.username', 'like', '%' . $this->search . '%')
                  ->orWhere('Luv2_salesemp.name', 'like', '%' . $this->search . '%');
            });
        }

        // Apply date filter
        if ($this->startDate && $this->endDate) {
            if ($this->startDate === $this->endDate) {
                $query->whereDate('Luv2_invoice.created_at', '=', $this->startDate);
            } else {
                $endDate = date('Y-m-d 23:59:59', strtotime($this->endDate));
                $query->whereBetween('Luv2_invoice.created_at', [$this->startDate, $endDate]);
            }
        }

        // Apply type filter
        if ($this->type == 'BJ') {
            $query->whereNull('Luv2_invoice.no_inv');
        } elseif ($this->type == 'RS') {
            $query->whereNotNull('Luv2_invoice.no_inv');
        }

        // Apply sorting
        $query->orderBy($this->sortField, $this->sortDirection);
        
        // Get paginated results
        $paginatedResults = $query->paginate($this->perPage);

        // Transform the data
        $transformedData = collect($paginatedResults->items())->map(function ($item) {
            $item = (object)$item;
            
            if ($item->note) {
                $invoiceNote = json_decode($item->note, true);
                $item->cash = (float)($invoiceNote['cash'] ?? 0);
                $item->transfer = (float)($invoiceNote['transfer'] ?? 0);
            } else {
                $item->cash = 0;
                $item->transfer = 0;
            }
            
            if ($item->cashback !== 'N') {
                $cekvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $item->cashback)->first();
                $item->value = $cekvoucher ? (float)$cekvoucher->value : 0;
            } else {
                $item->value = 0;
            }

            if ($this->isEnableService) {
                $item->service_amount = (float)($item->service ?? 0);
                $item->service_percent = (float)($item->service_percent ?? 0);
            }

            return [
                'id' => $item->id,
                'no' => $item->no,
                'no_inv' => $item->no_inv,
                'created_at' => $item->created_at,
                'users_name' => $item->users_name,
                'sales_name' => $item->sales_name,
                'total_qty' => (float)$item->total_qty,
                'subtotal' => (float)$item->subtotal,
                'disc_total' => (float)$item->disc_total,
                'must_paid' => (float)$item->must_paid,
                'payment' => $item->payment,
                'grandtotal' => (float)$item->must_paid,
                'cash' => (float)$item->cash,
                'transfer' => (float)$item->transfer,
                'value' => (float)$item->value,
                'service_amount' => (float)($item->service_amount ?? 0),
                'service_percent' => (float)($item->service_percent ?? 0),
                'cashback' => $item->cashback,
                'sandbox' => $item->sandbox,
                'sync' => $item->sync ?? 'N'
            ];
        })->toArray();

        // Create new paginator with transformed data
        $this->paginatedData = new LengthAwarePaginator(
            $transformedData,
            $paginatedResults->total(),
            $paginatedResults->perPage(),
            $paginatedResults->currentPage(),
            [
                'path' => request()->url(),
                'query' => request()->query()
            ]
        );

        // Handle return sales
        $this->returnsale = collect($transformedData)
            ->filter(function($invoice) {
                return !is_null($invoice['no_inv']);
            })
            ->map(function ($returnsale) {
                return [
                    'id' => $returnsale['id'],
                    'no' => $returnsale['no'],
                    'no_inv' => $returnsale['no_inv'],
                    'subtotal' => $returnsale['subtotal'],
                    'price' => abs($returnsale['subtotal']),
                    'created_at' => $returnsale['created_at'],
                    'payment' => $returnsale['payment'],
                    'cash' => $returnsale['cash'],
                    'transfer' => $returnsale['transfer'],
                    'value' => $returnsale['value'],
                    'service_amount' => $returnsale['service_amount'],
                    'service_percent' => $returnsale['service_percent']
                ];
            })
            ->values()
            ->toArray();

        $this->dispatch('refreshjs');
    }

    #[On('refresh')]
    public function render()
    {
        $warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();

        $query = DB::table('Luv2_invoice')
            ->leftJoin('Luv2_salesemp', 'Luv2_invoice.sales_code', '=', 'Luv2_salesemp.code')
            ->leftJoin('Luv2_user', 'Luv2_invoice.user_code', '=', 'Luv2_user.code')
            ->select(
                'Luv2_invoice.*',
                'Luv2_salesemp.name as sales_name',
                'Luv2_user.username as users_name'
            )
            ->where('Luv2_invoice.whs_code', auth()->user()->whs_code);

        // Apply search filter
        if ($this->search) {
            $query->where(function($q) {
                $q->where('Luv2_invoice.no', 'like', '%' . $this->search . '%')
                  ->orWhere('Luv2_user.username', 'like', '%' . $this->search . '%')
                  ->orWhere('Luv2_salesemp.name', 'like', '%' . $this->search . '%');
            });
        }

        // Apply date filter
        if ($this->startDate && $this->endDate) {
            if ($this->startDate === $this->endDate) {
                $query->whereDate('Luv2_invoice.created_at', '=', $this->startDate);
            } else {
                $endDate = date('Y-m-d 23:59:59', strtotime($this->endDate));
                $query->whereBetween('Luv2_invoice.created_at', [$this->startDate, $endDate]);
            }
        }

        // Apply type filter
        if ($this->type == 'BJ') {
            $query->whereNull('Luv2_invoice.no_inv');
        } elseif ($this->type == 'RS') {
            $query->whereNotNull('Luv2_invoice.no_inv');
        }

        // Apply sorting
        $query->orderBy($this->sortField, $this->sortDirection);
        
        // Get paginated results
        $paginatedResults = $query->paginate($this->perPage);

        // Transform the data
        $transformedData = collect($paginatedResults->items())->map(function ($item) {
            $item = (object)$item;
            
            if ($item->note) {
                $invoiceNote = json_decode($item->note, true);
                $item->cash = (float)($invoiceNote['cash'] ?? 0);
                $item->transfer = (float)($invoiceNote['transfer'] ?? 0);
            } else {
                $item->cash = 0;
                $item->transfer = 0;
            }
            
            if ($item->cashback !== 'N') {
                $cekvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $item->cashback)->first();
                $item->value = $cekvoucher ? (float)$cekvoucher->value : 0;
            } else {
                $item->value = 0;
            }

            if ($this->isEnableService) {
                $item->service_amount = (float)($item->service ?? 0);
                $item->service_percent = (float)($item->service_percent ?? 0);
            }

            return [
                'id' => $item->id,
                'no' => $item->no,
                'no_inv' => $item->no_inv,
                'created_at' => $item->created_at,
                'users_name' => $item->users_name,
                'sales_name' => $item->sales_name,
                'total_qty' => (float)$item->total_qty,
                'subtotal' => (float)$item->subtotal,
                'disc_total' => (float)$item->disc_total,
                'must_paid' => (float)$item->must_paid,
                'payment' => $item->payment,
                'grandtotal' => (float)$item->must_paid,
                'cash' => (float)$item->cash,
                'transfer' => (float)$item->transfer,
                'value' => (float)$item->value,
                'service_amount' => (float)($item->service_amount ?? 0),
                'service_percent' => (float)($item->service_percent ?? 0),
                'cashback' => $item->cashback,
                'sandbox' => $item->sandbox,
                'sync' => $item->sync ?? 'N'
            ];
        })->toArray();

        // Create new paginator with transformed data
        $this->paginatedData = new LengthAwarePaginator(
            $transformedData,
            $paginatedResults->total(),
            $paginatedResults->perPage(),
            $paginatedResults->currentPage(),
            [
                'path' => request()->url(),
                'query' => request()->query()
            ]
        );

        // Handle return sales
        $this->returnsale = collect($transformedData)
            ->filter(function($invoice) {
                return !is_null($invoice['no_inv']);
            })
            ->map(function ($returnsale) {
                return [
                    'id' => $returnsale['id'],
                    'no' => $returnsale['no'],
                    'no_inv' => $returnsale['no_inv'],
                    'subtotal' => $returnsale['subtotal'],
                    'price' => abs($returnsale['subtotal']),
                    'created_at' => $returnsale['created_at'],
                    'payment' => $returnsale['payment'],
                    'cash' => $returnsale['cash'],
                    'transfer' => $returnsale['transfer'],
                    'value' => $returnsale['value'],
                    'service_amount' => $returnsale['service_amount'],
                    'service_percent' => $returnsale['service_percent']
                ];
            })
            ->values()
            ->toArray();

        return view('livewire.report.bjrs', [
            'invoices' => $transformedData,
            'returnsale' => $this->returnsale,
            'warehouse' => $warehouse,
            'paginatedData' => $this->paginatedData
        ]);
    }

    public function updatedWhsCode()
    {
        $user = auth()->user();
        DB::table('Luv2_user')
            ->where('id', $user->id)
            ->update(['whs_code' => $this->whs_code]);
        $this->dispatch('syncCompleted');
    }

    public function exportExcelDetail($code)
    {
        $data = DetailInvoice::where('no', $code)->get();
        $invoicesdetail = $data;
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        if ($this->startDate === null) {
            $filename = "Invoice Detail Report - {$now}.xlsx";
        } else {
            $filename = "Invoice Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        $this->dispatch('refreshjs');

        return Excel::download(new ExportInvoiceDetail($invoicesdetail), $filename);
    }
    public function exportreturnExcelDetail($code)
    {
        $datareturn = DetailInvoice::where('invoice', $code)
            ->where('status', 1)->get();
        $databuy = DetailInvoice::where('invoice', $code)
            ->where('status', 0)->get();
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        if ($this->startDate === null) {
            $filename = "Return Sale Detail Report - {$now}.xlsx";
        } else {
            $filename = "Return Sale Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        }
        return Excel::download(new ExportReturnDetail($datareturn, $databuy), $filename);
    }
    public function exportExcel()
    {
        $query = DB::table('Luv2_invoice')
            ->leftJoin('Luv2_salesemp', 'Luv2_invoice.sales_code', '=', 'Luv2_salesemp.code')
            ->leftJoin('Luv2_user', 'Luv2_invoice.user_code', '=', 'Luv2_user.code')
            ->select(
                'Luv2_invoice.*',
                'Luv2_salesemp.name as sales_name',
                'Luv2_user.username as users_name'
            )
            ->where('Luv2_invoice.whs_code', auth()->user()->whs_code);

        // Apply search filter
        if ($this->search) {
            $query->where(function($q) {
                $q->where('Luv2_invoice.no', 'like', '%' . $this->search . '%')
                  ->orWhere('Luv2_user.username', 'like', '%' . $this->search . '%')
                  ->orWhere('Luv2_salesemp.name', 'like', '%' . $this->search . '%');
            });
        }

        // Apply date filter
        if ($this->startDate && $this->endDate) {
            if ($this->startDate === $this->endDate) {
                $query->whereDate('Luv2_invoice.created_at', '=', $this->startDate);
            } else {
                $endDate = date('Y-m-d 23:59:59', strtotime($this->endDate));
                $query->whereBetween('Luv2_invoice.created_at', [$this->startDate, $endDate]);
            }
        }

        // Apply type filter
        if ($this->type == 'BJ') {
            $query->whereNull('Luv2_invoice.no_inv');
        } elseif ($this->type == 'RS') {
            $query->whereNotNull('Luv2_invoice.no_inv');
        }

        // Apply sorting
        $query->orderBy($this->sortField, $this->sortDirection);

        $invoices = $query->get()->map(function ($item) {
            $item = (object)$item;
            
            if ($item->note) {
                $invoiceNote = json_decode($item->note, true);
                $item->cash = (float)($invoiceNote['cash'] ?? 0);
                $item->transfer = (float)($invoiceNote['transfer'] ?? 0);
            } else {
                $item->cash = 0;
                $item->transfer = 0;
            }
            
            if ($item->cashback !== 'N') {
                $cekvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $item->cashback)->first();
                $item->value = $cekvoucher ? (float)$cekvoucher->value : 0;
            } else {
                $item->value = 0;
            }

            if ($this->isEnableService) {
                $item->service_amount = (float)($item->service ?? 0);
                $item->service_percent = (float)($item->service_percent ?? 0);
            }

            return $item;
        });

        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        
        if ($this->startDate && $this->endDate) {
            $filename = "Invoice Report - {$this->startDate} - {$this->endDate}.xlsx";
        } else {
            $filename = "Invoice Report - {$now}.xlsx";
        }

        $this->dispatch('refreshjs');
        return Excel::download(new ExportInvoice($invoices), $filename);
    }

    public function exportARItemDetail()
    {
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        
        $data = [
            'startDate' => $this->startDate,
            'endDate' => $this->endDate,
            'type' => $this->type,
            'search' => $this->search,
            'whs_code' => auth()->user()->whs_code
        ];
        if ($this->startDate && $this->endDate) {
            $filename = "AR Item Detail Report - {$this->startDate} - {$this->endDate}.xlsx";
        } else {
            $filename = "AR Item Detail Report - {$now}.xlsx";
        }

        $this->dispatch('refreshjs');
        return Excel::download(new ExportARItemDetail($data), $filename);
    }

    public function exportARInvoiceDetail()
    {
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        
        $data = [
            'startDate' => $this->startDate,
            'endDate' => $this->endDate,
            'type' => $this->type,
            'search' => $this->search,
            'whs_code' => auth()->user()->whs_code
        ];

        if ($this->startDate && $this->endDate) {
            $filename = "AR Invoice Report - {$this->startDate} - {$this->endDate}.xlsx";
        } else {
            $filename = "AR Invoice Report - {$now}.xlsx";
        }

        $this->dispatch('refreshjs');
        return Excel::download(new ExportARInvoiceDetail($data), $filename);
    }

    public function print($code)
    {
        if ($this->processing) return;
        $this->processing = true;

        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $printer = $setting->printer_name;
        try {
            $profile = CapabilityProfile::load("default");
            $connector = new WindowsPrintConnector($printer);
            $printer = new Printer($connector, $profile);

            $printer->setTextSize(1, 1);

            $datainvoice = DetailInvoice::where('invoice', $code)->get();
            $invoice = ModelsInvoice::where('no', $code)->first();
            $promo = DB::table('Luv2_promo')->where('invoice', $invoice->no)->first();
            $voucher = [];
            if ($promo) {
                $voucher = DB::table('Luv2_promo_voucher')->where('no', $promo->no)->first();
            }

            $changeFormatted = number_format(empty($invoice->change) ? 0 : $invoice->change, 2);
            $datafirst = DetailInvoice::where('invoice', $code)->first();

            if ($invoice->payment === "Multi") {
                $note = json_decode($invoice['note'], true);
                $cash = $note['cash'];
                $card = $note['transfer'];
                $change = 0;
            } elseif ($invoice->payment === "Card") {
                $note = json_decode($invoice['note'], true);
                $cash = 0;
                $card = $note['transfer'];
                $change = $invoice->change;
            } elseif ($invoice->payment === "Cash") {
                $cash = $invoice->paid;
                $card = 0;
                $change = $invoice->change;
            } elseif ($invoice->payment === "Qris") {
                $cash = 0;
                $card = $invoice->paid;
                $change = $invoice->change;
            }

            $toko = $setting->wh_name;
            $address = $setting->address;
            $phone = "Telp : " . $setting->phone;
            $manager = "Cashier : " . $user->name;
            $billNo = "Bill No : " . $invoice->no;
            $date = "Date    : " . $invoice->created_at;
            if (!isset($datafirst->sales->position) || $datafirst->sales->position === '') {
                $handledBy = "Handled by : " . $datafirst->sales->name;
            } else {
                $handledBy = "Handled by : " . $datafirst->sales->position;
            }
            $cash = $cash ?? 0; // Using the null coalescing operator to handle undefined variables
            $card = $card ?? 0;
            $change = $change ?? 0;

            foreach ($datainvoice as $cartItem) {
                $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                $items[] = [
                    'name' => $name,
                    'qty' => $cartItem['qty'],
                    'price' => $cartItem['price'],
                    'nprice' => $cartItem['nprice'],
                    'discount' => $cartItem['disc'],
                ];
            }
            $subTotal = array_reduce($items, function ($carry, $item) {
                if ($item['nprice'] >= 0) {
                    return $carry + $item['nprice'] * $item['qty'];
                }
                return $carry;
            }, 0);

            $grandTotal = array_reduce($items, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            if ($invoice->cashback !== 'N') {
                $getvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $invoice->cashback)->first();
                $vouchervalue = $getvoucher->value;
                $grandTotal -=  $vouchervalue;
            }

            $discount = array_reduce($items, function ($carry, $item) {
                return ($carry + $item['nprice'] - $item['price']);
            }, 0);

            // Start the receipt
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("$toko\n$phone\n$address\n");
            $printer->text("---------------------------------------\n");
            $printer->setJustification(0);
            if($invoice->id_member != null || $invoice->id_member != ''){
                $member = Member::where('code' , $invoice->id_member)->first();
                $membername = "Member  : " . $member->name;
                $printer->text("$manager\n$billNo\n$date\n$membername\n");
            }else{
                $printer->text("$manager\n$billNo\n$date\n");
            }
            // if ($voucher) {
            //     $printer->text("Voucher : " . $voucher->voucher . "\n");
            // }
            $printer->text("---------------------------------------\n");

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            $totalSelisih = 0; // Initialize the total variable

            foreach ($items as $item) {
                if ($item['discount'] === null || $item['discount'] == 0) {
                    if ($item['price'] < 0) {
                        $formattedPrice = '(' . number_format($item['price'] * $item['qty'], 2) . ')'; // Ensure the negative number is properly formatted
                    } else {
                        $formattedPrice = number_format($item['price'] * $item['qty'], 2);
                    }
                    $printer->text(sprintf(
                        "%-15s %5d   %12s\n",
                        $item['name'],
                        $item['qty'],
                        $formattedPrice
                    ));
                } else {
                    $selisih = $item['nprice'] - $item['price'];
                    $printer->text(sprintf(
                        "%-15s %5d   %12s\n",
                        $item['name'],
                        $item['qty'],
                        number_format($item['nprice'] * $item['qty'], 2)
                    ));
                    $printer->setFont(Printer::FONT_B);
                    $printer->setTextSize(1, 1);
                    $printer->text(sprintf(
                        "%36s\n",
                        "(" . number_format($selisih * $item['qty'], 2) . ")"
                    ));
                    $totalSelisih += $selisih * $item['qty'];
                }
            }

            // Print Information card
            if ($invoice->payment === "Card" || $invoice->payment === "Multi") {
                $note = json_decode($invoice->note, true);
                $printer->text("---------------------------------------\n");
                $name = "Name        : " . $note['nama_pemegang_kartu'];
                $nocard = "Card Number : " . $note['nomor_kartu'];
                $printer->text("$nocard\n");
                $printer->text("$name\n");
            }

            $printer->setJustification(0);

            $printer->text("---------------------------------------\n");
            $padding = 14; // Number of spaces before the text
            $subTotal = "SubTotal   : " . number_format($subTotal, 2);
            $discount = "Discount   : " . number_format($totalSelisih, 2);
            $grandTotal = "GrandTotal : " . number_format($grandTotal, 2);
            if ($invoice->cashback !== 'N') {
                $getvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $invoice->cashback)->first();
                $vouchervalue = $getvoucher->value;
                $voucherdisc = "Cashback   : " . number_format($vouchervalue, 2);
                $rightAlignedVoucher = str_repeat(' ', $padding) . $voucherdisc;
            }

            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotal;
            $rightAlignedDiscount = str_repeat(' ', $padding) . $discount;
            $rightAlignedGrandTotal = str_repeat(' ', $padding) . $grandTotal;

            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("$rightAlignedDiscount\n");
            if ($invoice->cashback !== 'N') {
                $printer->text("$rightAlignedVoucher\n");
            }
            $printer->text("$rightAlignedGrandTotal\n");


            // $printer->text("---------------------------------------\n");
            $cash = "Cash       : " . number_format($cash, 2);
            $card = "Card       : " . number_format($card, 2);
            $change = "Change     : " . $changeFormatted;
            // Add padding before the text to ensure it starts at character 12
            $rightAlignedCash = str_repeat(' ', $padding) . $cash;
            $rightAlignedCard = str_repeat(' ', $padding) . $card;
            $rightAlignedChange = str_repeat(' ', $padding) . $change;


            $printer->text("$rightAlignedCard\n");
            $printer->text("$rightAlignedCash\n");
            $printer->text("$rightAlignedChange\n");

            // Reset text justification to default (centered)
            $printer->setJustification();

            // Handled by
            $printer->text("---------------------------------------\n");
            $printer->text("$handledBy\n");

            //Voucher
            if ($voucher) {
                $voucherFromDate = Carbon::parse($promo->voucher_from_date)->format('d - M - Y');
                $voucherToDate = Carbon::parse($promo->voucher_to_date)->format('d - M - Y');
                $printer->text("---------------------------------------\n");
                $printer->text("Voucher Cashback : " . $voucher->voucher . "\n");
                $printer->text("Valid From       : " . $voucherFromDate . "\n");
                $printer->text("Valid Until      : " . $voucherToDate . "\n");
            }

            // Thank you message
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("---------------------------------------\n");
            $footer = $setting->receipt_footer;
            $lines = explode('\n', $footer);

            foreach ($lines as $line) {
                $printer->text($line . "\n"); // Print each line with a newline character
            }

            $printer->text("THANK YOU\n\n\n\n"); // Send a form feed character

            $printer->text("( _ _ _ _ _ _ _ _ _ _ _ )");

            $printer->feed(2); // Adjust the number of lines as needed

            // Cut the receipt
            $printer->cut();

            // Close the printer
            $printer->close();

            // dd($items, $data, 'Subtotal : '. $subTotal, 'GrandTotal : '. $grandTotal, 'Discount : '. $discount);
            $this->dispatch('refresh');
            $this->dispatch('refreshjs');
            sleep(2);
            $this->processing = false;

        } catch (Exception $e) {
            // $this->refreshBrowser();
            dd($e);
        }
    }

    public function clickSync($code)
    {
        $this->isloadingsync = true;
        $invoice = ModelsInvoice::where('no', $code)->first();
        if ($invoice->sandbox == 'Y') {
            $this->dispatch('prosesSyncSandbox', $code);
        } else {
            $this->dispatch('prosesSync', $code);
        }
    }

    public function clickSyncReturn($code)
    {
        $this->isloadingreturn = true;
        $this->dispatch('prosesSyncReturn', $code);
    }




   
    public function printreturn($code)
    {
        $invoice = ModelsInvoice::where('no', $code)->with('detailInvoices')->first();
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $printer = $setting->printer_name;
        try {
            $profile = CapabilityProfile::load("default");
            $connector = new WindowsPrintConnector($printer);
            $printer = new Printer($connector, $profile);
            $datafirst = DetailInvoice::where('invoice', $code)->first();

            // Set the font size
            $printer->setTextSize(1, 1);

            // Set the justification
            $toko = $setting->wh_name;
            $address = $setting->address;
            $phone = "Telp : " . $setting->phone;
            $manager = "Cashier   : " . Auth::user()->name;
            $billNo = "Bill No   : " . $invoice->no_inv;
            $returNo = "Return No : " . $invoice->no;
            $date = "Date      : " . $invoice->created_at;
            if (!isset($datafirst->sales->position) || $datafirst->sales->position === '') {
                $handledBy = "Handled by : " . $datafirst->sales->name;
            } else {
                $handledBy = "Handled by : " . $datafirst->sales->position;
            }
            // Define your item list (replace this with your actual item data)
            $itemsreturn = [];

            foreach ($invoice->detailInvoices as $cartItem) {
                // Check if qty is not negative (-)
                if ($cartItem['qty'] <= 0) {
                    $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                    $itemsreturn[] = [
                        'name' => $name,
                        'qty' => abs($cartItem['qty']),
                        'price' => $cartItem['price'],
                    ];
                }
            }

            $items = [];

            foreach ($invoice->detailInvoices as $cartItem) {
                if ($cartItem['qty'] >= 0) {
                    $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                    $items[] = [
                        'name' => $name,
                        'qty' => abs($cartItem['qty']),
                        'price' => $cartItem['price'],
                    ];
                }
            }

            $subTotalreturn = array_reduce($itemsreturn, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            $subTotalitems = array_reduce($items, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            // Start the receipt
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("$toko\n$phone\n$address\n");
            $printer->text("---------------------------------------\n");
            $printer->setJustification(0);
            if($invoice->id_member != null || $invoice->id_member != ''){
                $member = Member::where('code' , $invoice->id_member)->first();
                $membername = "Member  : " . $member->name;
                $printer->text("$manager\n$billNo\n$returNo\n$date\n$membername\n");
            }else{
                $printer->text("$manager\n$billNo\n$returNo\n$date\n");
            }
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEM RETURN* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($itemsreturn as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            // Print totals

            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotal = "SubTotal  : " . number_format($subTotalreturn, 2);


            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotal;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEMS* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($items as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotals = "SubTotal  : " . number_format($subTotalitems, 2);

            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotals;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("---------------------------------------\n");

            // Handled by
            $printer->text("---------------------------------------\n");
            $printer->text("$handledBy\n");

            // Thank you message
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("---------------------------------------\n");
            $footer = $setting->receipt_footer;
            $lines = explode('\n', $footer);

            foreach ($lines as $line) {
                $printer->text($line . "\n");
            }

            $printer->text("THANK YOU\n\n\n\n"); // Send a form feed character

            $printer->text("( _ _ _ _ _ _ _ _ _ _ _ )");

            $printer->feed(2); // Adjust the number of lines as needed

            // Cut the receipt
            $printer->cut();

            // Close the printer
            $printer->close();
        } catch (Exception $e) {
            // Handle the printing error here, you can log the error or display a message
            $this->dispatch('printernotfound');
        }
        // dd('No money ' , $invoice);
    }
    public function printreturnwithmoney($code)
    {
        $invoice = ModelsInvoice::where('no', $code)->with('detailInvoices')->first();
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $changeFormatted = number_format($invoice->change ?? 0, 2);
        $datafirst = DetailInvoice::where('invoice', $code)->first();

        $printer = $setting->printer_name;
        try {
            $profile = CapabilityProfile::load("default");
            $connector = new WindowsPrintConnector($printer);
            $printer = new Printer($connector, $profile);

            // Set the font size
            $printer->setTextSize(1, 1);

            // Set the justification
            $toko = $setting->wh_name;
            $address = $setting->address;
            $phone = "Telp : " . $setting->phone;
            $manager = "Cashier   : " . Auth::user()->name;
            $billNo = "Bill No   : " . $invoice->no_inv;
            $returNo = "Return No : " . $invoice->no;
            $date = "Date      : " . $invoice->created_at;
            $handledBy = "Handled by : " . $datafirst->sales->name;
            // Define your item list (replace this with your actual item data)
            if ($invoice->payment === "Multi") {
                $note = json_decode($invoice['note'], true);
                $cash = $note['cash'];
                $card = $note['transfer'];
                $change = 0;
            } elseif ($invoice->payment === "Card") {
                $note = json_decode($invoice['note'], true);
                $cash = 0;
                $card = $note['transfer'];
                $change = $invoice->change;
            } elseif ($invoice->payment === "Cash") {
                $cash = $invoice->paid;
                $card = 0;
                $change = $invoice->change;
            } elseif ($invoice->payment === "Qris") {
                $cash = 0;
                $card = $invoice->paid;
                $change = $invoice->change;
            }

            $itemsreturn = [];

            foreach ($invoice->detailInvoices as $cartItem) {
                if ($cartItem['qty'] <= 0) {
                    $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                    $itemsreturn[] = [
                        'name' => $name,
                        'qty' => abs($cartItem['qty']),
                        'price' => $cartItem['price'],
                    ];
                }
            }

            $items = [];

            foreach ($invoice->detailInvoices as $cartItem) {
                if ($cartItem['qty'] >= 0) {
                    $name = str_pad(substr($cartItem['name'], 0, 15), 15); // Truncate or pad to 15 characters
                    $items[] = [
                        'name' => $name,
                        'qty' => abs($cartItem['qty']),
                        'price' => $cartItem['price'],
                    ];
                }
            }

            $subTotalreturn = array_reduce($itemsreturn, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            $subTotalitems = array_reduce($items, function ($carry, $item) {
                return $carry + $item['price'] * $item['qty'];
            }, 0);

            $grandTotal = $subTotalitems - $subTotalreturn;
            // Start the receipt
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("$toko\n$phone\n$address\n");
            $printer->text("---------------------------------------\n");
            $printer->setJustification(0);
            if($invoice->id_member != null || $invoice->id_member != ''){
                $member = Member::where('code' , $invoice->id_member)->first();
                $membername = "Member  : " . $member->name;
                $printer->text("$manager\n$billNo\n$returNo\n$date\n$membername\n");
            }else{
                $printer->text("$manager\n$billNo\n$returNo\n$date\n");
            }
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEM RETURN* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($itemsreturn as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }



            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotal = "SubTotal  : " . number_format($subTotalreturn, 2);


            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotal;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("---------------------------------------\n");

            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text(" *ITEMS* \n");
            $printer->setJustification(0);

            // Print the table
            $printer->setJustification(Printer::JUSTIFY_LEFT);
            $printer->text("Item               Qty        Price\n");
            $printer->text("---------------------------------------\n");

            foreach ($items as $item) {
                $printer->text(sprintf(
                    "%-15s %5d   %12s\n",
                    $item['name'],
                    $item['qty'],
                    number_format($item['price'] * $item['qty'], 2)
                ));
            }

            // Print Information card
            if ($invoice->payment === "Card" || $invoice->payment === "Multi") {
                $note = json_decode($invoice->note, true);
                $printer->text("---------------------------------------\n");
                $name = "Name        : " . $note['nama_pemegang_kartu'];
                $nocard = "Card Number : " . $note['nomor_kartu'];
                $printer->text("$nocard\n");
                $printer->text("$name\n");
            }

            $printer->setJustification(0);
            $padding = 14; // Number of spaces before the text
            $printer->text("---------------------------------------\n");
            $subTotals = "SubTotal  : " . number_format($subTotalitems, 2);
            $grandTotal = "GrandTotal: " . number_format($grandTotal, 2);

            // Add padding before the text to ensure it starts at character 12
            $rightAlignedSubtotal = str_repeat(' ', $padding) . $subTotals;
            $rightAlignedGrandTotal = str_repeat(' ', $padding) . $grandTotal;
            $printer->text("$rightAlignedSubtotal\n");
            $printer->text("$rightAlignedGrandTotal\n");
            $cash = "Cash      : " . number_format($cash, 2);
            $card = "Card      : " . number_format($card, 2);
            $change = "Change    : " . $changeFormatted;
            // Add padding before the text to ensure it starts at character 12
            $rightAlignedCash = str_repeat(' ', $padding) . $cash;
            $rightAlignedCard = str_repeat(' ', $padding) . $card;
            $rightAlignedChange = str_repeat(' ', $padding) . $change;


            $printer->text("$rightAlignedCard\n");
            $printer->text("$rightAlignedCash\n");
            $printer->text("$rightAlignedChange\n");
            $printer->text("---------------------------------------\n");


            // Handled by
            $printer->text("---------------------------------------\n");
            $printer->text("$handledBy\n");

            // Thank you message
            $printer->setJustification(Printer::JUSTIFY_CENTER);
            $printer->text("---------------------------------------\n");
            $footer = $setting->receipt_footer;
            $lines = explode('\n', $footer);

            foreach ($lines as $line) {
                $printer->text($line . "\n");
            }

            $printer->text("THANK YOU\n\n\n\n"); // Send a form feed character

            $printer->text("( _ _ _ _ _ _ _ _ _ _ _ )");

            $printer->feed(2); // Adjust the number of lines as needed

            // Cut the receipt
            $printer->cut();

            // Close the printer
            $printer->close();
        } catch (Exception $e) {
            // Handle the printing error here, you can log the error or display a message
            // dd($e);
            $this->dispatch('printernotfound');
        }
    }

    // #[On('getDetailInvoice')]
    public function dispatchToDetail($data)
    {
        $this->invoiceNo = true;
        $datadetail = DB::table('Luv2_invoice_detail')
            ->leftJoin('Luv2_salesemp', 'Luv2_invoice_detail.sales_code', '=', DB::raw('CAST("Luv2_salesemp"."code" AS VARCHAR)'))
            ->leftJoin('Luv2_member', 'Luv2_invoice_detail.member_code', '=', 'Luv2_member.code')
            ->where('Luv2_invoice_detail.no', $data)
            ->select(
                'Luv2_invoice_detail.*',
                'Luv2_salesemp.name as sales_name',
                'Luv2_member.name as member_name'
            )
            ->get();


        $this->datadetail = $datadetail;
        $this->dispatch('modalDetail', $this->datadetail);
        $this->dispatch('toDetail');
    }

    #[On('toDetail')]
    public function openModalnya()
    {

        $this->dispatch('refreshjs');
        $this->dispatch('openModal');
    }

    #[On('closeModal')]
    public function tutupModalnya()
    {
        $this->invoiceNo = false;
        $this->datadetail = '';
        $this->dispatch('closeModalweb');
    }

    public function clickgetSAPInvoice()
    {
        $this->loadingsap = true;
        $this->dispatch('getSAPInvoice');
    }

    #[On('redirect')]
    public function finishh()
    {
        sleep(1);
        return redirect()->route('report.reportinvoicereturnsale');
    }

    public function selectType()
    {
        $this->selectedType = true;
        $this->dispatch('refreshjs');
    }

    public function toPrint($no)
    {
        $this->dispatch('toPrintBrowser', $no);
    }
}
