<?php

namespace App\Livewire\Report\Analysis;

use App\Exports\ReportLossSales;
use App\Models\Company;
use App\Models\Pricelist;
use App\Models\Udf;
use App\Models\Warehouse;
use Carbon\Carbon;
use DateTime;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;

class LossSales extends Component
{
    use LivewireAlert;

    public $from_date;
    public $to_date;
    public $id_pricelist;
    public $whsCheckboxes = [];
    public $whsSelectAll = false;
    public $flagWhs = true;
    public $udfCheckboxes = [];
    public $udfSelectAll = false;
    public $udfs;
    public $udf2s;
    public $udf3s;
    public $udf_column = [];
    public $filterby = '';
    public $filterby2 = '';
    public $filterby3 = '';
    public $filter = '';
    public $filter2 = '';
    public $filter3 = '';
    public $filterfield;
    public $filtername;
    public $filterfield2;
    public $filtername2;
    public $filterfield3;
    public $filtername3;
    public $tableName = '';
    public $issearch = false;
    public $searchby = '';
    public $searchby2 = '';
    public $searchby3 = '';
    public $search1 = [];
    public $search2 = [];
    public $search3 = [];

    public $searchCheckboxes1 = [];
    public $searchSelectAll1 = false;
    public $flagFilter1 = true;
    public $searchCheckboxes2 = [];
    public $searchSelectAll2 = false;
    public $flagFilter2 = true;
    public $searchCheckboxes3 = [];
    public $searchSelectAll3 = false;
    public $flagFilter3 = true;

    public $brand;
    public $brands;

    public function mount()
    {
        $this->from_date = Carbon::now()->format('Y-m-d');
        $this->to_date = Carbon::now()->format('Y-m-d');
    }

    public function render()
    {
        $whs = [];
        $udfs = [];
        $this->brand = '';
        $this->brands = [];

        try {
            $whs = null;
            $whs = Warehouse::where('company_code', auth()->user()->company_code)->where('active', 'Y')->orderBy('name', 'asc')->get();

            if (session('partner') == '') {
                $udfs = collect([
                    (object)['field' => 'brand_code', 'name' => 'Brand'],
                    (object)['field' => 'category_code', 'name' => 'Category'],
                    (object)['field' => 'size_code', 'name' => 'Size']
                ])->merge(
                    DB::table('Luv2_udf')
                        ->where('company_code', auth()->user()->company_code)
                        ->where('active', 'Y')
                        ->get()
                )->sortBy('name');
                $brands = [];
            } else {
                $udfs = collect([
                    (object)['field' => 'brand_code', 'name' => 'Brand'],
                    (object)['field' => 'category_code', 'name' => 'Category'],
                    (object)['field' => 'size_code', 'name' => 'Size']
                ])->merge(
                    DB::table('Luv2_udf')
                        ->where('company_code', auth()->user()->company_code)
                        ->where('active', 'Y')
                        ->get()
                )->sortBy('name');

                //$udfs = DB::table('Luv2_udf')->where('company_code', auth()->user()->company_code)->where('active', 'Y')->where('field', '<>', session('column'))->orderBy('name', 'asc')->get();

                // $this->brands = DB::select("
                //     select \"brand\" from \"Luv2_partner\" where \"id_company\"='" . session('id_company') . "' and \"username\"='" . session('username') . "'
                //     ");

                // $this->brand = $this->brands[0]->brand;

                // $brands = $this->brands;
                $brands = [];
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);

            $this->dispatch('home');
        }

        $this->udfs = $udfs;

        return view('livewire.report.analysis.loss-sales', [
            'whs' => $whs,
            'udfs' => $udfs,
            'brands' => $brands,
        ]);
    }

    public function updatedFilterby()
    {
        if ($this->filterby == '') {
            $this->filterby2 = '';
            $this->filterby3 = '';
        } else {
            list($this->filterfield, $this->filtername) = explode('|', $this->filterby);
            $this->searchby = $this->filtername;

            try {
                $this->udf2s = collect([
                    (object)['field' => 'brand_code', 'name' => 'Brand'],
                    (object)['field' => 'category_code', 'name' => 'Category'],
                    (object)['field' => 'size_code', 'name' => 'Size']
                ])->merge(
                    DB::table('Luv2_udf')
                        ->where('company_code', auth()->user()->company_code)
                        ->where('active', 'Y')
                        ->get()
                )->where('field', '<>', $this->filterfield)
                    ->sortBy('name');

                if ($this->filterfield == 'brand_code' || $this->filterfield == 'category_code' || $this->filterfield == 'size_code') {
                    $this->search1 = DB::table('Luv2_item')
                        ->join('Luv2_' . str_replace('_code', '', $this->filterfield), function ($join) {
                            $join->on('Luv2_item.' . str_replace('_code', '', $this->filterfield) . '_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield) . '.code')
                                ->on('Luv2_item.company_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield) . '.company_code');
                        })
                        ->select('Luv2_' . str_replace('_code', '', $this->filterfield) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield) . '.name')
                        ->where('Luv2_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_item.active', 'Y')
                        ->groupBy('Luv2_' . str_replace('_code', '', $this->filterfield) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield) . '.name')
                        ->orderBy('Luv2_' . str_replace('_code', '', $this->filterfield) . '.name')
                        ->get();
                } else {
                    $this->search1 = DB::table('Luv2_udf_item')
                        ->join('Luv2_udf', function ($join) {
                            $join->on('Luv2_udf_item.code_udf', '=', 'Luv2_udf.code')
                                ->on('Luv2_udf_item.company_code', '=', 'Luv2_udf.company_code');
                        })
                        ->select('Luv2_udf_item.value as code', 'Luv2_udf_item.value as name')
                        ->where('Luv2_udf_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_udf.field', $this->filterfield)
                        ->where('Luv2_udf_item.value', '<>', '')
                        ->groupBy('Luv2_udf_item.value')
                        ->orderBy('Luv2_udf_item.value')
                        ->get();
                }
            } catch (Exception $ex) {
                $this->alert('error', $ex->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 2500,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public function updatedFilterby2()
    {
        if ($this->filterby2 == '') {
            $this->filterby3 = '';
        } else {
            list($this->filterfield2, $this->filtername2) = explode('|', $this->filterby2);
            $this->searchby2 = $this->filtername2;

            try {
                $this->udf3s = collect([
                    (object)['field' => 'brand_code', 'name' => 'Brand'],
                    (object)['field' => 'category_code', 'name' => 'Category'],
                    (object)['field' => 'size_code', 'name' => 'Size']
                ])->merge(
                    DB::table('Luv2_udf')
                        ->where('company_code', auth()->user()->company_code)
                        ->where('active', 'Y')
                        ->get()
                )->where('field', '<>', $this->filterfield)
                    ->where('field', '<>', $this->filterfield2)
                    ->sortBy('name');

                if ($this->filterfield2 == 'brand_code' || $this->filterfield2 == 'category_code' || $this->filterfield2 == 'size_code') {
                    $this->search2 = DB::table('Luv2_item')
                        ->join('Luv2_' . str_replace('_code', '', $this->filterfield2), function ($join) {
                            $join->on('Luv2_item.' . str_replace('_code', '', $this->filterfield2) . '_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield2) . '.code')
                                ->on('Luv2_item.company_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield2) . '.company_code');
                        })
                        ->select('Luv2_' . str_replace('_code', '', $this->filterfield2) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield2) . '.name')
                        ->where('Luv2_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_item.active', 'Y')
                        ->groupBy('Luv2_' . str_replace('_code', '', $this->filterfield2) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield2) . '.name')
                        ->orderBy('Luv2_' . str_replace('_code', '', $this->filterfield2) . '.name')
                        ->get();
                } else {
                    $this->search2 = DB::table('Luv2_udf_item')
                        ->join('Luv2_udf', function ($join) {
                            $join->on('Luv2_udf_item.code_udf', '=', 'Luv2_udf.code')
                                ->on('Luv2_udf_item.company_code', '=', 'Luv2_udf.company_code');
                        })
                        ->select('Luv2_udf_item.value as code', 'Luv2_udf_item.value as name')
                        ->where('Luv2_udf_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_udf.field', $this->filterfield2)
                        ->where('Luv2_udf_item.value', '<>', '')
                        ->groupBy('Luv2_udf_item.value')
                        ->orderBy('Luv2_udf_item.value')
                        ->get();
                }
            } catch (Exception $ex) {
                $this->alert('error', $ex->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 2500,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public function updatedFilterby3()
    {
        if ($this->filterby3 != '') {
            list($this->filterfield3, $this->filtername3) = explode('|', $this->filterby3);
            $this->searchby3 = $this->filtername3;

            try {
                if ($this->filterfield3 == 'brand_code' || $this->filterfield3 == 'category_code' || $this->filterfield3 == 'size_code') {
                    $this->search3 = DB::table('Luv2_item')
                        ->join('Luv2_' . str_replace('_code', '', $this->filterfield3), function ($join) {
                            $join->on('Luv2_item.' . str_replace('_code', '', $this->filterfield3) . '_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield3) . '.code')
                                ->on('Luv2_item.company_code', '=', 'Luv2_' . str_replace('_code', '', $this->filterfield3) . '.company_code');
                        })
                        ->select('Luv2_' . str_replace('_code', '', $this->filterfield3) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield3) . '.name')
                        ->where('Luv2_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_item.active', 'Y')
                        ->groupBy('Luv2_' . str_replace('_code', '', $this->filterfield3) . '.code', 'Luv2_' . str_replace('_code', '', $this->filterfield3) . '.name')
                        ->orderBy('Luv2_' . str_replace('_code', '', $this->filterfield3) . '.name')
                        ->get();
                } else {
                    $this->search3 = DB::table('Luv2_udf_item')
                        ->join('Luv2_udf', function ($join) {
                            $join->on('Luv2_udf_item.code_udf', '=', 'Luv2_udf.code')
                                ->on('Luv2_udf_item.company_code', '=', 'Luv2_udf.company_code');
                        })
                        ->select('Luv2_udf_item.value as code', 'Luv2_udf_item.value as name')
                        ->where('Luv2_udf_item.company_code', auth()->user()->company_code)
                        ->where('Luv2_udf.field', $this->filterfield3)
                        ->where('Luv2_udf_item.value', '<>', '')
                        ->groupBy('Luv2_udf_item.value')
                        ->orderBy('Luv2_udf_item.value')
                        ->get();
                }
            } catch (Exception $ex) {
                $this->alert('error', $ex->getMessage(), [
                    'position' => 'top-end',
                    'timer' => 2500,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public function checkData()
    {
        $check = false;

        if (session('partner') == '') {
            $this->validate([
                'from_date' => 'required',
                'to_date' => 'required'
            ]);

            $check = true;

            $this->flagWhs = false;
            if ($this->whsSelectAll) {
                $this->flagWhs = true;
                $check = true;
            } else {
                $trueValues = array_filter($this->whsCheckboxes, function ($value) {
                    return $value === true;
                });

                $i = 0;
                foreach ($trueValues as $key) {
                    $i++;
                }

                if ($i > 0) {
                    $this->flagWhs = true;
                    $check = true;
                } else {
                    $this->flagWhs = false;
                    $check = false;
                }
            }
        } else {
            $this->validate([
                'from_date' => 'required',
                'to_date' => 'required',
            ]);

            $check = true;
        }

        if ($check) {
            $this->dispatch('setData');
        }
    }

    #[On('setData')]
    public function setData()
    {
        $this->issearch = true;
        $this->dispatch('getData');
    }

    #[On('getData')]
    public function getData()
    {
        try {
            $user = auth()->user()->id;
            //$this->tableName = auth()->user()->id . "_" . Carbon::now()->format('ymdHis');
            $this->tableName = $user . "_" . Carbon::now()->format('ymdHis');

            $whs = '';

            if (session('partner') == '') {
                if ($this->whsSelectAll) {
                    $whsList = Warehouse::where('company_code', auth()->user()->company_code)->where('active', 'Y')->orderBy('name', 'asc')->get();

                    foreach ($whsList as $wh) {
                        $whs .= "'" . $wh->code . "',";
                    }
                } else {
                    $trueValues = array_filter($this->whsCheckboxes, function ($value) {
                        return $value === true;
                    });

                    foreach ($trueValues as $key => $value) {
                        $whs .= "'" . $key . "',";
                    }
                }

                if ($whs != "") {
                    $whs = " where a.\"whs_code\" in (" . rtrim($whs, ',') . ")";
                }
            } else {
                $whs = " where b.\"" . session('column') . "\"='" . $this->brand . "'";
            }

            $queryFilter1 = '';
            $queryFilterUdf1 = '';
            if ($this->filterby != '') {
                list($this->filterfield, $this->filtername) = explode('|', $this->filterby);
                // $queryFilter1 = " and upper(b.\"" . $this->filterfield . "\")=upper('" . $this->filter . "')";

                if ($this->filterfield == 'brand_code' || $this->filterfield == 'category_code' || $this->filterfield == 'size_code') {
                    if ($this->searchSelectAll1) {
                        $queryFilter1 = " and b.\"" . $this->filterfield . "\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes1, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilter1 .= "'" . $key . "',";
                        }

                        if ($queryFilter1 != '') {
                            $queryFilter1 = " and b.\"" . $this->filterfield . "\" in (" . rtrim($queryFilter1, ',') . ")";
                        }
                    }
                } else {
                    $code = DB::table('Luv2_udf')->where('field', $this->filterfield)->where('company_code', auth()->user()->company_code)->first();

                    if ($this->searchSelectAll1) {
                        $queryFilterUdf1 = " and d.\"code_udf\"='" . $this->filterfield . "' and d.\"value\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes1, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilterUdf1 .= "'" . $key . "',";
                        }

                        if ($queryFilterUdf1 != '') {
                            $queryFilterUdf1 = " and \"code_udf\"='" . $code->code . "' and \"value\" in (" . rtrim($queryFilterUdf1, ',') . ")";
                        }
                    }
                }
            }

            $queryFilter2 = '';
            $queryFilterUdf2 = '';
            if ($this->filterby2 != '') {
                list($this->filterfield2, $this->filtername2) = explode('|', $this->filterby2);
                // $queryFilter2 = " and upper(b.\"" . $this->filterfield2 . "\")=upper('" . $this->filter2 . "')";

                if ($this->filterfield2 == 'brand_code' || $this->filterfield2 == 'category_code' || $this->filterfield2 == 'size_code') {
                    if ($this->searchSelectAll2) {
                        $queryFilter2 = " and b.\"" . $this->filterfield2 . "\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes2, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilter2 .= "'" . $key . "',";
                        }

                        if ($queryFilter2 != '') {
                            $queryFilter2 = " and b.\"" . $this->filterfield2 . "\" in (" . rtrim($queryFilter2, ',') . ")";
                        }
                    }
                } else {
                    $code = DB::table('Luv2_udf')->where('field', $this->filterfield2)->where('company_code', auth()->user()->company_code)->first();

                    if ($this->searchSelectAll2) {
                        $queryFilterUdf2 = " and d.\"code_udf\"='" . $this->filterfield2 . "' and d.\"value\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes2, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilterUdf2 .= "'" . $key . "',";
                        }

                        if ($queryFilterUdf2 != '') {
                            $queryFilterUdf2 = " and \"code_udf\"='" . $code->code . "' and \"value\" in (" . rtrim($queryFilterUdf2, ',') . ")";
                        }
                    }
                }
            }

            $queryFilter3 = '';
            $queryFilterUdf3 = '';
            if ($this->filterby3 != '') {
                list($this->filterfield3, $this->filtername3) = explode('|', $this->filterby3);
                // $queryFilter3 = " and upper(b.\"" . $this->filterfield3 . "\")=upper('" . $this->filter3 . "')";

                if ($this->filterfield3 == 'brand_code' || $this->filterfield3 == 'category_code' || $this->filterfield3 == 'size_code') {
                    if ($this->searchSelectAll3) {
                        $queryFilter3 = " and b.\"" . $this->filterfield3 . "\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes3, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilter3 .= "'" . $key . "',";
                        }

                        if ($queryFilter3 != '') {
                            $queryFilter3 = " and b.\"" . $this->filterfield3 . "\" in (" . rtrim($queryFilter3, ',') . ")";
                        }
                    }
                } else {
                    $code = DB::table('Luv2_udf')->where('field', $this->filterfield3)->where('company_code', auth()->user()->company_code)->first();

                    if ($this->searchSelectAll3) {
                        $queryFilterUdf3 = " and \"code_udf\"='" . $this->filterfield3 . "' and \"value\" like '%'";
                    } else {
                        $trueValues = array_filter($this->searchCheckboxes3, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $queryFilterUdf3 .= "'" . $key . "',";
                        }

                        if ($queryFilterUdf3 != '') {
                            $queryFilterUdf3 = " and d.\"code_udf\"='" . $code->code . "' and d.\"value\" in (" . rtrim($queryFilterUdf3, ',') . ")";
                        }
                    }
                }
            }

            $fromDate = Carbon::parse($this->from_date);
            $toDate = Carbon::parse($this->to_date);
            // $dateDifference = $fromDate->diffInDays($toDate);


            $dates = [];
            while ($fromDate->lte($toDate)) {
                $dates[] = $fromDate->toDateString();
                $fromDate->addDay();
            }

            $query = "insert into \"" . $this->tableName . "\" select y.*,case when y.\"stocknullcount\">0 then FLOOR(y.\"stocknullcount\"*y.\"avgsales\") else 0 end \"losssales\" from (select x.*,case when x.\"stockcount\">0 then x.\"salestotal\"/x.\"stockcount\" else 0 end \"avgsales\" from (select z.*,(";
            //$query = "select y.*,case when y.\"stockcount\">0 then FLOOR(y.\"stockcount\"*y.\"avgsales\") else 0 end \"losssales\" from (select x.*,x.\"salestotal\"/x.\"salescount\" \"avgsales\" from (select z.*,(";

            foreach ($dates as $date) {
                $dateFormatted = Carbon::parse($date)->format('ymd');
                $query .= "CASE WHEN \"stock" . $dateFormatted . "\">0 THEN 1 ELSE 0 END + ";
            }

            $query = substr($query, 0, -3);

            $query .= ") \"stockcount\",(";

            foreach ($dates as $date) {
                $dateFormatted = Carbon::parse($date)->format('ymd');
                $dateFormatted2 = Carbon::parse($date)->format('Y-m-d');
                $query .= "CASE WHEN \"stock" . $dateFormatted . "\"<=0 and '" . $dateFormatted2 . "'>=\"indate\" THEN 1 ELSE 0 END + ";
            }

            $query = substr($query, 0, -3);

            $query .= ") \"stocknullcount\",(";

            foreach ($dates as $date) {
                $dateFormatted = Carbon::parse($date)->format('ymd');
                $dateFormatted2 = Carbon::parse($date)->format('Y-m-d');
                $query .= "CASE WHEN \"sales" . $dateFormatted . "\">0 and '" . $dateFormatted2 . "'>=\"indate\" THEN 1 ELSE 0 END + ";
            }

            $query = substr($query, 0, -3);

            $query .= ") \"salescount\" from (select a.\"whs_code\" \"whscode\",c.\"name\" \"whs\",a.\"item_code\" \"code\",b.\"barcode\",b.\"name\",coalesce((select min(i.\"date\") from \"Luv2_transfer\" i inner join \"Luv2_transfer_detail\" j on i.\"no\"=j.\"no\" and i.\"company_code\"=j.\"company_code\" where a.\"item_code\"=j.\"item_code\"),null) \"indate\",";

            foreach ($dates as $date) {
                $dateFormatted = Carbon::parse($date)->format('ymd');
                $query .= "sum(case when a.\"date\"='" . $date . "' and a.\"tipe\"='4' then a.\"qty\" else 0 end)*-1 \"sales" . $dateFormatted . "\",
                sum(case when a.\"date\"<='" . $date . "' then a.\"qty\" else 0 end) \"stock" . $dateFormatted . "\",";
            }

            if ($queryFilterUdf1 != '' || $queryFilterUdf2 != '' || $queryFilterUdf3 != '') {
                $query .= "sum(case when a.\"date\" between '" . $this->from_date . "' and '" . $this->to_date . "' and a.\"tipe\"='4' then a.\"qty\" else 0 end)*-1 \"salestotal\" from \"Luv2_item_trans\" a 
                    inner join \"Luv2_item\" b on a.\"item_code\"=b.\"code\" and a.\"company_code\"=b.\"company_code\" 
                    inner join \"Luv2_warehouse\" c on a.\"whs_code\"=c.\"code\" and a.\"company_code\"=c.\"company_code\"
                    inner join (
                        select item_code, company_code
                        from \"Luv2_udf_item\" 
                        where company_code='" . session("company_code") . "'" . $queryFilterUdf1 . $queryFilterUdf2 . $queryFilterUdf3 . "
                        group by item_code, company_code
                        having count(distinct code_udf) = " . (
                    ($queryFilterUdf1 != '' ? 1 : 0) +
                    ($queryFilterUdf2 != '' ? 1 : 0) +
                    ($queryFilterUdf3 != '' ? 1 : 0)
                ) . "
                    ) d on b.\"code\"=d.\"item_code\" and b.\"company_code\"=d.\"company_code\""
                    . $whs . $queryFilter1 . $queryFilter2 . $queryFilter3
                    . " group by a.\"whs_code\",c.\"name\",a.\"item_code\",b.\"barcode\",b.\"name\" order by a.\"whs_code\",c.\"name\") z where \"salestotal\"<>0) x) y;";
            } else {
                $query .= "sum(case when a.\"date\" between '" . $this->from_date . "' and '" . $this->to_date . "' and a.\"tipe\"='4' then a.\"qty\" else 0 end)*-1 \"salestotal\" from \"Luv2_item_trans\" a inner join \"Luv2_item\" b on a.\"item_code\"=b.\"code\" and a.\"company_code\"=b.\"company_code\" inner join \"Luv2_warehouse\" c on a.\"whs_code\"=c.\"code\" and a.\"company_code\"=c.\"company_code\"" .  $whs . $queryFilter1 . $queryFilter2 . $queryFilter3 . " group by a.\"whs_code\",c.\"name\",a.\"item_code\",b.\"barcode\",b.\"name\" order by a.\"whs_code\",c.\"name\") z where \"salestotal\"<>0) x) y;";
            }

            $dateColumns = '';
            foreach ($dates as $date) {
                $formattedDate = Carbon::parse($date)->format('ymd');
                $dateColumns .= ", \"sales" . $formattedDate . "\" numeric, \"stock" . $formattedDate . "\" numeric";
            }

            DB::statement('DROP TABLE IF EXISTS "' . $this->tableName . '";');
            DB::statement('
                        CREATE TABLE "' . $this->tableName . '" (
                            "whscode" varchar(8),
                            "whs" varchar(100),
                            "code" varchar(30),
                            "barcode" varchar(255),
                            "name" varchar(100),
                            "indate" date'
                . $dateColumns . ',
                            "salestotal" numeric,
                            "stockcount" numeric,
                            "stocknullcount" numeric,
                            "salescount" numeric,
                            "avgsales" numeric,
                            "losssales" numeric);');


            DB::statement($query);
            $total_losssales = DB::table($this->tableName)->sum('losssales');
            $check = DB::table($this->tableName)->first();

            if ($check) {
                $this->dispatch('showTable', $this->tableName, $total_losssales, $dates, $this->from_date, $this->to_date)->to(LossSalesTable::class);
            } else {
                $this->alert('warning', 'No data to show', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->issearch = false;
    }

    #[On('refreshData')]
    public function refreshData()
    {
        $this->dispatch('refresh');
    }

    public function updateWhsCheckboxes($i)
    {
        $this->whsCheckboxes[$i] = !$this->checkboxes[$i];
    }

    public function updateUdfCheckboxes($i)
    {
        $this->udfCheckboxes[$i] = !$this->checkboxes[$i];
    }

    public function updateSearchCheckboxes1($i)
    {
        $this->searchCheckboxes1[$i] = !$this->checkboxes[$i];
    }

    public function updateSearchCheckboxes2($i)
    {
        $this->searchCheckboxes2[$i] = !$this->checkboxes[$i];
    }

    public function updateSearchCheckboxes3($i)
    {
        $this->searchCheckboxes3[$i] = !$this->checkboxes[$i];
    }

    public function exportData()
    {
        try {
            $fromDate = DateTime::createFromFormat('Y-m-d', $this->from_date)->format('d M Y');
            $toDate = DateTime::createFromFormat('Y-m-d', $this->to_date)->format('d M Y');

            $period = $this->from_date == $this->to_date ? $fromDate : $fromDate . ' - ' . $toDate;
            $filename = "Loss Sales Report {$period}.xlsx";
            $this->dispatch('refresh');
            return Excel::download(new ReportLossSales($this->data, $period, $this->udf_column), $filename);
        } catch (Exception $ex) {
            dd($ex);
        }
    }

    #[On('home')]
    public function home()
    {
        sleep(2.5);
        return $this->redirect('/dashboard');
    }
}
