<?php

namespace App\Livewire\Promo;

use App\Models\Promo;
use Exception;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class PromoTable extends Component
{
    use LivewireAlert;

    public $promo = [];
    public $status = 'Y';

    public function mount()
    {
        session(['company_code' => auth()->user()->company_code]);
        session(['userId' => auth()->user()->id]);
        $this->promo = [];
        
        try {
            $status = '';
            if ($this->status == 'Y') {
                $status = " and current_date between a.\"from_date\" and a.\"to_date\"";
            } elseif ($this->status == 'N') {
                $status = " and current_date not between a.\"from_date\" and a.\"to_date\"";
            }

            $this->promo = DB::select("
                select a.\"no\",a.\"name\",a.\"from_date\",a.\"to_date\",a.\"tipe\",coalesce((select \"name\" from \"Luv2_pricelist\" where \"code\"=a.\"pricelist_code\" and \"company_code\"=a.\"company_code\"),'All Pricelist') \"pricelist\",case when current_date between a.\"from_date\" and a.\"to_date\" then 'Active' else 'Inactive' end \"status\"
                from \"Luv2_promo\" a
                where deleted='N' and company_code='" . session('company_code') . "'" . $status . "
                order by a.\"no\" desc;
                ");
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('back');
        }

        $this->dispatch('getDataDone');
    }

    public function render()
    {
        $promos = $this->promo;
        return view('livewire.promo.promo-table', compact('promos'));
    }

    public function updated()
    {
        $this->dispatch('getData');
    }

    #[On('getData')]
    public function getData()
    {
        $this->promo = [];

        try {
            $status = '';
            if ($this->status == 'Y') {
                $status = " and current_date between a.\"from_date\" and a.\"to_date\"";
            } elseif ($this->status == 'N') {
                $status = " and current_date not between a.\"from_date\" and a.\"to_date\"";
            }

            $this->promo = DB::select("
                select a.\"no\",a.\"name\",a.\"from_date\",a.\"to_date\",a.\"tipe\",coalesce((select \"name\" from \"Luv2_pricelist\" where \"code\"=a.\"pricelist_code\" and \"company_code\"=a.\"company_code\"),'All Pricelist') \"pricelist\",case when current_date between a.\"from_date\" and a.\"to_date\" then 'Active' else 'Inactive' end \"status\"
                from \"Luv2_promo\" a
                where deleted='N' and company_code='" . session('company_code') . "'" . $status . "
                order by a.\"no\" desc;
                ");
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
        $this->dispatch('getDataDone');
    }

    #[On('getDataDone')]
    public function getDataDone()
    {
        $this->dispatch('refreshTable');
    }

    public function delete(string $no)
    {
        try {
            $promo = Promo::findOrFail($no);

            if ($promo) {
                DB::statement("
            UPDATE \"Luv2_promo\" set \"deleted\"='Y' where \"no\"='" . $no . "';
            ");

                $this->alert('success', 'Promo has been deleted', [
                    'position' => 'top-end',
                    'timer' => 2500,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);

                $this->dispatch('home');
            } else {
                $this->alert('warning', 'Promo not found', [
                    'position' => 'top-end',
                    'timer' => 2500,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    #[On('editPromo')]
    public function editPromo($promoNo)
    {
        session()->put('noPromo', $promoNo);
        $this->redirect('/promo/edit/' . $promoNo);
    }

    #[On('home')]
    public function home()
    {
        sleep(2.5);
        return $this->redirect('/promo');
    }
}
