<?php

namespace App\Livewire\Promo;

use App\Models\PromoGwpItem as ModelsPromoGwpItem;
use App\Models\PromoGwpItemTemp;
use Exception;
use Illuminate\Foundation\Auth\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Livewire\Component;

class PromoGwpItem extends Component
{
    public $tipe;

    public function mount($tipe)
    {
        $this->tipe = $tipe;
    }
    public function render()
    {
        $items = [];

        try {
            $items = PromoGwpItemTemp::where('company_code', session('company_code'))
                ->where('id_user', session('userId'))
                ->where('tipe', $this->tipe)
                ->get();
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
        return view('livewire.promo.promo-gwp-item', compact('items'));
    }

    #[On('refreshItem')]
    public function refreshItem()
    {
    }

    public function delete(string $item_code)
    {
        try {
            DB::statement("
            DELETE FROM \"Luv2_promo_item_gwp_temp\"
            WHERE \"company_code\"='" . session('company_code') . "'
            AND \"id_user\"='" . session('userId') . "'
            AND \"tipe\"='" . $this->tipe . "'
            AND \"item_code\"='" . $item_code . "';
            ");

            $this->dispatch('refreshItem');
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }
}
