<?php

namespace App\Livewire\Promo;

use App\Models\Pricelist;
use App\Models\PromoBundlingQtyTemp;
use App\Models\PromoDetailTemp;
use App\Models\PromoGwpItemTemp;
use App\Models\PromoItem;
use App\Models\PromoItemQtyTemp;
use App\Models\PromoItemTemp;
use App\Models\PromoVoucherTemp;
use App\Models\Warehouse;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Support\Str;
use Jantinnerezo\LivewireAlert\LivewireAlert;

use function Laravel\Prompts\error;

class PromoEdit extends Component
{
    use LivewireAlert;
    use WithFileUploads;

    public $no;
    public $add = true;
    public $tipe;
    public $i = 0;
    public $qty_pack = 1;
    public $pack = 0;
    public $value_pack = 0;
    public $name;
    public $from_date;
    public $to_date;
    public $voucher_from_date;
    public $voucher_to_date;
    public $id_pricelist;
    public $whsCheckboxes = [];
    public $whsSelectAll = false;
    public $flagWhs = true;
    public $whsList;
    public $bundling_benefit_disc = 0;
    public $bundling_benefit_price = 0;

    public $file;
    public $fileQty;
    public $import = false;
    public $editItem = false;

    public $gwp_search_by;
    public $gwp_disc_by;
    public $gwp_item_code = "";
    public $gwp_search_code = false;
    public $gwp_item_barcode = "";
    public $gwp_search_barcode = false;
    public $gwp_item_name;
    public $gwp_item_disc;
    public $gwp_item_price;

    public $search_by;
    public $create_by;
    public $packCheckboxes = [];
    public $packSelectAll = false;
    public $flagPack = true;
    public $item_code = "";
    public $search_code = false;
    public $item_barcode = "";
    public $search_barcode = false;
    public $item_name = "";
    public $item_nprice;
    public $item_disc;
    public $item_price;
    public $item_qty_qty;
    public $item_qty_disc;
    public $item_qty_price;
    public $bundling_qty_qty;
    public $bundling_qty_disc;

    public $create_by_voucher_no;
    public $create_by_voucher_batch = 0;
    public $create_by_voucher_value = 0;

    public $bundling_benefit;
    public $gwp_benefit;

    public $gwp_benefit_item = '';
    public $gwp_benefit_voucher = 0;
    public $flag;
    public $flagImport;
    public $item_qty_check;

    public $errorDetail = "";
    public $errorGWPFreeItem = "";
    public $errorBundlingQty = "";

    public function mount()
    {
        try {
            $this->add = false;
            $this->no = session('noPromo');
            $no = $this->no;

            $promoheader = DB::table('Luv2_promo')
                ->where('no', $no)
                ->first();

            // $this->no = $no;
            $this->tipe = $promoheader->tipe;
            // $this->name = $promoheader->name;
            // $this->item_name = $promoheader->name;
            // $this->from_date = $promoheader->from_date;
            // $this->to_date = $promoheader->to_date;
            // $this->id_pricelist = $promoheader->id_pricelist;
            $this->flag = true;
            $this->search_by = 1;
            $this->create_by = 1;
            $this->gwp_search_by = 1;
            $this->gwp_disc_by = 1;
            $this->gwp_item_disc = 0;
            $this->gwp_item_price = 0;

            if ($this->tipe == 3) {
                $this->qty_pack = $promoheader->qty_pack;
                $this->bundling_benefit = $promoheader->benefit;
                if ($this->bundling_benefit == 1) {
                    $this->bundling_benefit_disc = $promoheader->disc;
                } else {
                    $this->bundling_benefit_price = $promoheader->disc_price;
                }
            }

            if ($this->tipe == 4) {
                $this->qty_pack = $promoheader->qty_pack;
                $this->gwp_benefit = $promoheader->benefit;
                if ($this->gwp_benefit == 1) {
                    $this->dispatch('refreshItem')->to(PromoGwpItem::class);
                } elseif ($this->gwp_benefit == 3) {
                    $this->gwp_benefit_voucher = $promoheader->voucher;
                    $this->voucher_from_date = $promoheader->voucher_from_date;
                    $this->voucher_to_date = $promoheader->voucher_to_date;
                }
            }

            if ($this->tipe == 5) {
                $this->value_pack = $promoheader->value_pack;
                $this->gwp_benefit = $promoheader->benefit;
                if ($this->gwp_benefit == 1) {
                    $this->dispatch('refreshItem')->to(PromoGwpItem::class);
                } elseif ($this->gwp_benefit == 3) {
                    $this->gwp_benefit_voucher = $promoheader->voucher;
                    $this->voucher_from_date = $promoheader->voucher_from_date;
                    $this->voucher_to_date = $promoheader->voucher_to_date;
                }
            }

            $whsEdit = DB::select("
            select * from \"Luv2_promo_whs\" where no='" . $no . "';
            ");

            foreach ($whsEdit as $wh) {
                $this->whsCheckboxes[$wh->whs_code] = true;
            }

            $this->item_nprice = 0;
            $this->item_disc = 0;
            $this->item_price = 0;
            $this->item_qty_check = false;
            $this->item_qty_qty = 0;
            $this->item_qty_disc = 0;
            $this->item_qty_price = 0;
            $this->bundling_qty_qty = 0;
            $this->bundling_qty_disc = 0;

            if ($this->tipe != 6 && $this->tipe != 5) {
                PromoItemTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->where('tipe', $this->tipe)
                    ->delete();

                DB::statement("
                INSERT INTO \"Luv2_promo_item_temp\" (\"id_user\",\"id_company\",\"item_code\",\"disc\",\"disc_price\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\",\"qty\",\"tipe\") 
                SELECT '" . session('userId') . "',\"id_company\",\"item_code\",\"disc\",\"disc_price\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\",\"qty\",'" . $this->tipe . "'
                FROM \"Luv2_promo_item\"
                WHERE \"no\"='" . $no . "'
                ");
            } else if ($this->tipe == 6) {
                PromoVoucherTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->delete();

                DB::statement("
                INSERT INTO \"Luv2_promo_voucher_temp\" (\"id_user\",\"id_company\",\"voucher\",\"value\") 
                SELECT '" . session('userId') . "',\"id_company\",\"voucher\",\"value\"
                FROM \"Luv2_promo_voucher\"
                WHERE \"no\"='" . $no . "'
                ");
            }

            if ($this->tipe == 1 || $this->tipe == 2) {
                PromoItemQtyTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->where('tipe', $this->tipe)
                    ->delete();

                DB::statement("
                INSERT INTO \"Luv2_promo_item_qty_temp\" (\"id_user\",\"tipe\",\"id_company\",\"item_code\",\"qty\",\"disc\",\"disc_price\") 
                SELECT '" . session('userId') . "','" . $this->tipe . "',\"id_company\",\"item_code\",\"qty\",\"disc\",\"disc_price\"
                FROM \"Luv2_promo_item_qty\"
                WHERE \"no\"='" . $no . "'
                ");
            } elseif (($this->tipe == 4 || $this->tipe == 5) && $this->gwp_benefit == 1) {
                PromoGwpItemTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->where('tipe', $this->tipe)
                    ->delete();

                DB::statement("
                INSERT INTO \"Luv2_promo_item_gwp_temp\" (\"id_user\",\"tipe\",\"id_company\",\"item_code\",\"item_barcode\",\"item_name\",\"disc\",\"disc_price\") 
                SELECT '" . session('userId') . "','" . $this->tipe . "',\"id_company\",\"item_code\",\"item_barcode\",\"item_name\",\"disc\",\"disc_price\"
                FROM \"Luv2_promo_item_gwp\"
                WHERE \"no\"='" . $no . "'
                ");
            } elseif ($this->tipe == 7) {
                PromoBundlingQtyTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->delete();

                DB::statement("
                INSERT INTO \"Luv2_promo_bundling_qty_temp\" (\"id_user\",\"id_company\",\"qty\",\"disc\",\"disc_price\") 
                SELECT '" . session('userId') . "',\"id_company\",\"qty\",\"disc\",\"disc_price\"
                FROM \"Luv2_promo_bundling_qty\"
                WHERE \"no\"='" . $no . "'
                ");
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);

            $this->dispatch('home');
        }
    }

    public function render()
    {
        $pricelist = [];
        $whs = [];

        try {
            $pricelist = DB::select("
            select a.\"code\",a.\"name\"
            from \"Luv2_pricelist\" a inner join \"Luv2_warehouse\" b on a.\"code\"=b.\"id_pricelist\" and a.\"id_company\"=b.\"id_company\"
            where a.\"id_company\"='" . session('id_company') . "' and b.\"active\"='Y'
            group by a.\"code\",a.\"name\" order by a.\"code\";
            ");
            if (!$pricelist) {
                $pricelist = DB::table('Luv2_pricelist')->where('company_code', auth()->user()->company_code)->orderBy('code', 'asc')->get();
            }


            if ($this->pricelist_code == 0) {
                $whs = Warehouse::where('company_code', auth()->user()->company_code)->where('active', 'Y')->orderBy('code', 'asc')->get();
            } elseif ($this->pricelist_code > 0) {
                $whs = Warehouse::where('company_code', auth()->user()->company_code)->where('active', 'Y')->where('pricelist_code', $this->pricelist_code)->orderBy('code', 'asc')->get();
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);

            $this->dispatch('home');
        }

        return view('livewire.promo.promo-edit', [
            'pricelist' => $pricelist,
            'whs' => $whs,
        ]);
    }

    #[On('searchFlagTrue')]
    public function searchFlagTrue()
    {
        if ($this->search_by == 1) {
            $this->search_code = true;
        } else {
            $this->search_barcode = true;
        }

        $this->dispatch('searchItem');
    }

    #[On('searchFlagFalse')]
    public function searchFlagFalse()
    {
        if ($this->search_by == 1) {
            $this->search_code = false;
        } else {
            $this->search_barcode = true;
        }
    }

    #[On('searchItem')]
    public function searchItem()
    {
        try {
            $url = session('url');

            if ($this->search_by == 1) {
                $this->validate([
                    'item_code' => 'required',
                ]);

                $this->search_code = true;

                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",ifnull((select max(\"Price\") from ITM1 where a.\"ItemCode\"=\"ItemCode\" and \"PriceList\"='" . $this->id_pricelist . "'),0) \"Price\"",
                    "From" => "OITM a",
                    "Where" => "a.\"ItemCode\"='" . $this->item_code . "' limit 1;",
                ]);
            } else if ($this->search_by == 2) {
                $this->validate([
                    'item_barcode' => 'required',
                ]);

                $this->search_barcode = true;

                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",ifnull((select max(\"Price\") from ITM1 where a.\"ItemCode\"=\"ItemCode\" and \"PriceList\"='" . $this->id_pricelist . "'),0) \"Price\"",
                    "From" => "OITM a",
                    "Where" => "a.\"CodeBars\"='" . $this->item_barcode . "' limit 1;",
                ]);
            }

            if ($response->successful()) {
                $jsonData = $response->json();
                if (!empty($jsonData)) {
                    if ($jsonData[0]['ItemCode'] != '') {
                        $this->item_code = $jsonData[0]['ItemCode'];
                        $this->item_barcode = $jsonData[0]['CodeBars'];
                        $this->item_name = $jsonData[0]['ItemName'];
                        $this->item_nprice = number_format($jsonData[0]['Price']);

                        $this->item_nprice = number_format($jsonData[0]['Price']);
                        // if ($this->tipe == 1) {
                        $this->dispatch('focusNextTab');
                        // } else {
                        //     $this->dispatch('focusNextTabPrice');
                        // }
                    } else {
                        $this->alert('warning', 'Item not found on SAP', [
                            'position' => 'top-end',
                            'timer' => 3000,
                            'toast' => true,
                            'timerProgressBar' => true,
                        ]);
                    }
                } else {
                    $this->alert('warning', 'Item not found on SAP', [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            } else {
                $this->alert('error', 'Not Connect to SAP Server', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->search_code = false;
        $this->search_barcode = false;
    }

    #[On('gwp_searchFlagTrue')]
    public function gwp_searchFlagTrue()
    {
        if ($this->gwp_search_by == 1) {
            $this->gwp_search_code = true;
        } else {
            $this->gwp_search_barcode = true;
        }

        $this->dispatch('gwp_searchItem');
    }

    #[On('gwp_searchFlagFalse')]
    public function gwp_searchFlagFalse()
    {
        if ($this->gwp_search_by == 1) {
            $this->gwp_search_code = false;
        } else {
            $this->gwp_search_barcode = true;
        }
    }

    #[On('gwp_searchItem')]
    public function gwp_searchItem()
    {
        try {
            $url = session('url');

            if ($this->gwp_search_by == 1) {
                $this->validate([
                    'gwp_item_code' => 'required',
                ]);

                $this->gwp_search_code = true;

                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\"",
                    "From" => "OITM a",
                    "Where" => "a.\"ItemCode\"='" . $this->gwp_item_code . "' limit 1;",
                ]);
            } else if ($this->gwp_search_by == 2) {
                $this->validate([
                    'gwp_item_barcode' => 'required',
                ]);

                $this->gwp_search_barcode = true;

                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\"",
                    "From" => "OITM a",
                    "Where" => "a.\"CodeBars\"='" . $this->gwp_item_barcode . "' limit 1;",
                ]);
            }

            if ($response->successful()) {
                $jsonData = $response->json();
                if (!empty($jsonData)) {
                    if ($jsonData[0]['ItemCode'] != '') {
                        $this->gwp_item_code = $jsonData[0]['ItemCode'];
                        $this->gwp_item_barcode = $jsonData[0]['CodeBars'];
                        $this->gwp_item_name = $jsonData[0]['ItemName'];
                        //$this->item_nprice = number_format($jsonData[0]['Price']);
                    } else {
                        $this->alert('warning', 'Item not found on SAP', [
                            'position' => 'top-end',
                            'timer' => 3000,
                            'toast' => true,
                            'timerProgressBar' => true,
                        ]);
                    }
                } else {
                    $this->alert('warning', 'Item not found on SAP', [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            } else {
                $this->alert('error', 'Not Connect to SAP Server', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->gwp_search_code = false;
        $this->gwp_search_barcode = false;
    }

    public function addQty()
    {
        if ($this->item_qty_check) {
            if ($this->tipe == 1) {
                $this->validate([
                    'item_qty_qty' => 'required|min:0',
                    'item_qty_disc' => 'required|min:0',
                ]);
            } else if ($this->tipe == 2) {
                $this->validate([
                    'item_qty_qty' => 'required|min:0',
                    'item_qty_price' => 'required|min:0',
                ]);
            }
        }

        try {


            $check = PromoItemQtyTemp::where('id_company', session('id_company'))
                ->where('id_user', session('userId'))
                ->where('item_code', $this->item_code)
                ->where('qty', $this->item_qty_qty)
                ->where('tipe', $this->tipe)
                ->first();

            if (!$check) {
                PromoItemQtyTemp::insert([
                    'id_company' => session('id_company'),
                    'id_user' => session('userId'),
                    'item_code' => $this->item_code,
                    'tipe' => $this->tipe,
                    'qty' => str_replace(',', '', $this->item_qty_qty),
                    'disc' => $this->tipe == 1 ? str_replace(',', '', $this->item_qty_disc) : 0,
                    'disc_price' => $this->tipe == 1 ? 0 : str_replace(',', '', $this->item_qty_price),
                ]);
            } else {
                DB::table('Luv2_promo_item_qty_temp')
                    ->where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->where('item_code', $this->item_code)
                    ->where('qty', str_replace(',', '', $this->item_qty_qty))
                    ->where('tipe', $this->tipe)
                    ->update([
                        'disc' => $this->tipe == 1 ? $this->item_qty_disc : 0,
                        'disc_price' => $this->tipe == 1 ? 0 : $this->item_qty_price,
                    ]);
            }

            $this->dispatch('refreshQty')->to(PromoAddItemQty::class);

            $this->alert('success', 'Discount Qty has been modified to list', [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function addBundlingQty()
    {
        $this->validate([
            'bundling_qty_qty' => 'required|min:0',
            'bundling_qty_disc' => 'required|min:0',
        ]);

        try {


            $check = PromoBundlingQtyTemp::where('id_company', session('id_company'))
                ->where('id_user', session('userId'))
                ->where('qty', $this->bundling_qty_qty)
                ->first();

            if (!$check) {
                PromoBundlingQtyTemp::insert([
                    'id_company' => session('id_company'),
                    'id_user' => session('userId'),
                    'qty' => str_replace(',', '', $this->bundling_qty_qty),
                    'disc' => str_replace(',', '', $this->bundling_qty_disc),
                ]);
            } else {
                DB::table('Luv2_promo_bundling_qty_temp')
                    ->where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->where('qty', str_replace(',', '', $this->bundling_qty_qty))
                    ->update([
                        'disc' => $this->bundling_qty_disc,
                    ]);
            }

            $this->dispatch('refreshQty')->to(PromoAddBundlingQty::class);

            $this->alert('success', 'Bundling Qty has been modified to list', [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function addList()
    {
        $this->errorDetail = "";
        $error = false;

        if ($this->tipe == 1 || $this->tipe == 2) {
            if ($this->tipe == 1) {
                $this->validate([
                    'item_code' => 'required',
                    'item_name' => 'required',
                    'item_disc' => 'required|min:0|max:100',
                ]);
            } else if ($this->tipe == 2) {
                $this->validate([
                    'item_code' => 'required',
                    'item_name' => 'required',
                    'item_price' => 'required|min:0',
                ]);
            }

            try {


                $check = PromoItemTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->where('item_code', $this->item_code)
                    ->where('pack', 0)
                    ->where('tipe', $this->tipe)
                    ->first();

                if (!$check) {
                    PromoItemTemp::insert([
                        'id_company' => session('id_company'),
                        'tipe' => $this->tipe,
                        'pack' => 0,
                        'id_user' => session('userId'),
                        'item_code' => $this->item_code,
                        'item_barcode' => $this->item_barcode,
                        'item_name' => $this->item_name,
                        'item_price' => str_replace(',', '', $this->item_nprice),
                        'disc' => str_replace(',', '', $this->item_disc),
                        'disc_price' => str_replace(',', '', $this->item_price),
                        'qty' => $this->item_qty_check == true ? 'Y' : 'N',
                    ]);
                } else {
                    DB::table('Luv2_promo_item_temp')
                        ->where('id_company', session('id_company'))
                        ->where('tipe', $this->tipe)
                        ->where('pack', 0)
                        ->where('id_user', session('userId'))
                        ->where('item_code', $this->item_code)
                        ->update([
                            'item_price' => str_replace(',', '', $this->item_nprice),
                            'disc' => $this->tipe == 1 ? str_replace(',', '', $this->item_disc) : 0,
                            'disc_price' => $this->tipe == 1 ? 0 : str_replace(',', '', $this->item_price),
                            'qty' => $this->item_qty_check == true ? 'Y' : 'N',
                        ]);
                }
            } catch (Exception $ex) {
                $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                $this->alert('error', $message, [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $error = true;
            }
        } else if ($this->tipe == 3 || $this->tipe == 4) {
            $this->flagPack = false;
            if ($this->packSelectAll) {
                $this->flagPack = true;
            } else {
                $flag = in_array(true, $this->packCheckboxes);
                if ($flag) {
                    $this->flagPack = true;
                } else {
                    $this->flagPack = false;
                }
            }

            if ($this->flagPack) {
                $this->validate([
                    'item_code' => 'required',
                    'item_name' => 'required',
                    'item_price' => 'required|min:0',
                ]);
            }

            try {


                if ($this->flagPack) {
                    if ($this->packSelectAll) {
                        for ($i = 1; $i <= $this->qty_pack; $i++) {
                            $check = PromoItemTemp::where('id_company', session('id_company'))
                                ->where('id_user', session('userId'))
                                ->where('item_code', $this->item_code)
                                ->where('pack', $i)
                                ->where('tipe', $this->tipe)
                                ->first();

                            if (!$check) {
                                PromoItemTemp::insert([
                                    'id_company' => session('id_company'),
                                    'tipe' => $this->tipe,
                                    'pack' => $i,
                                    'id_user' => session('userId'),
                                    'item_code' => $this->item_code,
                                    'item_barcode' => $this->item_barcode,
                                    'item_name' => $this->item_name,
                                    'item_price' => str_replace(',', '', $this->item_nprice),
                                ]);
                            } else {
                                DB::table('Luv2_promo_item_temp')
                                    ->where('id_company', session('id_company'))
                                    ->where('tipe', $this->tipe)
                                    ->where('pack', $i)
                                    ->where('id_user', session('userId'))
                                    ->where('item_code', $this->item_code)
                                    ->update([
                                        'item_price' => str_replace(',', '', $this->item_nprice),
                                    ]);
                            }
                        }
                    } else {
                        $trueValues = array_filter($this->packCheckboxes, function ($value) {
                            return $value === true;
                        });

                        foreach ($trueValues as $key => $value) {
                            $check = PromoItemTemp::where('id_company', session('id_company'))
                                ->where('id_user', session('userId'))
                                ->where('item_code', $this->item_code)
                                ->where('pack', $key)
                                ->where('tipe', $this->tipe)
                                ->first();

                            if (!$check) {
                                PromoItemTemp::insert([
                                    'id_company' => session('id_company'),
                                    'tipe' => $this->tipe,
                                    'pack' => $key,
                                    'id_user' => session('userId'),
                                    'item_code' => $this->item_code,
                                    'item_barcode' => $this->item_barcode,
                                    'item_name' => $this->item_name,
                                    'item_price' => str_replace(',', '', $this->item_nprice),
                                ]);
                            } else {
                                DB::table('Luv2_promo_item_temp')
                                    ->where('id_company', session('id_company'))
                                    ->where('tipe', $this->tipe)
                                    ->where('pack', $key)
                                    ->where('id_user', session('userId'))
                                    ->where('item_code', $this->item_code)
                                    ->update([
                                        'item_price' => str_replace(',', '', $this->item_nprice),
                                    ]);
                            }
                        }
                    }
                }
            } catch (Exception $ex) {
                $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                $this->alert('error', $message, [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $error = true;
            }
        } else if ($this->tipe == 6) {
            if ($this->create_by == 1) {
                $this->validate([
                    'create_by_voucher_no' => 'required',
                    'create_by_voucher_value' => 'required|numeric|min:1',
                ]);

                try {

                    $check = PromoVoucherTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->where('voucher', $this->create_by_voucher_no)
                        ->first();

                    if (!$check) {
                        PromoVoucherTemp::insert([
                            'id_company' => session('id_company'),
                            'id_user' => session('userId'),
                            'voucher' => $this->create_by_voucher_no,
                            'value' => $this->create_by_voucher_value
                        ]);
                    } else {
                        DB::table('Luv2_promo_voucher_temp')
                            ->where('id_company', session('id_company'))
                            ->where('id_user', session('userId'))
                            ->where('voucher', $this->create_by_voucher_no)
                            ->update([
                                'value' => str_replace(',', '', $this->create_by_voucher_value),
                            ]);
                    }
                } catch (Exception $ex) {
                    $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                    $this->alert('error', $message, [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $error = true;
                }
            } else {
                $this->validate([
                    'create_by_voucher_batch' => 'required|numeric|min:1',
                    'create_by_voucher_value' => 'required|numeric|min:1',
                ]);

                try {
                    $randomData = [];


                    for ($i = 0; $i < $this->create_by_voucher_batch; $i++) {
                        $randomData[] = [
                            'id_company' => session('id_company'),
                            'id_user' => session('userId'),
                            'voucher' => $this->generateRandomAlphanumeric(),
                            'value' => $this->create_by_voucher_value,
                        ];
                    }

                    $chunks = array_chunk($randomData, 50);

                    foreach ($chunks as $chunk) {
                        PromoVoucherTemp::insert($chunk);
                    }
                } catch (Exception $ex) {
                    $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                    $this->alert('error', $message, [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $error = true;
                }
            }
        } else if ($this->tipe == 7) {
            $this->validate([
                'item_code' => 'required',
                'item_name' => 'required',
            ]);

            try {


                $check = PromoItemTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->where('item_code', $this->item_code)
                    ->where('pack', 0)
                    ->where('tipe', $this->tipe)
                    ->first();

                if (!$check) {
                    PromoItemTemp::insert([
                        'id_company' => session('id_company'),
                        'tipe' => $this->tipe,
                        'pack' => 0,
                        'id_user' => session('userId'),
                        'item_code' => $this->item_code,
                        'item_barcode' => $this->item_barcode,
                        'item_name' => $this->item_name,
                    ]);
                }
            } catch (Exception $ex) {
                $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                $this->alert('error', $message, [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $error = true;
            }
        }

        if ($error == false) {
            $this->dispatch('clearItem');
            $this->dispatch('refreshItem')->to(PromoAddTable::class);

            $this->alert('success', 'Data has been modified list', [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    #[On('clearItem')]
    public function clearItem()
    {
        $this->item_code = '';
        $this->item_barcode = '';
        $this->item_name = '';
        $this->item_nprice = 0;
        $this->item_disc = 0;
        $this->item_price = 0;
        $this->item_qty_check = false;
        $this->item_qty_qty = 0;
        $this->item_qty_disc = 0;
        $this->item_qty_price = 0;
        $this->editItem = false;

        $this->create_by_voucher_no = '';
        $this->create_by_voucher_batch = 0;
        $this->create_by_voucher_value = 0;
    }

    #[On("aaa2")]
    public function aaa2($data)
    {
        $this->item_name = $data;
        // $this->dispatch('aaa2', $data)->to(PromoEdit::class);
    }

    #[On('promoDetail')]
    public function promoDetail($itempromo)
    {
        if ($this->tipe != 6) {
            $this->item_code = $itempromo['item_code'];
            $this->item_barcode = $itempromo['item_barcode'];
            $this->item_name = $itempromo['item_name'];
            $this->item_nprice = number_format($itempromo['item_price']);
            $this->item_disc = number_format($itempromo['disc']);
            $this->item_price = number_format($itempromo['disc_price']);
            $this->item_qty_check = $itempromo['qty'] == 'Y' ? true : false;
        } else {
            $this->create_by = 1;
            $this->create_by_voucher_no = $itempromo['voucher'];
            $this->create_by_voucher_value = $itempromo['value'];
        }
        $this->editItem = true;

        $this->dispatch('aaa', $this->item_name)->to(PromoAddTable::class);
        $this->dispatch('focusNextTab');
    }

    public function create()
    {
        $error = false;

        try {

            $check = false;

            if ($this->tipe == 5) {
                $check = true;
            } else {
                $this->errorDetail = "";

                if ($this->tipe != 6) {
                    $checkExists = PromoItemTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->where('tipe', $this->tipe)
                        ->first();

                    if (!$checkExists) {
                        $this->errorDetail = "Detail promo is required";
                    }
                } else {
                    $checkExists = PromoVoucherTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->first();

                    if (!$checkExists) {
                        $this->errorDetail = "Detail voucher is required";
                    }
                }

                $check = $checkExists ? true : false;
            }

            if ($check) {
                if ($this->tipe == 3) {
                    $checkExists = DB::select("
                select count(*) as jml from (select distinct \"pack\" from \"Luv2_promo_item_temp\"
                where \"id_company\" = ? and \"id_user\" = ? and \"tipe\" = ? order by \"pack\")
                as z", [session('id_company'), session('userId'), $this->tipe]);

                    if ($checkExists[0]->jml > $this->qty_pack) {
                        $this->errorDetail = "Item detail pack is " . $checkExists[0]->jml . ", it required only " . $this->qty_pack;
                        $check = false;
                    } elseif ($checkExists[0]->jml < $this->qty_pack) {
                        $this->errorDetail = "Item detail pack is " . $checkExists[0]->jml . ", it required " . $this->qty_pack;
                        $check = false;
                    } else {
                        $check = true;
                    }
                } elseif ($this->tipe == 4) {
                    if ($this->gwp_benefit == 1) {
                        $this->errorGWPFreeItem = "";
                        $checkExists = PromoGwpItemTemp::where('id_company', session('id_company'))
                            ->where('id_user', session('userId'))
                            ->where('tipe', $this->tipe)
                            ->first();

                        $check = $checkExists ? true : false;
                    } else {
                        $check = true;
                    }

                    if ($check) {
                        $checkExists = DB::select("
                select count(*) as jml from (select distinct \"pack\" from \"Luv2_promo_item_temp\"
                where \"id_company\" = ? and \"id_user\" = ? and \"tipe\" = ? order by \"pack\")
                as z", [session('id_company'), session('userId'), $this->tipe]);

                        if ($checkExists[0]->jml > $this->qty_pack) {
                            $this->errorDetail = "Item detail pack is " . $checkExists[0]->jml . ", it required only " . $this->qty_pack;
                            $check = false;
                        } elseif ($checkExists[0]->jml < $this->qty_pack) {
                            $this->errorDetail = "Item detail pack is " . $checkExists[0]->jml . ", it required " . $this->qty_pack;
                            $check = false;
                        } else {
                            $check = true;
                        }
                    } else {
                        $this->errorGWPFreeItem = "Free item is required";
                        $check = false;
                    }
                } elseif ($this->tipe == 5) {
                    if ($this->gwp_benefit == 1) {
                        $this->errorGWPFreeItem = "";
                        $checkExists = PromoGwpItemTemp::where('id_company', session('id_company'))
                            ->where('id_user', session('userId'))
                            ->where('tipe', $this->tipe)
                            ->first();

                        $check = $checkExists ? true : false;
                    } else {
                        $check = true;
                    }

                    if (!$check) {
                        $this->errorGWPFreeItem = "Free item is required";
                    }
                } elseif ($this->tipe == 7) {
                    $this->errorBundlingQty = "";
                    $checkExists = PromoBundlingQtyTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->first();

                    $check = $checkExists ? true : false;

                    if (!$check) {
                        $this->errorBundlingQty = "Qty Bundling Disc is required";
                    }
                }
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $error = true;
        }

        if ($error == false) {
            if ($check) {
                $this->flagWhs = false;
                if ($this->whsSelectAll) {
                    $this->flagWhs = true;
                    $check = true;
                } else {
                    $trueValues = array_filter($this->whsCheckboxes, function ($value) {
                        return $value === true;
                    });

                    $i = 0;
                    foreach ($trueValues as $key) {
                        $i++;
                    }

                    if ($i > 0) {
                        $this->flagWhs = true;
                        $check = true;
                    } else {
                        $this->flagWhs = false;
                        $check = false;
                    }
                }

                if ($check) {
                    if ($this->tipe == 1 || $this->tipe == 2 || $this->tipe == 6 || $this->tipe == 7) {
                        $this->validate([
                            'name' => 'required',
                            'from_date' => 'required',
                            'to_date' => 'required',
                            'id_pricelist' => 'required',
                        ]);
                    } elseif ($this->tipe == 3) {
                        if ($this->bundling_benefit == 1) {
                            $this->validate([
                                'name' => 'required',
                                'qty_pack' => 'required|numeric|min:1',
                                'from_date' => 'required',
                                'to_date' => 'required',
                                'id_pricelist' => 'required',
                                'bundling_benefit' => 'required',
                                'bundling_benefit_disc' => 'required|numeric|min:1'
                            ]);
                        } else {
                            $this->validate([
                                'name' => 'required',
                                'qty_pack' => 'required|numeric|min:1',
                                'from_date' => 'required',
                                'to_date' => 'required',
                                'id_pricelist' => 'required',
                                'bundling_benefit' => 'required',
                                'bundling_benefit_price' => 'required|numeric|min:1'
                            ]);
                        }
                    } elseif ($this->tipe == 4) {
                        if ($this->gwp_benefit != 3) {
                            $this->validate([
                                'name' => 'required',
                                'qty_pack' => 'required|numeric|min:1',
                                'from_date' => 'required',
                                'to_date' => 'required',
                                'id_pricelist' => 'required',
                                'gwp_benefit' => 'required',
                            ]);
                        } else {
                            $this->validate([
                                'name' => 'required',
                                'qty_pack' => 'required|numeric|min:1',
                                'from_date' => 'required',
                                'to_date' => 'required',
                                'id_pricelist' => 'required',
                                'gwp_benefit' => 'required',
                                'gwp_benefit_voucher' => 'required|numeric|min:1',
                                'voucher_from_date' => 'required',
                                'voucher_to_date' => 'required',
                            ]);
                        }
                    } elseif ($this->tipe == 5) {
                        if ($this->gwp_benefit != 3) {
                            $this->validate([
                                'name' => 'required',
                                'value_pack' => 'required|numeric|min:1',
                                'from_date' => 'required',
                                'to_date' => 'required',
                                'id_pricelist' => 'required',
                                'gwp_benefit' => 'required',
                            ]);
                        } else {
                            $this->validate([
                                'name' => 'required',
                                'value_pack' => 'required|numeric|min:1',
                                'from_date' => 'required',
                                'to_date' => 'required',
                                'id_pricelist' => 'required',
                                'gwp_benefit' => 'required',
                                'gwp_benefit_voucher' => 'required|numeric|min:1',
                                'voucher_from_date' => 'required',
                                'voucher_to_date' => 'required',
                            ]);
                        }
                    }

                    try {
                        DB::beginTransaction();

                        $no = Carbon::now()->format('ymdHis');
                        $date = Carbon::now();

                        if ($this->tipe == 1 || $this->tipe == 2) {
                            DB::statement("
                    INSERT INTO \"Luv2_promo\" (\"no\",\"id_pricelist\",\"name\",\"from_date\",\"to_date\",\"id_company\",\"tipe\",\"date\",\"updated_by\") 
                    VALUES ('" . $no . "','" . $this->id_pricelist . "','" . $this->name . "','" . $this->from_date . "','" . $this->to_date . "','" . session('id_company') . "','" . $this->tipe . "','" . $date . "','" . session('userId') . "');
                    ");

                            DB::statement("
                    INSERT INTO \"Luv2_promo_item\" (\"no\",\"id_company\",\"item_code\",\"disc\",\"disc_price\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\",\"qty\") 
                    SELECT '" . $no . "',\"id_company\",\"item_code\",\"disc\",\"disc_price\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\",\"qty\"
                    FROM \"Luv2_promo_item_temp\"
                    WHERE \"id_company\"='" . session('id_company') . "'
                    AND \"tipe\"='" . $this->tipe . "'
                    AND \"id_user\"='" . session('userId') . "'
                    ");

                            DB::statement("
                    INSERT INTO \"Luv2_promo_item_qty\" (\"no\",\"id_company\",\"item_code\",\"qty\",\"disc\",\"disc_price\") 
                    SELECT '" . $no . "',\"id_company\",\"item_code\",\"qty\",\"disc\",\"disc_price\"
                    FROM \"Luv2_promo_item_qty_temp\"
                    WHERE \"id_company\"='" . session('id_company') . "'
                    AND \"tipe\"='" . $this->tipe . "'
                    AND \"id_user\"='" . session('userId') . "'
                    ");
                        } else if ($this->tipe == 3) {
                            DB::statement("
                    INSERT INTO \"Luv2_promo\" (\"no\",\"id_pricelist\",\"name\",\"from_date\",\"to_date\",\"id_company\",\"tipe\",\"date\",\"qty_pack\",\"benefit\",\"disc\",\"disc_price\",\"updated_by\") 
                    VALUES ('" . $no . "','" . $this->id_pricelist . "','" . $this->name . "','" . $this->from_date . "','" . $this->to_date . "','" . session('id_company') . "','" . $this->tipe . "','" . $date . "'," . $this->qty_pack . "," . $this->bundling_benefit . "," . $this->bundling_benefit_disc . "," . $this->bundling_benefit_price . ",'" . session('userId') . "');
                    ");

                            DB::statement("
                    INSERT INTO \"Luv2_promo_item\" (\"no\",\"id_company\",\"item_code\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\") 
                    SELECT '" . $no . "',\"id_company\",\"item_code\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\"
                    FROM \"Luv2_promo_item_temp\"
                    WHERE \"id_company\"='" . session('id_company') . "'
                    AND \"tipe\"='" . $this->tipe . "'
                    AND \"id_user\"='" . session('userId') . "'
                    ");
                        } else if ($this->tipe == 4) {
                            if ($this->gwp_benefit != 3) {
                                DB::statement("
                        INSERT INTO \"Luv2_promo\" (\"no\",\"id_pricelist\",\"name\",\"from_date\",\"to_date\",\"id_company\",\"tipe\",\"date\",\"qty_pack\",\"benefit\",\"updated_by\") 
                        VALUES ('" . $no . "','" . $this->id_pricelist . "','" . $this->name . "','" . $this->from_date . "','" . $this->to_date . "','" . session('id_company') . "','" . $this->tipe . "','" . $date . "'," . $this->qty_pack . "," . $this->gwp_benefit . ",'" . session('userId') . "');
                        ");
                            } else {
                                DB::statement("
                        INSERT INTO \"Luv2_promo\" (\"no\",\"id_pricelist\",\"name\",\"from_date\",\"to_date\",\"id_company\",\"tipe\",\"date\",\"qty_pack\",\"benefit\",\"voucher\",\"voucher_from_date\",\"voucher_to_date\",\"updated_by\") 
                        VALUES ('" . $no . "','" . $this->id_pricelist . "','" . $this->name . "','" . $this->from_date . "','" . $this->to_date . "','" . session('id_company') . "','" . $this->tipe . "','" . $date . "'," . $this->qty_pack . "," . $this->gwp_benefit . "," . $this->gwp_benefit_voucher . ",'" . $this->voucher_from_date . "','" . $this->voucher_to_date . "','" . session('userId') . "');
                        ");
                            }

                            DB::statement("
                    INSERT INTO \"Luv2_promo_item\" (\"no\",\"id_company\",\"item_code\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\") 
                    SELECT '" . $no . "',\"id_company\",\"item_code\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\"
                    FROM \"Luv2_promo_item_temp\"
                    WHERE \"id_company\"='" . session('id_company') . "'
                    AND \"tipe\"='" . $this->tipe . "'
                    AND \"id_user\"='" . session('userId') . "'
                    ");
                        } else if ($this->tipe == 5) {
                            if ($this->gwp_benefit != 3) {
                                DB::statement("
                        INSERT INTO \"Luv2_promo\" (\"no\",\"id_pricelist\",\"name\",\"from_date\",\"to_date\",\"id_company\",\"tipe\",\"date\",\"value_pack\",\"benefit\",\"updated_by\") 
                        VALUES ('" . $no . "','" . $this->id_pricelist . "','" . $this->name . "','" . $this->from_date . "','" . $this->to_date . "','" . session('id_company') . "','" . $this->tipe . "','" . $date . "'," . $this->value_pack . "," . $this->gwp_benefit . ",'" . session('userId') . "');
                        ");
                            } else {
                                DB::statement("
                        INSERT INTO \"Luv2_promo\" (\"no\",\"id_pricelist\",\"name\",\"from_date\",\"to_date\",\"id_company\",\"tipe\",\"date\",\"value_pack\",\"benefit\",\"voucher\",\"voucher_from_date\",\"voucher_to_date\",\"updated_by\") 
                        VALUES ('" . $no . "','" . $this->id_pricelist . "','" . $this->name . "','" . $this->from_date . "','" . $this->to_date . "','" . session('id_company') . "','" . $this->tipe . "','" . $date . "'," . $this->value_pack . "," . $this->gwp_benefit . "," . $this->gwp_benefit_voucher . ",'" . $this->voucher_from_date . "','" . $this->voucher_to_date . "','" . session('userId') . "');
                        ");
                            }
                        } else if ($this->tipe == 6) {
                            DB::statement("
                    INSERT INTO \"Luv2_promo\" (\"no\",\"id_pricelist\",\"name\",\"from_date\",\"to_date\",\"id_company\",\"tipe\",\"date\",\"updated_by\") 
                    VALUES ('" . $no . "','" . $this->id_pricelist . "','" . $this->name . "','" . $this->from_date . "','" . $this->to_date . "','" . session('id_company') . "','" . $this->tipe . "','" . $date . "','" . session('userId') . "');
                    ");

                            DB::statement("
                    INSERT INTO \"Luv2_promo_voucher\" (\"no\",\"id_company\",\"voucher\",\"value\") 
                    SELECT '" . $no . "',\"id_company\",\"voucher\",\"value\"
                    FROM \"Luv2_promo_voucher_temp\"
                    WHERE \"id_company\"='" . session('id_company') . "'
                    AND \"id_user\"='" . session('userId') . "'
                    ");
                        } else if ($this->tipe == 7) {
                            DB::statement("
                    INSERT INTO \"Luv2_promo\" (\"no\",\"id_pricelist\",\"name\",\"from_date\",\"to_date\",\"id_company\",\"tipe\",\"date\",\"updated_by\") 
                    VALUES ('" . $no . "','" . $this->id_pricelist . "','" . $this->name . "','" . $this->from_date . "','" . $this->to_date . "','" . session('id_company') . "','" . $this->tipe . "','" . $date . "','" . session('userId') . "');
                    ");

                            DB::statement("
                    INSERT INTO \"Luv2_promo_item\" (\"no\",\"id_company\",\"item_code\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\",\"qty\") 
                    SELECT '" . $no . "',\"id_company\",\"item_code\",\"pack\",\"item_barcode\",\"item_name\",\"item_price\",\"qty\"
                    FROM \"Luv2_promo_item_temp\"
                    WHERE \"id_company\"='" . session('id_company') . "'
                    AND \"tipe\"='" . $this->tipe . "'
                    AND \"id_user\"='" . session('userId') . "'
                    ");

                            DB::statement("
                    INSERT INTO \"Luv2_promo_bundling_qty\" (\"no\",\"id_company\",\"qty\",\"disc\",\"disc_price\") 
                    SELECT '" . $no . "',\"id_company\",\"qty\",\"disc\",\"disc_price\"
                    FROM \"Luv2_promo_bundling_qty_temp\"
                    WHERE \"id_company\"='" . session('id_company') . "'
                    AND \"id_user\"='" . session('userId') . "'
                    ");
                        }

                        if ($this->tipe == 4 || $this->tipe == 5) {
                            if ($this->gwp_benefit == 1) {
                                DB::statement("
                        INSERT INTO \"Luv2_promo_item_gwp\" (\"no\",\"id_company\",\"item_code\",\"item_barcode\",\"item_name\",\"tipe\",\"disc\",\"disc_price\") 
                        SELECT '" . $no . "',\"id_company\",\"item_code\",\"item_barcode\",\"item_name\",\"tipe\",\"disc\",\"disc_price\"
                        FROM \"Luv2_promo_item_gwp_temp\"
                        WHERE \"id_company\"='" . session('id_company') . "'
                        AND \"tipe\"='" . $this->tipe . "'
                        AND \"id_user\"='" . session('userId') . "'
                        ");
                            }
                        }

                        if ($this->tipe != 5) {
                            if ($this->tipe != 6) {
                                DB::statement("
                        DELETE FROM \"Luv2_promo_item_temp\"
                        WHERE \"id_company\"='" . session('id_company') . "'
                        AND \"tipe\"='" . $this->tipe . "'
                        AND \"id_user\"='" . session('userId') . "'
                        ");

                                if ($this->tipe == 1 || $this->tipe == 2) {
                                    DB::statement("
                            DELETE FROM \"Luv2_promo_item_qty_temp\"
                            WHERE \"id_company\"='" . session('id_company') . "'
                            AND \"tipe\"='" . $this->tipe . "'
                            AND \"id_user\"='" . session('userId') . "'
                            ");
                                } elseif ($this->tipe == 4 && $this->gwp_benefit == 1) {
                                    DB::statement("
                            DELETE FROM \"Luv2_promo_item_gwp_temp\"
                            WHERE \"id_company\"='" . session('id_company') . "'
                            AND \"tipe\"='" . $this->tipe . "'
                            AND \"id_user\"='" . session('userId') . "'
                            ");
                                } else if ($this->tipe == 7) {
                                    DB::statement("
                            DELETE FROM \"Luv2_promo_bundling_qty_temp\"
                            WHERE \"id_company\"='" . session('id_company') . "'
                            AND \"id_user\"='" . session('userId') . "'
                            ");
                                }
                            } else {
                                DB::statement("
                        DELETE FROM \"Luv2_promo_voucher_temp\"
                        WHERE \"id_company\"='" . session('id_company') . "'
                        AND \"id_user\"='" . session('userId') . "'
                        ");
                            }
                        }

                        if ($this->whsSelectAll) {
                            $whsList = null;
                            if ($this->id_pricelist == 0) {
                                $whsList = Warehouse::where('id_company', session('id_company'))->where('active', 'Y')->orderBy('code', 'asc')->get();
                            } elseif ($this->id_pricelist > 0) {
                                $whsList = Warehouse::where('id_company', session('id_company'))->where('active', 'Y')->where('id_pricelist', $this->id_pricelist)->orderBy('code', 'asc')->get();
                            }

                            foreach ($whsList as $wh) {
                                DB::statement("
                        INSERT INTO \"Luv2_promo_whs\" (\"no\",\"id_company\",\"whs_code\")
                        VALUES ('" . $no . "','" . session('id_company') . "','" . $wh->code . "');
                        ");
                            }
                        } else {
                            $trueValues = array_filter($this->whsCheckboxes, function ($value) {
                                return $value === true;
                            });

                            foreach ($trueValues as $key => $value) {
                                DB::statement("
                        INSERT INTO \"Luv2_promo_whs\" (\"no\",\"id_company\",\"whs_code\")
                        VALUES ('" . $no . "','" . session('id_company') . "','" . $key . "');
                        ");
                            }
                        }

                        if ($this->add == false) {
                            DB::statement("
                    UPDATE \"Luv2_promo\" set \"deleted\"='Y' where \"no\"='" . $this->no . "';
                    ");
                        }

                        DB::commit();

                        $this->alert('success', 'Promo has been ' . (session()->has('noPromo') ? 'updated' : 'added'), [
                            'position' => 'top-end',
                            'timer' => 2500,
                            'toast' => true,
                            'timerProgressBar' => true,
                        ]);

                        $this->dispatch('home');
                    } catch (Exception $ex) {
                        DB::rollback();
                        $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                        $this->alert('error', $message, [
                            'position' => 'top-end',
                            'timer' => 3000,
                            'toast' => true,
                            'timerProgressBar' => true,
                        ]);
                    }
                }
            }
        }
    }

    public function addGwp()
    {
        $this->validate([
            'gwp_item_code' => 'required',
            'gwp_item_name' => 'required',
        ]);

        try {

            $url = session('url');

            $response = Http::post($url . '/api/search', [
                "Select" => "\"ItemCode\",\"CodeBars\",\"ItemName\"",
                "From" => "OITM",
                "Where" => "\"ItemCode\"='" . $this->gwp_item_code . "' or \"CodeBars\"='" . $this->gwp_item_barcode . "' limit 1;",
            ]);

            if ($response->successful()) {
                $jsonData = $response->json();

                if ($jsonData[0]['ItemCode'] != '') {

                    $check = PromoGwpItemTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->where('item_code', $jsonData[0]['ItemCode'])
                        ->first();

                    if (!$check) {
                        PromoGwpItemTemp::insert([
                            'id_company' => session('id_company'),
                            'id_user' => session('userId'),
                            'item_code' => $jsonData[0]['ItemCode'],
                            'item_barcode' => $jsonData[0]['CodeBars'],
                            'item_name' => $jsonData[0]['ItemName'],
                            'tipe' => $this->tipe,
                            'disc' => $this->gwp_disc_by == 1 ? $this->gwp_item_disc : 0,
                            'disc_price' => $this->gwp_disc_by == 1 ? 0 : $this->gwp_item_price,
                        ]);
                    }

                    $this->dispatch('refreshItem')->to(PromoGwpItem::class);
                    $this->gwp_item_code = '';
                    $this->gwp_item_barcode = '';
                    $this->gwp_item_name = '';
                    $this->gwp_item_disc = 0;
                    $this->gwp_item_price = 0;
                } else {
                    $this->alert('error', 'Item not found', [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            } else {
                $this->alert('error', 'Not Connect to SAP Server', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    #[On('focusNextTab')]
    public function focusNextTab()
    {
        if ($this->tipe == 1) {
            $this->dispatch('focusNextTabDisc');
        } elseif ($this->tipe == 1) {
            $this->dispatch('focusNextTabPrice');
        } elseif ($this->tipe == 6) {
            $this->dispatch('focusNextTabVoucher');
        }
    }

    #[On('detail')]
    public function detail()
    {
        $error = false;
        $check = false;

        if ($this->tipe == 1 || $this->tipe == 2) {
            $this->validate([
                'name' => 'required',
                'from_date' => 'required',
                'to_date' => 'required',
                'id_pricelist' => 'required',
            ]);

            $check = true;
        } else if ($this->tipe == 3) {
            if ($this->bundling_benefit == 1) {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'bundling_benefit' => 'required',
                    'bundling_benefit_disc' => 'required|numeric|min:1'
                ]);
            } else {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'bundling_benefit' => 'required',
                    'bundling_benefit_price' => 'required|numeric|min:1'
                ]);
            }

            $check = true;
        } else if ($this->tipe == 4) {
            if ($this->gwp_benefit == 1) {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                ]);

                $this->errorGWPFreeItem = "";

                try {

                    $checkExists = PromoGwpItemTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->where('tipe', $this->tipe)
                        ->first();

                    $check = $checkExists ? true : false;

                    if ($check == false) {
                        $this->errorGWPFreeItem = "Free item is required";
                    }
                } catch (Exception $ex) {
                    $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                    $this->alert('error', $message, [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $error = true;
                }
            } elseif ($this->gwp_benefit == 3) {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                    'gwp_benefit_voucher' => 'required|numeric|min:1'
                ]);

                $check = true;
            } else {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                ]);

                $check = true;
            }
        } else if ($this->tipe == 5) {
            if ($this->gwp_benefit == 1) {
                $this->validate([
                    'name' => 'required',
                    'value_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                ]);

                $this->errorGWPFreeItem = "";

                try {

                    $checkExists = PromoGwpItemTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->where('tipe', $this->tipe)
                        ->first();

                    $check = $checkExists ? true : false;

                    if ($check == false) {
                        $this->errorGWPFreeItem = "Free item is required";
                    }
                } catch (Exception $ex) {
                    $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                    $this->alert('error', $message, [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $error = true;
                }
            } elseif ($this->gwp_benefit == 3) {
                $this->validate([
                    'name' => 'required',
                    'value_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                    'gwp_benefit_voucher' => 'required|numeric|min:1'
                ]);

                $check = true;
            } else {
                $this->validate([
                    'name' => 'required',
                    'value_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                ]);

                $check = true;
            }
        } else if ($this->tipe == 6) {
            $this->validate([
                'name' => 'required',
                'from_date' => 'required',
                'to_date' => 'required',
                'id_pricelist' => 'required',
            ]);

            $check = true;
        } else if ($this->tipe == 7) {
            $this->validate([
                'name' => 'required',
                'from_date' => 'required',
                'to_date' => 'required',
                'id_pricelist' => 'required',
            ]);

            $this->errorBundlingQty = "";

            try {

                $checkExists = PromoBundlingQtyTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->first();

                $check = $checkExists ? true : false;

                if ($check == false) {
                    $this->errorBundlingQty = "Qty pack discount is required";
                }
            } catch (Exception $ex) {
                $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                $this->alert('error', $message, [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $error = true;
            }
        }

        if ($error == false) {
            if ($check) {
                $this->flagWhs = false;
                if ($this->whsSelectAll) {
                    $this->flagWhs = true;
                    $check = true;
                } else {
                    $trueValues = array_filter($this->whsCheckboxes, function ($value) {
                        return $value === true;
                    });

                    $i = 0;
                    foreach ($trueValues as $key) {
                        $i++;
                    }

                    if ($i > 0) {
                        $this->flagWhs = true;
                        $check = true;
                    } else {
                        $this->flagWhs = false;
                        $check = false;
                    }
                }

                if ($check) {
                    if ($this->tipe != 5 && $this->tipe != 6) {
                        if ($this->flagImport == false) {
                            PromoItemTemp::where('id_company', session('id_company'))
                                ->where('id_user', session('userId'))
                                ->where('tipe', $this->tipe)
                                ->delete();

                            if ($this->tipe == 1 || $this->tipe == 2) {
                                PromoItemQtyTemp::where('id_company', session('id_company'))
                                    ->where('id_user', session('userId'))
                                    ->where('tipe', $this->tipe)
                                    ->delete();
                            }
                        }
                    }

                    $this->dispatch('changeFlagDetail');
                }
            }
        }
    }

    #[On('changeFlagDetail')]
    public function changeFlagDetail()
    {
        $this->flag = true;
        $this->flagImport = false;

        if ($this->tipe == 3 || $this->tipe == 4) {
            $this->dispatch('packSetup');
        }
    }

    public function detailImport()
    {
        $error = false;
        $check = false;

        if ($this->tipe == 1 || $this->tipe == 2) {
            $this->validate([
                'name' => 'required',
                'from_date' => 'required',
                'to_date' => 'required',
                'id_pricelist' => 'required',
            ]);

            $check = true;
        } else if ($this->tipe == 3) {
            if ($this->bundling_benefit == 1) {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'bundling_benefit' => 'required',
                    'bundling_benefit_disc' => 'required|numeric|min:1'
                ]);
            } else {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'bundling_benefit' => 'required',
                    'bundling_benefit_price' => 'required|numeric|min:1'
                ]);
            }

            $check = true;
        } else if ($this->tipe == 4) {
            if ($this->gwp_benefit == 1) {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                ]);

                $this->errorGWPFreeItem = "";

                try {

                    $checkExists = PromoGwpItemTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->where('tipe', $this->tipe)
                        ->first();

                    $check = $checkExists ? true : false;

                    if ($check == false) {
                        $this->errorGWPFreeItem = "Free item is required";
                    }
                } catch (Exception $ex) {
                    $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                    $this->alert('error', $message, [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $error = true;
                }
            } elseif ($this->gwp_benefit == 3) {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                    'gwp_benefit_voucher' => 'required|numeric|min:1'
                ]);

                $check = true;
            } else {
                $this->validate([
                    'name' => 'required',
                    'qty_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                ]);

                $check = true;
            }
        } else if ($this->tipe == 5) {
            if ($this->gwp_benefit == 1) {
                $this->validate([
                    'name' => 'required',
                    'value_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                ]);

                $this->errorGWPFreeItem = "";

                try {

                    $checkExists = PromoGwpItemTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->where('tipe', $this->tipe)
                        ->first();

                    $check = $checkExists ? true : false;

                    if ($check == false) {
                        $this->errorGWPFreeItem = "Free item is required";
                    }
                } catch (Exception $ex) {
                    $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                    $this->alert('error', $message, [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $error = true;
                }
            } elseif ($this->gwp_benefit == 3) {
                $this->validate([
                    'name' => 'required',
                    'value_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                    'gwp_benefit_voucher' => 'required|numeric|min:1'
                ]);

                $check = true;
            } else {
                $this->validate([
                    'name' => 'required',
                    'value_pack' => 'required|numeric|min:1',
                    'from_date' => 'required',
                    'to_date' => 'required',
                    'id_pricelist' => 'required',
                    'gwp_benefit' => 'required',
                ]);

                $check = true;
            }
        } else if ($this->tipe == 6) {

            $this->validate([
                'name' => 'required',
                'from_date' => 'required',
                'to_date' => 'required',
                'id_pricelist' => 'required',
            ]);

            $check = true;
        } else if ($this->tipe == 7) {
            $this->validate([
                'name' => 'required',
                'from_date' => 'required',
                'to_date' => 'required',
                'id_pricelist' => 'required',
            ]);

            $this->errorBundlingQty = "";

            try {

                $checkExists = PromoBundlingQtyTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->first();

                $check = $checkExists ? true : false;

                if ($check == false) {
                    $this->errorBundlingQty = "Qty pack discount is required";
                }
            } catch (Exception $ex) {
                $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
                $this->alert('error', $message, [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $error = true;
            }
        }

        if ($error == false) {
            if ($check) {
                $this->flagWhs = false;
                if ($this->whsSelectAll) {
                    $this->flagWhs = true;
                    $check = true;
                } else {
                    $trueValues = array_filter($this->whsCheckboxes, function ($value) {
                        return $value === true;
                    });

                    $i = 0;
                    foreach ($trueValues as $key) {
                        $i++;
                    }

                    if ($i > 0) {
                        $this->flagWhs = true;
                        $check = true;
                    } else {
                        $this->flagWhs = false;
                        $check = false;
                    }
                }

                if ($check) {
                    $this->flag = false;
                    $this->flagImport = true;
                }
            }
        }
    }

    #[On('importFlagTrue')]
    public function importFlagTrue()
    {
        $data = $this->validate([
            'file' => 'required',
        ]);

        if ($data) {
            $this->import = true;
            $this->dispatch('importPromo');
        }
    }

    #[On('importFlagFalse')]
    public function importFlagFalse()
    {
        $this->import = false;
    }

    #[On('importPromoDone')]
    public function importPromoDone()
    {
        $this->dispatch('detail');
        $this->dispatch('refreshItem')->to(PromoAddTable::class);
    }

    #[On('importPromo')]
    public function importPromo()
    {
        try {
            if ($this->tipe != 6) {
                PromoItemTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->where('tipe', $this->tipe)
                    ->delete();

                if ($this->tipe == 1 || $this->tipe == 2) {
                    PromoItemQtyTemp::where('id_company', session('id_company'))
                        ->where('id_user', session('userId'))
                        ->where('tipe', $this->tipe)
                        ->delete();
                }

                $file = fopen($this->file->getRealPath(), 'r');
                $skipFirstRow = true;

                $chunkSize = 100;
                $chunks = [];

                while (($data = fgetcsv($file)) !== false) {
                    if ($skipFirstRow) {
                        $skipFirstRow = false;
                        continue;
                    }

                    $chunks[] = [
                        'id_company' => session('id_company'),
                        'item_code' => $data[0],
                        'item_barcode' => $data[1],
                        'item_name' => $data[2],
                        'item_price' => $data[3],
                        'disc' => $this->tipe == 1 ? $data[4] : 0,
                        'disc_price' => $this->tipe == 2 ? $data[4] : 0,
                        'pack' => $this->tipe == 1 || $this->tipe == 2 || $this->tipe == 5 || $this->tipe == 7 ? 0 : $data[4],
                        'tipe' => $this->tipe,
                        'id_user' => Auth::user()->id
                    ];

                    if (count($chunks) == $chunkSize) {
                        PromoItemTemp::insert($chunks);
                        $chunks = [];
                    }
                }

                if (!empty($chunks)) {
                    PromoItemTemp::insert($chunks);
                }

                fclose($file);


                if ($this->tipe == 1 || $this->tipe == 2) {
                    if ($this->fileQty !== null) {
                        $fileQty = fopen($this->fileQty->getRealPath(), 'r');
                        $skipFirstRow = true;

                        $chunkSize = 100;
                        $chunks = [];

                        while (($data = fgetcsv($fileQty)) !== false) {
                            if ($skipFirstRow) {
                                $skipFirstRow = false;
                                continue;
                            }

                            $chunks[] = [
                                'id_company' => session('id_company'),
                                'item_code' => $data[0],
                                'qty' => $data[4],
                                'disc' => $this->tipe == 1 ? $data[5] : 0,
                                'disc_price' => $this->tipe == 1 ? 0 : $data[5],
                                'tipe' => $this->tipe,
                                'id_user' => Auth::user()->id
                            ];

                            if (count($chunks) == $chunkSize) {
                                PromoItemQtyTemp::insert($chunks);
                                $chunks = [];
                            }
                        }

                        if (!empty($chunks)) {
                            PromoItemQtyTemp::insert($chunks);
                        }

                        fclose($fileQty);
                    }
                }

                if ($this->tipe == 1 || $this->tipe == 2) {
                    DB::statement("
                UPDATE \"Luv2_promo_item_temp\" a
                SET \"qty\" = 'Y'
                FROM \"Luv2_promo_item_qty_temp\" b
                WHERE a.\"id_company\" = b.\"id_company\" AND a.\"id_company\"='" . session('id_company') . "'
                AND a.\"id_user\" = b.\"id_user\" AND a.\"id_user\"='" . session('userId') . "'
                AND a.\"id_user\" = b.\"id_user\" AND a.\"id_user\"='" . session('userId') . "'
                AND a.\"tipe\" = b.\"tipe\" AND a.\"tipe\"='" . $this->tipe . "'
                AND a.\"pack\"=0 AND a.\"qty\" = 'N';
                ");
                }
            } else {
                PromoVoucherTemp::where('id_company', session('id_company'))
                    ->where('id_user', session('userId'))
                    ->delete();

                $file = fopen($this->file->getRealPath(), 'r');
                $skipFirstRow = true;

                $chunkSize = 100;
                $chunks = [];

                while (($data = fgetcsv($file)) !== false) {
                    if ($skipFirstRow) {
                        $skipFirstRow = false;
                        continue;
                    }

                    $chunks[] = [
                        'id_company' => session('id_company'),
                        'voucher' => $data[0],
                        'value' => $data[1],
                        'id_user' => Auth::user()->id
                    ];

                    if (count($chunks) == $chunkSize) {
                        PromoVoucherTemp::insert($chunks);
                        $chunks = [];
                    }
                }

                if (!empty($chunks)) {
                    PromoVoucherTemp::insert($chunks);
                }

                fclose($file);
            }

            $this->dispatch('importFlagFalse');
            $this->dispatch('importPromoDone');

            $this->alert('success', 'Data has been imported to list', [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } catch (Exception $ex) {
            $this->dispatch('importFlagFalse');
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function updatePackCheckboxes($i)
    {
        $this->packCheckboxes[$i] = !$this->checkboxes[$i];
    }

    public function updateWhsCheckboxes($i)
    {
        $this->whsCheckboxes[$i] = !$this->checkboxes[$i];
    }

    private function generateRandomAlphanumeric()
    {
        return Str::random(13);
    }

    #[On('home')]
    public function home()
    {
        sleep(2.5);
        return $this->redirect('/promo');
    }
}
