<?php

namespace App\Livewire\Promo;

use App\Models\PromoItemTemp;
use App\Models\PromoVoucherTemp;
use Exception;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class PromoAddTable extends Component
{
    use LivewireAlert;

    public $tipe;
    public $items = [];

    public function mount($tipe)
    {
        try {
            $this->tipe = $tipe;
            if ($this->tipe == 1 || $this->tipe == 2 || $this->tipe == 7) {
                $this->items = DB::table('Luv2_promo_item_temp')
                    ->where('company_code', session('company_code'))
                    ->where('id_user', session('userId'))
                    ->where('tipe', $this->tipe)
                    ->orderBy('item_code')
                    ->get();
            } else if ($this->tipe == 3 || $this->tipe == 4) {
                $this->items = DB::table('Luv2_promo_item_temp')
                    ->where('company_code', session('company_code'))
                    ->where('id_user', session('userId'))
                    ->where('tipe', $this->tipe)
                    ->orderBy('pack')
                    ->orderBy('item_code')
                    ->get();
            } else if ($this->tipe == 6) {
                $this->items = DB::table('Luv2_promo_voucher_temp')
                    ->where('company_code', session('company_code'))
                    ->where('id_user', session('userId'))
                    ->orderBy('value')
                    ->orderBy('voucher')
                    ->get();
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }

    public function render()
    {
        return view('livewire.promo.promo-add-table');
    }

    #[On('editItem')]
    public function editItem($editItemCode)
    {
        try {
            if ($this->tipe != 6) {
                $itempromo = PromoItemTemp::where('company_code', session('company_code'))
                    ->where('id_user', session('userId'))
                    ->where('tipe', $this->tipe)
                    ->where('item_code', $editItemCode)
                    ->first();

                $this->dispatch('promoDetail', $itempromo)->to(PromoAdd::class);
            } else {
                $itempromo = PromoVoucherTemp::where('company_code', session('company_code'))
                    ->where('id_user', session('userId'))
                    ->where('voucher', $editItemCode)
                    ->first();

                $this->dispatch('promoDetail', $itempromo)->to(PromoAdd::class);
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->dispatch("refresh")->to(PromoAdd::class);
    }

    public function delete(string $item_code, string $pack)
    {
        try {
            DB::statement("
            DELETE FROM \"Luv2_promo_item_temp\"
            WHERE \"company_code\"='" . session('company_code') . "'
            AND \"id_user\"='" . session('userId') . "'
            AND \"tipe\"='" . $this->tipe . "'
            AND \"item_code\"='" . $item_code . "'
            AND \"pack\"='" . $pack . "';
            ");

            if ($this->tipe == 1 || $this->tipe == 2) {
                DB::statement("
            DELETE FROM \"Luv2_promo_item_qty_temp\"
            WHERE \"company_code\"='" . session('company_code') . "'
            AND \"id_user\"='" . session('userId') . "'
            AND \"item_code\"='" . $item_code . "';
            ");
            }

            $this->dispatch('refreshItem');

            $this->alert('success', 'Data has been deleted from list', [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->dispatch("refresh")->to(PromoAdd::class);
    }

    public function deleteVoucher(string $voucher)
    {
        try {
            DB::statement("
            DELETE FROM \"Luv2_promo_voucher_temp\"
            WHERE \"company_code\"='" . session('company_code') . "'
            AND \"id_user\"='" . session('userId') . "'
            AND \"voucher\"='" . $voucher . "';
            ");

            $this->dispatch('refreshItem');

            $this->alert('success', 'Data has been deleted from list', [
                'position' => 'top-end',
                'timer' => 2500,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->dispatch("refresh")->to(PromoAdd::class);
    }

    #[On('refreshItem')]
    public function refreshItem()
    {
        $this->dispatch('refresh');
        $this->dispatch('refreshData');
    }

    #[On('refreshData')]
    public function refreshData()
    {
        try {
            if ($this->tipe == 1 || $this->tipe == 2 || $this->tipe == 7) {
                $this->items = DB::table('Luv2_promo_item_temp')
                    ->where('company_code', session('company_code'))
                    ->where('id_user', session('userId'))
                    ->where('tipe', $this->tipe)
                    ->orderBy('item_code')
                    ->get();
            } else if ($this->tipe == 3 || $this->tipe == 4) {
                $this->items = DB::table('Luv2_promo_item_temp')
                    ->where('company_code', session('company_code'))
                    ->where('id_user', session('userId'))
                    ->where('tipe', $this->tipe)
                    ->orderBy('pack')
                    ->orderBy('item_code')
                    ->get();
            } else if ($this->tipe == 6) {
                $this->items = DB::table('Luv2_promo_voucher_temp')
                    ->where('company_code', session('company_code'))
                    ->where('id_user', session('userId'))
                    ->orderBy('value')
                    ->orderBy('voucher')
                    ->get();
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->dispatch("refresh")->to(PromoAdd::class);
    }
}
