<?php

namespace App\Livewire\Promo;

use Exception;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class PromoAddItem extends Component
{
    use LivewireAlert;

    public $tipe = 0;
    public $id_pricelist = 1;
    public $search_by = 1;
    public $item_code;
    public $item_barcode;
    public $item_name;
    public $item_nprice;
    public $item_disc;
    public $item_price;
    public $item_qty_check;
    public $create_by = 1;
    public $errorDetail = '';
    public $message = '';
    public $editItem = '';
    public $flagPack = false;
    public $qtyPack = 0;
    public $search_code = false;
    public $search_barcode = false;

    public function mount($promoTipe)
    {
        $this->tipe = $promoTipe;
    }

    public function render()
    {
        return view('livewire.promo.promo-add-item');
    }

    #[On('searchFlagTrue')]
    public function searchFlagTrue()
    {
        if ($this->search_by == 1) {
            $this->search_code = true;
        } else {
            $this->search_barcode = true;
        }

        $this->dispatch('searchItem');
    }

    #[On('searchFlagFalse')]
    public function searchFlagFalse()
    {
        if ($this->search_by == 1) {
            $this->search_code = false;
        } else {
            $this->search_barcode = true;
        }
    }

    #[On('searchItem')]
    public function searchItem()
    {
        try {
            $url = session('url');

            if ($this->search_by == 1) {
                $this->validate([
                    'item_code' => 'required',
                ]);

                $this->search_code = true;

                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",ifnull((select max(\"Price\") from ITM1 where a.\"ItemCode\"=\"ItemCode\" and \"PriceList\"='" . $this->id_pricelist . "'),0) \"Price\"",
                    "From" => "OITM a",
                    "Where" => "a.\"ItemCode\"='" . $this->item_code . "' limit 1;",
                ]);
            } else if ($this->search_by == 2) {
                $this->validate([
                    'item_barcode' => 'required',
                ]);

                $this->search_barcode = true;

                $response = Http::post($url . '/api/search', [
                    "Select" => "a.\"ItemCode\",a.\"CodeBars\",a.\"ItemName\",ifnull((select max(\"Price\") from ITM1 where a.\"ItemCode\"=\"ItemCode\" and \"PriceList\"='" . $this->id_pricelist . "'),0) \"Price\"",
                    "From" => "OITM a",
                    "Where" => "a.\"CodeBars\"='" . $this->item_barcode . "' limit 1;",
                ]);
            }

            if ($response->successful()) {
                $jsonData = $response->json();
                if (!empty($jsonData)) {
                    if ($jsonData[0]['ItemCode'] != '') {
                        $this->item_code = $jsonData[0]['ItemCode'];
                        $this->item_barcode = $jsonData[0]['CodeBars'];
                        $this->item_name = $jsonData[0]['ItemName'];
                        $this->item_nprice = number_format($jsonData[0]['Price']);

                        //dd($this->item_barcode,  $this->item_name);
                        // if ($this->tipe == 1) {
                        $this->dispatch('focusNextTab');
                        // } else {
                        //     $this->dispatch('focusNextTabPrice');
                        // }
                    } else {
                        $this->alert('warning', 'Item not found on SAP', [
                            'position' => 'top-end',
                            'timer' => 3000,
                            'toast' => true,
                            'timerProgressBar' => true,
                        ]);
                    }
                } else {
                    $this->alert('warning', 'Item not found on SAP', [
                        'position' => 'top-end',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                }
            } else {
                $this->alert('error', 'Not Connect to SAP Server', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } catch (Exception $ex) {
            $message = strpos($ex->getMessage(), 'reset') !== false ? $ex->getMessage() . ", try again" : $ex->getMessage();
            $this->alert('error', $message, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }

        $this->search_code = false;
        $this->search_barcode = false;
    }
}
