<?php

namespace App\Livewire\Pos\PurchaseReturn;

use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Detail extends Component
{
    public $details;
    public $no;
    
    public function render()
    {
        return view('livewire.pos.purchase-return.detail');
    }

    public function mount($id)
    {
        $this->details = DB::table('Luv2_return_detail as pd')
        ->join('Luv2_return as p', 'pd.no', '=', 'p.no')
        ->join('Luv2_item as i', 'pd.item_code', '=', 'i.code')
        ->select(
            'i.code',
            'i.barcode',
            'i.name',
            'pd.qty as qty_detail',
            DB::raw('SUM(pd.qty) as qty')
        )
        ->where('p.no', $id)
        ->where('p.company_code', auth()->user()->company_code)
        ->groupBy(
            'i.code',
            'i.barcode',
            'i.name',
            'pd.qty'
        )
        ->get();
    

        $this->no = DB::table('Luv2_return')
            ->leftJoin('Luv2_supplier', 'Luv2_return.supp_code', '=', 'Luv2_supplier.code')
            ->leftJoin('Luv2_warehouse', 'Luv2_return.whs_code', '=', 'Luv2_warehouse.code')
            ->where('no', $id)
            ->where('Luv2_return.company_code', auth()->user()->company_code)
            ->select('Luv2_return.*', 'Luv2_supplier.*', 'Luv2_warehouse.name as whs_name')
            ->first();
    }
}
