<?php

namespace App\Livewire\Pos\PurchaseOrder;

use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Detail extends Component
{
    public $details;
    public $no;
    
    public function render()
    {
        return view('livewire.pos.purchase-order.detail');
    }

    public function mount($id)
    {
        $this->details = DB::table('Luv2_receipt_detail as pd')
        ->join('Luv2_receipt as p', 'pd.no', '=', 'p.no')
        ->join('Luv2_item as i', 'pd.item_code', '=', 'i.code')
        ->select(
            'i.code',
            'i.barcode',
            'i.name',
            'pd.qty as qty_detail',
            DB::raw('SUM(pd.qty) as qty')
        )
        ->where('p.no', $id)
        ->where('p.company_code', auth()->user()->company_code)
        ->groupBy(
            'i.code',
            'i.barcode',
            'i.name',
            'pd.qty'
        )
        ->get();
    

        $this->no = DB::table('Luv2_receipt')
        ->leftJoin('Luv2_supplier', 'Luv2_receipt.supp_code', '=', 'Luv2_supplier.code')
        ->leftJoin('Luv2_warehouse', 'Luv2_receipt.whs_code', '=', 'Luv2_warehouse.code')
        ->where('Luv2_receipt.company_code', auth()->user()->company_code) // specify table name
        ->where('Luv2_receipt.no', $id) // specify table name
        ->select('Luv2_receipt.*', 'Luv2_supplier.*', 'Luv2_warehouse.name as whs_name')
        ->first();
    
    }
}
