<?php

namespace App\Livewire\Pos\Opname;

use App\Exports\SOExport;
use App\Models\Opname;
use App\Models\OpnameDetailTemp;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;
use Livewire\Component;
use Maatwebsite\Excel\Facades\Excel;


class OpnameResult extends Component
{
    public $opnames;
    public $opnameh;
    public $date;
    public $quantities = [];
    public $selectedWarehouse = null;
    public $selectedCodeWarehouse;
    public $selectedIndexWarehouse;
    public $searchwarehouse;
    public $warehouse;
    #[Rule('required', message: 'Please fill the remarks.')]
    public $remarks = '';


    use LivewireAlert;

    public function mount()
    {

        $this->opnames = DB::table('Luv2_opname_detail_temp')
            ->where('user_code', Auth::user()->code)
            ->where('company_code', auth()->user()->company_code)
            ->orderBy('item_code')
            ->get();
        $this->opnameh = DB::table('Luv2_opname_detail_temp')->where('user_code', Auth::user()->code)->where('company_code', auth()->user()->company_code)->first();
        $this->date = Carbon::parse($this->opnameh->created_at)->format('Y-m-d');
        foreach ($this->opnames as $detail) {
            $this->quantities[] = $detail->opname;
        }

        $user = Auth::user();
        $warehouseCode = session('whscode' . auth()->user()->id); // Get the session value using the dynamic key
        $warehouse = DB::table('Luv2_warehouse')
            ->where('code', $warehouseCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();
        $this->selectedWarehouse = $warehouse;
        $this->searchwarehouse = $warehouse->name;



        $this->dispatch('refreshDatatable');
    }


    #[On('refreshJs')]
    public function refreshJs()
    {
        $this->dispatch('refreshDatatable');
    }

    public function render()
    {
        $resultwarehouse = [];
        if (strlen($this->searchwarehouse) >= 1) {
            $resultwarehouse = DB::table('Luv2_warehouse')->where('name', 'ILIKE', '%' . $this->searchwarehouse . '%')->where('company_code', auth()->user()->company_code)->limit(10)->get();
            $this->warehouse = $resultwarehouse;
        }

        return view('livewire.pos.opname.opname-result', [
            'resultwarehouse' => $resultwarehouse,
        ]);
    }

    public function export()
    {
        $opnames = DB::table('Luv2_opname_detail_temp')->where('user_code', Auth::user()->code)
            ->where('difference', '>', 0)
            ->where('company_code', auth()->user()->company_code)
            ->get();
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        $filename = "SO Report Difference - {$now}.xlsx";

        return Excel::download(new SOExport($opnames), $filename);
    }

    public function exportNoDiff()
    {
        $opnames = DB::table('Luv2_opname_detail_temp')->where('user_code', Auth::user()->code)
            ->where('difference', '=', 0)
            ->where('company_code', auth()->user()->company_code)
            ->get();
        $currentDate = Carbon::now();
        $now = $currentDate->format('d-m-Y');
        $filename = "SO Report - {$now}.xlsx";
        return Excel::download(new SOExport($opnames), $filename);
    }

    #[On('close')]
    public function close()
    {
        OpnameDetailTemp::where('user_code', Auth::user()->code)->delete();

        return $this->redirect('/opname');
    }

    public function adjustItem($key)
    {
        // dd($this->opnames[$key]);
        $dataItem = $this->opnames[$key];

        dd($dataItem);
    }


    #[On('updateQuantity')]
    public function updateQuantity($index, $code, $value)
    {
        // Retrieve the detail from the database
        $detail = DB::table('Luv2_opname_detail_temp')
            ->where('item_code', $code)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($detail) {
            // Update qty_receive in the retrieved detail
            // Update the database record
            DB::table('Luv2_opname_detail_temp')
                ->where('item_code', $code)
                ->where('company_code', auth()->user()->company_code)
                ->update([
                    'opname' => $value,
                    'difference' => $value - $detail->qty,
                ]);
        }

        $this->opnames = DB::table('Luv2_opname_detail_temp')
            ->where('user_code', Auth::user()->code)
            ->where('company_code', auth()->user()->company_code)
            ->orderBy('item_code')
            ->get();
        foreach ($this->opnames as $detail) {
            $this->quantities[] = $detail->opname;
        }
        // You can now perform any other operations needed, like saving to the database, etc.
    }

    public function selectWarehouse($index)
    {
        $this->selectedIndexWarehouse = $index;
        $this->selectedCodeWarehouse = $this->warehouse[$index]->code;

        $warehouse = DB::table('Luv2_warehouse')->where('code', $this->selectedCodeWarehouse)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->selectedCodeWarehouse = null;
            $this->selectedIndexWarehouse = null;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }
    }

    public function selectWarehouseByClick($warehouseCode)
    {

        $warehouse = DB::table('Luv2_warehouse')->where('code', $warehouseCode)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($warehouse) {

            $this->searchwarehouse = $warehouse->name;
            $this->selectedWarehouse = $warehouse;

            $this->alert('info', 'Warehouse: ' . $warehouse->name, [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshDatatable');
        }
    }

    public function updatedSearchwarehouse()
    {
        $this->selectedWarehouse = null;
    }

    public function save()
    {
        $user = Auth::user();

        $this->validate();
        if ($this->selectedWarehouse) {
            DB::beginTransaction();

            try {
                foreach ($this->opnames as $opname) {
                    DB::table('Luv2_opname_detail')->insert([
                        'company_code' => $opname->company_code,
                        'no' => $opname->no,
                        'item_code' => $opname->item_code,
                        'price' => $opname->price,
                        'qty' => $opname->qty,
                        'opname' => $opname->opname,
                        'difference' => $opname->difference,
                        'created_at' => now(),
                        'updated_at' => now(),
                        'item_barcode' => $opname->item_barcode,
                        'item_name' => $opname->item_name,
                        'type' => $opname->type,
                    ]);
                }

                $sumQty = collect($this->opnames)->sum('qty');
                $sumOpname = collect($this->opnames)->sum('opname');
                $sumDifference = collect($this->opnames)->sum('difference');

                DB::table('Luv2_opname')->insert([
                    'company_code' => $this->opnameh->company_code,
                    'no' => $this->opnameh->no,
                    'date' => $this->date,
                    'whs_code' => $this->selectedWarehouse->code,
                    'remark' => $this->remarks,
                    'qty' => $sumQty,
                    'opname' => $sumOpname,
                    'difference' => $sumDifference,
                    'created_at' => now(),
                    'updated_at' => now(),
                    'deleted' => 'N',
                    'user_code' => $user->code,
                    'adjust' => 'N',
                ]);

                DB::commit();

                $this->alert('success', 'Opnames saved successfully!', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);

                $this->dispatch('close');
            } catch (\Exception $e) {
                DB::rollBack();
                Log::debug($e);
                $this->alert('error', 'Failed to save opnames. Please try again.', [
                    'position' => 'top-end',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        } else {
            $this->alert('warning', 'Please select warehouse ! ', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }
}
