<?php

namespace App\Livewire\Pos\Opname;

use App\Models\Opname;
use App\Models\OpnameDetailChunk;
use App\Models\OpnameDetailTemp;
use App\Models\OpnameTemp;
use App\Models\Settings;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithFileUploads;
use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\IOFactory;

class OpnameInput extends Component
{
    use WithFileUploads;

    public $type;
    public $period;
    public $file;
    public $isloading = false;
    public $noopname;
    public $cancreateSo = true;
    public $whs_code;

    use LivewireAlert;

    protected $rules = [
        'file' => 'required|mimes:csv,xlsx',
        'whs_code' => 'required',
    ];

    protected $messages = [
        'file.mimes' => 'The file must be a CSV or Excel file',
    ];

    public function mount()
    {
        $user = Auth::user();

        $this->type = "Global";
        $this->period = Carbon::now()->format('Y-m-d');
        if ($user->whs_code == '-') {
            $this->cancreateSo = true;
            // $this->whs_code = '';
        } else {
            // Perform the database query to check for matching records
            $matchingRecords = DB::table('Luv2_opname')
                ->leftJoin('Luv2_warehouse', 'Luv2_opname.whs_code', '=', 'Luv2_warehouse.code')
                ->where('Luv2_opname.user_code', $user->code)
                ->where('Luv2_opname.adjust', 'N')
                ->where('Luv2_opname.whs_code', $user->whs_code)
                ->where('Luv2_opname.company_code', $user->company_code)
                ->select('Luv2_opname.*', 'Luv2_warehouse.name as whs_name')
                ->get();

            if ($matchingRecords->isNotEmpty()) {
                $this->cancreateSo = false;
            } else {
                $this->cancreateSo = true;
            }
            $this->whs_code = $user->whs_code;
        }

        $userId = auth()->user()->id;
        session(["whscode{$userId}" => $this->whs_code]);
    }

    public function updatedWhsCode()
    {
        $userId = auth()->user()->id;
        session(["whscode{$userId}" => $this->whs_code]);
    }
    public function render()
    {
        Opname::where('user_code', Auth::user()->code)->delete();
        $warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();
        return view('livewire.pos.opname.opname-input', compact('warehouse'));
    }

    public function firstClick()
    {
        $this->isloading = true;
        $this->dispatch('import');
    }

    private function insertChunks($chunks)
    {
        foreach ($chunks as $chunk) {
            OpnameDetailChunk::updateOrInsert(
                [
                    'company_code' => $chunk['company_code'],
                    'whs_code' => $chunk['whs_code'],
                    'code' => $chunk['code'],
                    'user_code' => $chunk['user_code'],
                    'type' => $chunk['type']
                ],
                $chunk
            );
        }
    }

    #[On('import')]
    public function import()
    {
        if ($this->cancreateSo) {
            $user = Auth::user();
            $huruf = 'OP';
            $tanggal = Carbon::now()->isoFormat('YYMMDDHHmm');

            $countop = DB::table('Luv2_opname')
                ->where('company_code', $user->company_code)
                ->count();
            $countop += 1;

            $countop = min($countop, 999);
            $countop = str_pad($countop, 3, '0', STR_PAD_LEFT);
            $no = $huruf . $tanggal . $countop;

            $this->noopname = $no;

            $this->validate();

            OpnameDetailChunk::where('user_code', Auth::user()->code)->where('company_code', $user->company_code)->where('whs_code', $this->whs_code)->delete();

            $extension = $this->file->getClientOriginalExtension();
            $chunks = [];
            $lineNum = 1;

            if ($extension === 'csv') {
                $file = fopen($this->file->getRealPath(), 'r');
                $skipFirstRow = true;

                while (($data = fgetcsv($file)) !== false) {
                    if ($skipFirstRow) {
                        $skipFirstRow = false;
                        continue;
                    }

                    $chunks[] = $this->prepareChunkData($data, $lineNum);
                    $lineNum++;

                    if (count($chunks) == 100) {
                        $this->insertChunks($chunks);
                        $chunks = [];
                    }
                }
                fclose($file);
            } else {
                $spreadsheet = IOFactory::load($this->file->getRealPath());
                $worksheet = $spreadsheet->getActiveSheet();
                $rows = $worksheet->toArray();

                // Skip header row
                array_shift($rows);

                foreach ($rows as $data) {
                    if (!empty(array_filter($data))) { // Skip empty rows
                        $chunks[] = $this->prepareChunkData($data, $lineNum);
                        $lineNum++;

                        if (count($chunks) == 100) {
                            $this->insertChunks($chunks);
                            $chunks = [];
                        }
                    }
                }
            }

            // Insert remaining chunks
            if (!empty($chunks)) {
                $this->insertChunks($chunks);
            }

            OpnameDetailTemp::where('user_code', Auth::user()->code)->delete();
            $user = Auth::user();

            if ($this->type == "Global") {
                $whs = Warehouse::where('code', $this->whs_code)->first();
                $pricelist = $whs->pricelist_code;
                #insert opname
                DB::statement("
                INSERT INTO \"Luv2_opname_detail_temp\" (\"company_code\",\"no\", \"type\", \"item_code\", \"item_barcode\", \"item_name\", \"price\", \"qty\", \"user_code\", \"created_at\") 
                SELECT DISTINCT ON (company_code, no, item_code)
                    '" . $user->company_code . "' as company_code,
                    '" . $this->noopname . "' as no, 
                    '" . $this->type . "' as type, 
                    \"code\" as item_code, 
                    \"barcode\" as item_barcode, 
                    \"name\" as item_name, 
                    COALESCE((select \"price\" from \"Luv2_item_pricelist\" where \"item_code\"=a.\"code\" and \"company_code\"=a.\"company_code\" and \"pricelist_code\"='" . $pricelist . "'),0) as price, 
                    COALESCE((select sum(\"qty\") from \"Luv2_item_trans\" where \"item_code\"=a.\"code\" and \"company_code\"=a.\"company_code\"and \"date\"<='" . $this->period . "' and \"whs_code\"='" . $this->whs_code . "' and \"company_code\"='" . $user->company_code . "'),0) as qty, 
                    '" . Auth::user()->code . "' as user_code,  
                    '" . $this->period . "' as created_at
                FROM \"Luv2_item\" a
                WHERE \"company_code\"='" . $user->company_code . "' and \"whs_code\"='" . $this->whs_code . "'
                ORDER BY company_code, no, item_code, \"code\", \"barcode\", \"name\";
                ");

                #update opname
                DB::statement("
                WITH aggregated_opname AS (
                    SELECT \"code\", SUM(\"opname\") as \"qty\"
                    FROM \"Luv2_opname_chunk\"
                    WHERE \"date\"='" . $this->period . "' and \"user_code\"='" . Auth::user()->code . "' and \"company_code\"='" . $user->company_code . "' and \"whs_code\"='" . $this->whs_code . "'
                    GROUP BY \"code\"
                )
                UPDATE \"Luv2_opname_detail_temp\"
                SET \"opname\" = \"b\".\"qty\"
                FROM aggregated_opname \"b\"
                WHERE \"Luv2_opname_detail_temp\".\"item_code\" = \"b\".\"code\"
                    AND \"Luv2_opname_detail_temp\".\"user_code\" = '" . Auth::user()->code . "'
                    AND \"Luv2_opname_detail_temp\".\"company_code\" = '" . $user->company_code . "';
                ");
            } else {
                #insert opname
                DB::statement("
                WITH aggregated_data AS (
                    SELECT 
                        '" . $user->company_code . "' as company_code,
                        '" . $this->noopname . "' as no,
                        \"type\",
                        \"code\" as item_code,
                        \"barcode\" as item_barcode,
                        \"name\" as item_name,
                        AVG(\"price\")::numeric as price,
                        SUM(\"opname\")::numeric as opname,
                        \"user_code\",
                        \"date\" as created_at,
                        MIN(\"linenum\")::integer as linenum
                    FROM \"Luv2_opname_chunk\"
                    WHERE \"user_code\"='" . Auth::user()->code . "' and \"company_code\"='" . $user->company_code . "' and \"whs_code\"='" . $this->whs_code . "'
                    GROUP BY \"company_code\", \"whs_code\", \"type\", \"code\", \"barcode\", \"name\", \"user_code\", \"date\"
                )
                INSERT INTO \"Luv2_opname_detail_temp\" (\"company_code\", \"no\", \"type\", \"item_code\", \"item_barcode\", \"item_name\", \"price\", \"opname\", \"user_code\", \"created_at\", \"linenum\")
                SELECT 
                    company_code,
                    no,
                    type,
                    item_code,
                    item_barcode,
                    item_name,
                    price,
                    opname,
                    user_code,
                    created_at,
                    linenum
                FROM aggregated_data;
                ");

                #update opname
                DB::statement("
                UPDATE \"Luv2_opname_detail_temp\"
                SET \"qty\" = \"b\".\"qty\"
                FROM (
                    SELECT \"item_code\", SUM(\"qty\") \"qty\"
                    FROM \"Luv2_item_trans\"
                    WHERE \"date\" <= '" . $this->period . "' and \"whs_code\"='" . $this->whs_code . "' and \"company_code\"='" . $user->company_code . "'
                    GROUP BY \"item_code\"
                ) AS \"b\"
                WHERE \"Luv2_opname_detail_temp\".\"item_code\" = \"b\".\"item_code\"
                    AND \"Luv2_opname_detail_temp\".\"user_code\" = '" . Auth::user()->code . "'
                    AND \"Luv2_opname_detail_temp\".\"company_code\" = '" . $user->company_code . "';
                ");
            }

            #update difference
            DB::statement("
        UPDATE \"Luv2_opname_detail_temp\" 
        SET \"difference\" = \"opname\" - \"qty\" 
        WHERE \"user_code\" = '" . Auth::user()->code . "'
        AND \"company_code\" = '" . $user->company_code . "';
    ");


            OpnameDetailChunk::where('user_code', Auth::user()->code)->where('company_code', $user->company_code)->where('whs_code', $this->whs_code)->delete();
            $this->isloading = false;
            return $this->redirect('/opname/result', navigate: true);
        } else {
            $this->alert('warning', 'Cant create SO, please Adjust latest SO!', [
                'position' => 'top-right',
                'timer' => 6000,
                'toast' => true,
                'width' => '400',
                'timerProgressBar' => true,
            ]);
        }
    }

    private function prepareChunkData($data, $lineNum)
    {
        return [
            'company_code' => Auth::user()->company_code,
            'whs_code' => $this->whs_code,
            'date' => $this->period,
            'type' => $this->type,
            'user_code' => Auth::user()->code,
            'code' => $data[0],
            'barcode' => $data[1],
            'name' => $data[2],
            'price' => $data[3],
            'opname' => $data[4],
            'linenum' => $lineNum
        ];
    }

    public function downloadTemplate()
    {
        $filePath = public_path('assets/templateso.csv');

        return Response::download($filePath);
    }
}
