<?php

namespace App\Livewire\Pos\Opname;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class IndexOpname extends Component
{
    public $stockopname = [];
    public $cancreateSo = true;

    use LivewireAlert;

    public function render()
    {

        return view('livewire.pos.opname.index-opname');
    }

    #[On('toMount')]
    public function mount()
    {
        $user = Auth::user();

        $this->stockopname = DB::table('Luv2_opname')
            ->leftJoin('Luv2_warehouse', 'Luv2_opname.whs_code', '=', 'Luv2_warehouse.code')
            ->where('Luv2_opname.deleted', 'N')
            ->where('Luv2_opname.user_code', $user->code)
            ->where('Luv2_opname.company_code', auth()->user()->company_code)
            ->select('Luv2_opname.*', 'Luv2_warehouse.name as whs_name') // Select all columns from both tables
            ->orderBy('Luv2_opname.date', 'desc')
            ->get();

        if ($user->whs_code == '-') {
            $this->cancreateSo = true;
        } else {
            // Perform the database query to check for matching records
            $matchingRecords = DB::table('Luv2_opname')
                ->leftJoin('Luv2_warehouse', 'Luv2_opname.whs_code', '=', 'Luv2_warehouse.code')
                ->where('Luv2_opname.deleted', 'N')
                ->where('Luv2_opname.company_code', auth()->user()->company_code)
                ->where('Luv2_opname.user_code', $user->code)
                ->where('Luv2_opname.adjust', 'N')
                ->where('Luv2_opname.whs_code', $user->whs_code)
                ->select('Luv2_opname.*', 'Luv2_warehouse.name as whs_name')
                ->orderBy('Luv2_opname.date', 'desc')
                ->get();

            if ($matchingRecords->isNotEmpty()) {
                $this->cancreateSo = false;
            } else {
                $this->cancreateSo = true;
            }
        }

        $this->dispatch('refreshDatatable');
    }

    #[On('goToDetail')]
    public function toDetail($no)
    {

        return redirect()->route('opnamedetail', $no);
    }

    public function toAdjust($no)
    {
        $opname = DB::table('Luv2_opname')
            ->where('no', $no)
            ->where('company_code', auth()->user()->company_code)
            ->where('deleted', 'N')
            ->where('user_code', Auth::user()->code)
            ->first();
        if ($opname) {
            DB::table('Luv2_opname')
                ->where('no', $no)
                ->where('company_code', auth()->user()->company_code)
                ->where('deleted', 'N')
                ->where('user_code', Auth::user()->code)
                ->update([
                    'adjust' => 'Y',
                    'adjust_date' => Carbon::now()
            ]);
            $this->alert('success', 'Success adjust Stock Opname', [
                'position' => 'top-right',
                'timer' => 3000,
                'toast' => true,
                'width' => '400',
                'timerProgressBar' => true,
            ]);
            $this->dispatch('closeModal', $no);
        } else {
            $this->alert('warning', 'Oops, no data available, check your database!', [
                'position' => 'top-right',
                'timer' => 3000,
                'toast' => true,
                'width' => '400',
                'timerProgressBar' => true,
            ]);
        }
        $this->dispatch('toMount');
    }


    public function toCreateSO()
    {
        if ($this->cancreateSo) {
            return redirect()->route('opnameinput');
        } else {
            $this->alert('warning', 'Cant create SO, please Adjust latest SO!', [
                'position' => 'top-right',
                'timer' => 6000,
                'toast' => true,
                'width' => '400',
                'timerProgressBar' => true,
            ]);
        }
    }


    #[On('deleteSO')]
    public function toDelete($no)
    {
        $opname = DB::table('Luv2_opname')
            ->where('no', $no)
            ->where('company_code', auth()->user()->company_code)
            ->where('deleted', 'N')
            ->where('user_code', Auth::user()->code)
            ->first();
        if ($opname) {
            DB::table('Luv2_opname')
                ->where('no', $no)
                ->where('company_code', auth()->user()->company_code)
                ->where('deleted', 'N')
                ->where('user_code', Auth::user()->code)
                ->delete();
            $this->alert('success', 'Berhasil menghapus Stock Opname', [
                'position' => 'top-right',
                'timer' => 3000,
                'toast' => true,
                'width' => '400',
                'timerProgressBar' => true,
            ]);
            $this->dispatch('toMount');
        } else {
            $this->alert('warning', 'Oops, data tidak ditemukan, periksa database anda!', [
                'position' => 'top-right',
                'timer' => 3000,
                'toast' => true,
                'width' => '400',
                'timerProgressBar' => true,
            ]);
        }
    }
}
