<?php

namespace App\Livewire\Pos\Moh;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Index extends Component
{
    public function getWarehouses()
    {
        return DB::table('Luv2_warehouse')
            ->where('company_code', Auth::user()->company_code)
            ->select('code', 'name', 'moh', 'mdq')
            ->get();
    }

    public function render()
    {
        return view('livewire.pos.moh.index', [
            'warehouses' => $this->getWarehouses()
        ]);
    }
}
