<?php

namespace App\Livewire\Pos\Moh;

use Livewire\Component;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;

class CreateMohUDF extends Component
{
    use LivewireAlert;

    public $whs_code;
    public $brand_code;
    public $category_code;
    public $size_code;
    public $moh = 0;
    public $mdq = 0;
    public $company_code;
    public $code;
    public $isEditing = false;
    public $isprocessing = false;

    public function mount($code = null)
    {
        $this->company_code = auth()->user()->company_code;

        if ($code) {
            $this->isEditing = true;
            $mohUdf = DB::table('Luv2_udf_moh')
                ->where('code', $code)
                ->where('company_code', $this->company_code)
                ->first();

            if ($mohUdf) {
                $this->code = $mohUdf->code;
                $this->whs_code = $mohUdf->whs_code;
                $this->brand_code = $mohUdf->brand_code;
                $this->category_code = $mohUdf->category_code;
                $this->size_code = $mohUdf->size_code;
                $this->moh = $mohUdf->moh;
                $this->mdq = $mohUdf->mdq;
            } else {
                return redirect()->route('index-add-moh-udf');
            }
        } else {
            $this->code = 'MOH-' . str_pad(DB::table('Luv2_udf_moh')->count() + 1, 4, '0', STR_PAD_LEFT);
        }
    }

    public function checkData()
    {
        if (!$this->whs_code && !$this->brand_code && !$this->category_code && !$this->size_code) {
            $this->alert('error', 'At least one of Warehouse, Brand, Category, or Size must be selected.');
            return;
        }

        $this->validate([
            'moh' => 'required|numeric|min:0',
            'mdq' => 'required|numeric|min:0',
        ]);

        $this->isprocessing = true;
        $this->dispatch('save');
    }

    #[On('bbb')]
    public function addModal()
    {
        $this->dispatch("addModal");
    }

    #[On('save')]
    public function save()
    {
        // Get all possible values for each field if not filled
        $warehouses = $this->whs_code ? collect([(object)['code' => $this->whs_code]]) :
            DB::table('Luv2_warehouse')->where('company_code', $this->company_code)->get();
        $brands = $this->brand_code ? collect([(object)['code' => $this->brand_code]]) :
            DB::table('Luv2_brand')->where('company_code', $this->company_code)->get();
        $categories = $this->category_code ? collect([(object)['code' => $this->category_code]]) :
            DB::table('Luv2_category')->where('company_code', $this->company_code)->get();
        $sizes = $this->size_code ? collect([(object)['code' => $this->size_code]]) :
            DB::table('Luv2_size')->where('company_code', $this->company_code)->get();

        $count = 0;
        $baseTime = time();
        $counter = 0;
        foreach ($warehouses as $warehouse) {
            foreach ($brands as $brand) {
                foreach ($categories as $category) {
                    foreach ($sizes as $size) {
                        // Generate a unique code for each combination (yyMMddHHmmss format - 12 chars)
                        $code = date('ymdHis', $baseTime + $counter);
                        $counter++;
                        // Check if already exists
                        $exists = DB::table('Luv2_udf_moh')
                            ->where('company_code', $this->company_code)
                            ->where('whs_code', $warehouse->code)
                            ->where('brand_code', $brand->code)
                            ->where('category_code', $category->code)
                            ->where('size_code', $size->code)
                            ->first();

                        if (!$exists) {
                            DB::table('Luv2_udf_moh')->insert([
                                'company_code' => $this->company_code,
                                'whs_code' => $warehouse->code,
                                'brand_code' => $brand->code,
                                'category_code' => $category->code,
                                'size_code' => $size->code,
                                'moh' => $this->moh,
                                'mdq' => $this->mdq,
                                'code' => $code,
                            ]);
                            $count++;
                        } else {
                            // Update only moh & mdq based on no and company_code
                            DB::table('Luv2_udf_moh')
                                ->where('company_code', $this->company_code)
                                ->where('code', $exists->code)
                                ->update([
                                    'moh' => $this->moh,
                                    'mdq' => $this->mdq,
                                ]);
                            $count++;
                        }
                    }
                }
            }
        }

        if ($count > 0) {
            $this->alert('success', "$count MOH UDF has been saved.");
        } else {
            $this->alert('info', 'No new MOH UDF was saved (maybe all combinations already exist).');
        }

        return redirect()->route('index-add-moh-udf');
    }

    public function render()
    {
        $warehouses = DB::table('Luv2_warehouse')
            ->where('company_code', $this->company_code)
            ->orderBy('name', 'asc')
            ->get();

        $brands = DB::table('Luv2_brand')
            ->where('company_code', $this->company_code)
            ->orderBy('name', 'asc')
            ->get();

        $categories = DB::table('Luv2_category')
            ->where('company_code', $this->company_code)
            ->orderBy('name', 'asc')
            ->get();

        $sizes = DB::table('Luv2_size')
            ->where('company_code', $this->company_code)
            ->orderBy('name', 'asc')
            ->get();

        return view('livewire.pos.moh.create-moh-u-d-f', [
            'warehouses' => $warehouses,
            'brands' => $brands,
            'categories' => $categories,
            'sizes' => $sizes,
        ]);
    }
}
