<?php

namespace App\Livewire\Pos\Member;

use App\Models\Member;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class MemberTable extends Component
{
    use LivewireAlert;
    public $members;

    #[On('refreshtable')]
    public function mount()
    {
        $this->dispatch('refreshjs');
        $members = Member::where('company_code', auth()->user()->company_code)->get();
        if ($members->isEmpty()) {
            $this->members = [];
        } else {
            $this->members = $members;
        }
    }

    public function updateStatus($code)
    {
        $currentTime = Carbon::now();
        $member = Member::where('code', $code)->where('company_code', auth()->user()->company_code)->first();

        if ($member->active === 'Y') {
            $member->update([
                'active' => 'N',
                'updated_at' => $currentTime,
            ]);
        } else {
            $member->update([
                'active' => 'Y',
                'updated_at' => $currentTime,
            ]);
        }
        $this->alert('success', 'Status changed succesfully', [
            'position' => 'top-end',
            'timer' => 5000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        $this->dispatch('refreshtable');
    }

    #[On('markAsDeleted')]
    public function deleteMember($code)
    {
        $transaksi = DB::table('Luv2_invoice')->where('member_code', $code)->where('company_code', auth()->user()->company_code)->first();
        if ($transaksi) {
            $this->alert('warning', 'Member tidak bisa dihapus karena sudah ada transaksi', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        } else {
            DB::table('Luv2_member')->where('code', $code)->where('company_code', auth()->user()->company_code)->delete();
            $this->alert('success', 'Member berhasil dihapus', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshtable');
        }
    }

    #[On('editMember')]
    public function handleEdit($data)
    {
        
        $member = Member::where('code', $data['code'])->where('company_code', auth()->user()->company_code)->first();
        if ($member) {
            $member->update([
                'name' => $data['name'],
                'phone' => $data['phone'],
                'email' => $data['email'],
                'address' => $data['address'],
                'hobby' => $data['hobby'],
            ]);
            $this->alert('success', 'Member berhasil dirubah', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->dispatch('refreshtable');
        }
    }


    public function render()
    {
        return view('livewire.pos.member.member-table');
    }
}
