<?php
namespace App\Livewire\Pos\ItemTransfer;

use App\Mail\ItRequestMail;
use App\Models\Settings;
use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class Edit extends Component
{
    use LivewireAlert;

    public $no;
    public $details;
    public $qty;
    public $quantities = [];
    public $updatedDetails = [];
    public $noit;
    public $isloading = false;


    public function mount($it)
    {
        $this->noit = $it;
        $this->details = DB::table('Luv2_transfer_detail as pd')
            ->join('Luv2_transfer as p', 'pd.no', '=', 'p.no')
            ->join('Luv2_item as i', 'pd.item_code', '=', 'i.code')
            ->select(
                'i.code',
                'i.barcode',
                'i.name',
                'pd.actualqty',
                'pd.qty_request',
                'pd.qty_open',
                DB::raw('SUM(pd.qty) as qty'),
                DB::raw('SUM(pd.qty_request) as qty_request'),
                DB::raw('SUM(pd.qty_open) as qty_open'),

            )
            ->where('p.no', $it)
            ->groupBy(
                'i.code',
                'i.barcode',
                'i.name',
                'pd.actualqty',
                'pd.qty_request',
                'pd.qty_open',
            )
            ->get();
        foreach ($this->details as $detail) {
            $this->quantities[] = $detail->actualqty;
        }
        $this->no = DB::table('Luv2_transfer')
            ->leftJoin('Luv2_warehouse as whs', 'Luv2_transfer.whs_code', '=', 'whs.code')
            ->leftJoin('Luv2_warehouse as to_whs', 'Luv2_transfer.whs_code_to', '=', 'to_whs.code')
            ->where('no', $it)
            ->select(
                'Luv2_transfer.*',
                'whs.name as whs_name',
                'to_whs.name as to_whs_name'
            ) // Select all columns from both tables and the specific columns with aliases
            ->first();
    }

    #[On('toRedirect')]
    public function close()
    {
        return redirect()->route('item-transfer.index');
    }


    public function updateQuantity($index, $code)
    {
        $it = $this->no;
        $no = $it->no;

        $detail = DB::table('Luv2_transfer_detail')
            ->where('no', $no)
            ->where('item_code', $code)
            ->first();

        if ($detail) {
            DB::table('Luv2_transfer_detail')
                ->where('no', $no)
                ->where('item_code', $code)
                ->update(['actualqty' => $this->quantities[$index]]);

            $this->updatedDetails[$index] = DB::table('Luv2_transfer_detail')
                ->where('no', $no)
                ->where('item_code', $code)
                ->first();
        }
    }


    public function save()
    {
        $it = $this->no;
        $no = $it->no;
        DB::beginTransaction();

        try {
            $transferheader = DB::table('Luv2_transfer')->where('no', $no)->first();
            $details = DB::table('Luv2_transfer_detail')
            ->where('no', $no)
            ->get();

            if ($transferheader->status == 5) {
                // Update the database with the changes stored in $updatedDetails
                foreach ($details as $index => $detail) {
                    if ($detail) {
                        DB::table('Luv2_transfer_detail')
                            ->where('no', $no)
                            ->where('item_code', $detail->item_code)
                            ->update([
                                'qty' => $detail->actualqty,
                                'actualqty' => $detail->actualqty,
                                'qty_open' => $detail->actualqty,
                            ]);
                    }
                }
            } else {
                foreach ($details as $index => $detail) {

                    if ($detail) {
                        DB::table('Luv2_transfer_detail')
                            ->where('no', $no)
                            ->where('item_code', $detail->item_code)
                            ->update([
                                'qty' => $detail->actualqty,
                                'actualqty' => $detail->actualqty,
                                'qty_close' => $detail->actualqty,
                            ]);
                    }
                }
            }

            // Check if transfer header status is 5
            if ($transferheader->status == 5) {
                $hasDifference = DB::table('Luv2_transfer_detail')
                    ->where('no', $no)
                    ->whereColumn('qty_request', '!=', 'qty_open')
                    ->exists();
            } elseif ($transferheader->status == 1) {
                $hasDifference = DB::table('Luv2_transfer_detail')
                    ->where('no', $no)
                    ->whereColumn('qty_open', '!=', 'actualqty')
                    ->exists();
            }
            if ($transferheader->status == 5) {
                $status = 1;
                $qtyOpen = DB::table('Luv2_transfer_detail')
                    ->where('no', $no)
                    ->sum('actualqty');

                DB::table('Luv2_transfer')
                    ->where('no', $no)
                    ->update([
                        'status' => $status,
                        'updated_at' => Carbon::now(),
                        'qty_open' => $qtyOpen,
                    ]);
            } else {
                $status = $hasDifference ? 3 : 2;
                $qtyClose = DB::table('Luv2_transfer_detail')
                    ->where('no', $no)
                    ->sum('actualqty');

                DB::table('Luv2_transfer')
                    ->where('no', $no)
                    ->update([
                        'status' => $status,
                        'updated_at' => Carbon::now(),
                        'qty_close' => $qtyClose,
                    ]);
            }

            // Commit the transaction
            DB::commit();

            if ($transferheader->status == 5) {
                if ($hasDifference) {
                    // Display a success message
                    $this->alert('success', 'Changes saved successfully, IT Status is Open but Theres Different Qty', [
                        'position' => 'top-right',
                        'timer' => 6000,
                        'toast' => true,
                        'width' => '400',
                        'timerProgressBar' => true,
                    ]);
                } else {
                    // Display a success message
                    $this->alert('success', 'Changes saved successfully, IT Status is Open', [
                        'position' => 'top-right',
                        'timer' => 6000,
                        'toast' => true,
                        'width' => '400',
                        'timerProgressBar' => true,
                    ]);
                }
            } else {
                if ($hasDifference) {
                    // Display a success message
                    $this->alert('success', 'Changes saved successfully, IT Status Close With Different', [
                        'position' => 'top-right',
                        'timer' => 6000,
                        'toast' => true,
                        'width' => '400',
                        'timerProgressBar' => true,
                    ]);
                } else {
                    // Display a success message
                    $this->alert('success', 'Changes saved successfully, IT Status Close', [
                        'position' => 'top-right',
                        'timer' => 6000,
                        'toast' => true,
                        'width' => '400',
                        'timerProgressBar' => true,
                    ]);
                }
            }

            $this->dispatch('locationReload');

        } catch (\Exception $e) {
            DB::rollBack();
            // dd($e);
            Log::debug($e);
            $this->alert('error', 'An error occurred. Changes could not be saved.', [
                'position' => 'top-right',
                'timer' => 6000,
                'toast' => true,
                'width' => '400',
                'timerProgressBar' => true,
            ]);
        }
    }
    public function reject()
    {
        $it = $this->no;
        $no = $it->no;
        DB::table('Luv2_transfer')
            ->where('no', $no)
            ->update([
                'status' => 4,
                'updated_at' => Carbon::now(),
            ]);

        $this->alert('success', 'IT Request Rejected succesfully, IT Status Cancel', [
            'position' => 'top-right',
            'timer' => 6000,
            'toast' => true,
            'width' => '400',
            'timerProgressBar' => true,
        ]);
        $this->dispatch('locationReload');
    }

    #[On('locationReload')]
    public function locationReload()
    {
        sleep(3);
        return redirect(route('item-transfer.index'));
    }

    #[On('clear')]
    public function afterSaveItem()
    {
        sleep(3);
        return redirect()->route('item-transfer.detail', $this->noit);
    }

    public function render()
    {
        return view('livewire.pos.item-transfer.edit');
    }

}

