<?php

namespace App\Livewire\Pos\Item;

use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Attributes\Rule;
use Livewire\Component;
use Livewire\Features\SupportFileUploads\WithFileUploads;

class ItemPricelistInsert extends Component
{

    use WithFileUploads;
    use LivewireAlert;

    #[Rule('required', message: 'Item Code field is required.')]
    #[Rule('min:3', message: 'Item Code field must be at least 3 characters.')]
    public string $item_code;

    #[Rule('required', message: 'Pricelist Code field is required.')]
    #[Rule('min:3', message: 'Pricelist Code field must be at least 3 characters.')]
    public string $pricelist_code;


    #[Rule('required', message: 'Price field is required.')]
    #[Rule('numeric', message: 'Price field must be a numeric value.')]
    public $price;

    public $file;
    public $chunks;
    public $editChunks = false;
    public $errMsg = '';
    public $isTable = true;
    public $itemPricelist;
    public $Pricelist;

    public $selectedItemCode = '';
    public $selectedItemPricelistCode = '';
    public $selectedItemPrice = '';

    // #[Rule('numeric', message: 'Price field must be a numeric value.')]
    public $pricenew;

    public $warehouses;
    #[Rule('required', message: 'Warehouse field is required.')]
    public $whs_code;

    public function render()
    {
        $this->warehouses = Warehouse::where('company_code', auth()->user()->company_code)->get();

        return view('livewire.pos.item.item-pricelist-insert');
    }

    public function importItem()
    {
        $data = $this->validate([
            'file' => 'required',
        ]);
        try {
            $file = fopen($this->file->getRealPath(), 'r');

            $skipFirstRow = true;

            $chunkSize = 100;
            $chunks = [];

            while (($data = fgetcsv($file)) !== false) {
                if ($skipFirstRow) {
                    $skipFirstRow = false;
                    continue;
                }

                $chunks[] = [
                    'company_code' => Auth::user()->company_code,
                    'item_code' => $data[0],
                    'pricelist_code' => $data[1],
                    'price' => $data[2],
                    'id_user' => Auth::user()->id,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now(),
                ];
            }
            fclose($file);
            $this->chunks = $chunks;

            $this->dispatch('refreshjs');
        } catch (\Throwable $th) {
            $this->alert('warning', 'Error, check the template!', [
                'position' => 'top-end',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }


    #[On('refreshjs')]
    public function refreshjs()
    {
        $this->dispatch('refreshDatatable');
    }

    #[On('editItemPricelist')]
    public function editPricelistItem($code, $pricelistcode)
    {
        // dd($code, $pricelistcode);
        $item = DB::table('Luv2_item_pricelist')->where('item_code', $code)->where('pricelist_code', $pricelistcode)->first();
        $this->selectedItemCode = $item->item_code;
        $this->selectedItemPricelistCode = $item->pricelist_code;
        $this->selectedItemPrice = $item->price;
        $this->whs_code = $item->whs_code;
        $this->dispatch('openModalEdit');
    }

    public function update()
    {
        DB::table('Luv2_item_pricelist')
            ->where('item_code', $this->selectedItemCode)
            ->where('pricelist_code', $this->selectedItemPricelistCode)
            ->update(['price' => $this->pricenew]);

        $this->alert('success', 'Data Item Pricelist successfully updated', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->dispatch('closeModalEdit');
        $this->dispatch('redirect');

    }

    #[On('redirect')]
    public function toRedirect()
    {
        sleep(2);
        return redirect()->route('item.input');
    }

    public function cancelImport()
    {
        $this->chunks = [];
    }

    public function saveChunks()
    {
        // dd($this->chunks);
        $userId = Auth::user()->id;
        DB::table('Luv2_item_pricelist_temp')->where('id_user', $userId)->delete();
        $chunksItem = array_chunk($this->chunks, 1000);
        foreach ($chunksItem as $chunk) {
            $insertData = [];

            foreach ($chunk as $data) {
                $insertData[] = [
                    'company_code' => Auth::user()->company_code,
                    'item_code' => $data['item_code'],
                    'pricelist_code' => $data['pricelist_code'],
                    'price' => $data['price'],
                    'id_user' => Auth::user()->id,
                    'created_at' => $data['created_at'],
                    'updated_at' => $data['updated_at'],
                ];
            }

            DB::table('Luv2_item_pricelist_temp')->insert($insertData);
        }
        $this->chunks = [];
        $this->file = '';

        DB::statement("
        INSERT INTO \"Luv2_item_pricelist\" (\"company_code\", \"item_code\", \"pricelist_code\", \"price\", \"created_at\", \"updated_at\") 
        SELECT DISTINCT \"company_code\", \"item_code\", \"pricelist_code\", \"price\",  \"created_at\", \"updated_at\"
        FROM \"Luv2_item_pricelist_temp\"
        WHERE NOT EXISTS (
            SELECT 1 FROM \"Luv2_item_pricelist\" WHERE \"Luv2_item_pricelist\".\"item_code\" = \"Luv2_item_pricelist_temp\".\"item_code\" and \"Luv2_item_pricelist\".\"company_code\"=\"Luv2_item_pricelist_temp\".\"company_code\" and \"Luv2_item_pricelist\".\"pricelist_code\"=\"Luv2_item_pricelist_temp\".\"pricelist_code\") and \"Luv2_item_pricelist_temp\".\"id_user\"='" . $userId . "' 
    ");

        #update item
        DB::statement("
        UPDATE \"Luv2_item_pricelist\"
        SET \"item_code\"=\"Luv2_item_pricelist_temp\".\"item_code\",\"pricelist_code\"=\"Luv2_item_pricelist_temp\".\"pricelist_code\",\"price\"=\"Luv2_item_pricelist_temp\".\"price\",\"updated_at\"=\"Luv2_item_pricelist_temp\".\"updated_at\"
        FROM \"Luv2_item_pricelist_temp\"
        WHERE \"Luv2_item_pricelist_temp\".\"item_code\"=\"Luv2_item_pricelist\".\"item_code\" AND\"Luv2_item_pricelist_temp\".\"pricelist_code\"=\"Luv2_item_pricelist\".\"pricelist_code\" AND \"Luv2_item_pricelist_temp\".\"company_code\"=\"Luv2_item_pricelist\".\"company_code\" AND \"Luv2_item_pricelist_temp\".\"id_user\"='" . $userId . "'
        AND (
            \"Luv2_item_pricelist_temp\".\"item_code\"<>\"Luv2_item_pricelist\".\"item_code\" OR
            \"Luv2_item_pricelist_temp\".\"pricelist_code\"<>\"Luv2_item_pricelist\".\"pricelist_code\" OR
            \"Luv2_item_pricelist_temp\".\"price\"<>\"Luv2_item_pricelist\".\"price\" OR
            \"Luv2_item_pricelist_temp\".\"updated_at\"<>\"Luv2_item_pricelist\".\"updated_at\"
        );
    ");

        $this->alert('success', 'Data Item Pricelist successfully saved', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);

        $this->dispatch('afterSave');

    }

    public function updateChunk($index, $field, $value)
    {
        $this->chunks[$index][$field] = $value;
    }

    public function modeEdit()
    {
        $this->editChunks = !$this->editChunks;

        if (!$this->editChunks) {
            $this->dispatch('refreshjs');
        }
    }

    #[On('updatedWhs')]
    public function mount()
    {
        $this->itemPricelist = DB::table('Luv2_item_pricelist')
            ->where('company_code', Auth::user()->company_code)
            ->where('whs_code', auth()->user()->whs_code)
            ->when(session('PricelistCode'), function ($query) {
                return $query->where('pricelist_code', session('PricelistCode'));
            })
            ->get();
        $this->Pricelist = DB::table('Luv2_pricelist')->where('company_code', Auth::user()->company_code)
            // ->where('whs_code', auth()->user()->whs_code)
            ->get();

        $this->whs_code = Auth::user()->whs_code;
        $this->dispatch('refreshjs');

    }

    public function save()
    {
        // $this->validate();
        // dd($this->whs_code, $this->item_code, $this->pricelist_code, $this->price);
        $checkitem = DB::table('Luv2_item_pricelist')->where('company_code', Auth::user()->company_code)->where('item_code', $this->item_code)->where('pricelist_code', $this->pricelist_code)->first();
        if ($checkitem) {
            $this->errMsg = 'Pricelist with Item Code ' . $this->item_code . ' and Pricelist Code ' . $this->pricelist_code . ' already exists !';
        } else {
            $getitem = DB::table('Luv2_item')->where('company_code', Auth::user()->company_code)
                // ->where('whs_code', auth()->user()->whs_code)
                ->where('code', $this->item_code)->first();
            if ($getitem) {
                DB::table('Luv2_item')->where('company_code', Auth::user()->company_code)
                    ->where('code', $this->item_code)
                    //    ->where('whs_code', auth()->user()->whs_code)
                    ->update([
                        'price' => $this->price,
                    ]);
            }
            DB::table('Luv2_item_pricelist')->insert([
                'company_code' => Auth::user()->company_code,
                // 'whs_code' => $this->whs_code,
                'item_code' => $this->item_code,
                'pricelist_code' => $this->pricelist_code,
                'price' => $this->price,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
            $this->dispatch('closeModal');
            $this->dispatch('afterSave');

        }
    }

    public function updated()
    {
        $this->errMsg = '';
    }

    #[On('closeModal')]
    public function closeModal()
    {
        $this->item_code = '';
        $this->pricelist_code = '';
        $this->price = '';

        $this->dispatch('closemodalCreate');
        $this->alert('success', 'Data Item Pricelist successfully saved', [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }

    public function changeTable()
    {
        $this->isTable = !$this->isTable;

        $this->chunks = [];
        $this->file = '';

        if (!$this->editChunks) {
            $this->dispatch('refreshjs');
        }
    }

    #[On('afterSave')]
    public function dataItemPricelistafterSave()
    {
        $this->itemPricelist = DB::table('Luv2_item_pricelist')->where('company_code', Auth::user()->company_code)
            ->get();
    }
}
