<?php

namespace App\Livewire\Pos\Item;

use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class IndexInsertPricelistitem extends Component
{
    public $warehouse;
    public $whs_code;
    public $param;

    public function render()
    {
        return view('livewire.pos.item.index-insert-pricelistitem');
    }

    public function mount($param)
    {
        $this->param = $param;

        if (auth()->user()->role == 'Admin') {
            $this->warehouse = Warehouse::where('company_code', auth()->user()->company_code)->get();
            $this->whs_code = Auth::user()->whs_code;
        }
    }

    public function updatedWhsCode()
    {
        $user = auth()->user();
        $user->whs_code = $this->whs_code;
        $user->save();
        $this->dispatch('updatedWhs', $this->param)->to(InsertItemPricelist::class);

    }
    
    public function changeInsert($type)
    {
        session(['insertType' => $type]);

        $this->dispatch('refreshDatatable');
    }
}
