<?php

namespace App\Livewire\Pos\Item;

use App\Models\ItemTransTemp;
use App\Models\Settings;
use App\Traits\GetItemTraits;
use Livewire\Component;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;

class GetSAPTrans extends Component
{
    use LivewireAlert;
    use GetItemTraits;


    public $startDate;
    public $endDate;
    public $isloading = false;
    public $isCheckedAll = true;
    public $isPeriod = false;
    public $countData;

    public function render()
    {
        return view('livewire.pos.item.get-s-a-p-trans');
    }

    public function mount()
    {
        $this->startDate = Carbon::now()->toDateString();
        $this->endDate = Carbon::now()->toDateString();
    }

    public function updatedIsCheckedAll($value)
    {
        if ($value) {
            $this->isPeriod = false;
        } else {
            $this->isPeriod = true;
        }
    }

    public function firstClick()
    {
        $this->isloading = true;
        $this->dispatch('getTrans');
    }

    #[On('getTrans')]
    public function sapGetTrans()
    {
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $userId = auth()->user()->id;
        $url = $setting->url;
        $whscode = $setting->wh_code;
        try {
            if ($this->isPeriod && !$this->isCheckedAll) {
                $response = Http::post($url . '/api/search', [
                    "Select" => "\"Warehouse\" as \"whs_code\",\"BASE_REF\" as \"no_trans\",\"TransType\" as \"tipe\", sum(\"InQty\"-\"OutQty\") as \"qty\",\"DocDate\" as \"date\",\"ItemCode\" as \"item_code\",min(\"DocLineNum\") as \"linenum\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OINM",
                    "Where" => "\"Warehouse\"='" . $whscode . "' and \"TransType\" not in ('13','67') and (\"Comments\" not like '" . $whscode . "/%' or \"Comments\" is NULL) and \"DocDate\" BETWEEN '" . $this->startDate . "' and '" . $this->endDate . "' group by \"Warehouse\", \"BASE_REF\", \"TransType\", \"DocDate\", \"ItemCode\";",
                ]);
            } elseif (!$this->isPeriod && $this->isCheckedAll) {
                $response = Http::post($url . '/api/search', [
                    "Select" => "\"Warehouse\" as \"whs_code\",\"BASE_REF\" as \"no_trans\",\"TransType\" as \"tipe\", sum(\"InQty\"-\"OutQty\") as \"qty\",\"DocDate\" as \"date\",\"ItemCode\" as \"item_code\",min(\"DocLineNum\") as \"linenum\",'" . $userId . "' as \"id_user\" ",
                    "From" => "OINM",
                    "Where" => "\"Warehouse\"='" . $whscode . "' and \"TransType\" not in ('13','67') and (\"Comments\" not like '" . $whscode . "/%' or \"Comments\" is NULL) group by \"Warehouse\", \"BASE_REF\", \"TransType\", \"DocDate\", \"ItemCode\";",
                ]);
            }
            $responseBody = $response->getBody()->getContents();
            $responseData = json_decode($responseBody, true);

            if ($response->successful()) {
                $jsonData = $response->json();
                if ($jsonData[0]['whs_code'] !== '') {
                    ItemTransTemp::where('id_user', $userId)->delete();
                    $chunks = array_chunk($jsonData, 1000);

                    foreach ($chunks as $chunk) {
                        $insertData = [];

                        foreach ($chunk as $item) {
                            $insertData[] = [
                                'whs_code' => $item['whs_code'],
                                'no_trans' => $item['no_trans'],
                                'tipe' => $item['tipe'],
                                'qty' => $item['qty'],
                                'date' => $item['date'],
                                'canceled' => 'N',
                                'item_code' => $item['item_code'],
                                'linenum' => $item['linenum'],
                                'id_user' => $item['id_user'],
                            ];
                        }

                        DB::table('Luv2_item_trans_temp')->insert($insertData);
                    }

                    #insert item trans
                    DB::statement("
                            INSERT INTO \"Luv2_item_trans\" (\"whs_code\", \"no_trans\", \"tipe\", \"qty\", \"date\", \"canceled\", \"item_code\", \"linenum\") 
                            SELECT \"whs_code\", \"no_trans\", \"tipe\", \"qty\", \"date\", \"canceled\", \"item_code\", \"linenum\"
                            FROM \"Luv2_item_trans_temp\"
                            WHERE NOT EXISTS (
                                SELECT 1 FROM \"Luv2_item_trans\" WHERE \"Luv2_item_trans\".\"no_trans\" = \"Luv2_item_trans_temp\".\"no_trans\" and \"Luv2_item_trans\".\"tipe\" = \"Luv2_item_trans_temp\".\"tipe\" and \"Luv2_item_trans\".\"linenum\" = \"Luv2_item_trans_temp\".\"linenum\"
                            ) and \"Luv2_item_trans_temp\".\"id_user\"='" . $userId . "' 
                        ");

                    ItemTransTemp::where('id_user', $userId)->delete();
                    $this->alert('success', 'Data SAP Trans Get succesfully', [
                        'position' => 'top-right',
                        'timer' => 3000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->dispatch('getItemAfterTrans');
                } else {
                    $this->alert('error', 'Theres no data Trans', [
                        'position' => 'top-end',
                        'timer' => 5000,
                        'toast' => true,
                        'timerProgressBar' => true,
                    ]);
                    $this->isloading = false;
                }
            }
        } catch (\Throwable $th) {
            $this->alert('error', 'No Internet Connection to Sync', [
                'position' => 'top-end',
                'timer' => 5000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->isloading = false;
        }
    }

    #[On('getItemAfterTrans')]
    public function sapGetItem()
    {
        if ($this->isPeriod && !$this->isCheckedAll) {
            $this->getItemwithUDFandFilter();
        } elseif (!$this->isPeriod && $this->isCheckedAll) {
            $this->getItemwithUDF();
        }
    }
}
