<?php

namespace App\Livewire\Pos\It;

use App\Mail\ItRequestMail;
use App\Models\Settings;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class ItreqDetail extends Component
{
    use LivewireAlert;


    public $no;
    public $details;
    public $qty;
    public $quantities = [];
    public $updatedDetails = [];
    public $noit;
    public $isloading = false;

    public function mount($it)
    {
        $this->noit = $it;
        $this->details = DB::table('Luv2_it_req_detail')
            ->Join('Luv2_it_req', 'Luv2_it_req_detail.no', '=', 'Luv2_it_req.no')
            ->Join('Luv2_item', 'Luv2_it_req_detail.item_code', '=', 'Luv2_item.code')
            ->select('Luv2_item.code', 'Luv2_item.barcode', 'Luv2_item.name', DB::raw('SUM("Luv2_it_req_detail"."qty") as "qty"'), DB::raw('SUM("Luv2_it_req_detail"."qty_receive") as "qty_receive"'))
            ->where('Luv2_it_req.no', $it)
            ->groupBy('Luv2_item.code', 'Luv2_item.barcode', 'Luv2_item.name')
            ->get();
        foreach ($this->details as $detail) {
            $this->quantities[] = $detail->qty_receive;
        }
        $this->no = DB::table('Luv2_it_req')
            ->where('no', $it)->first();
    }

    #[On('toRedirect')]
    public function close()
    {
        return redirect()->route('it.itreq');
    }

    public function updateQuantity($index, $code)
    {
        $it = $this->no;
        $no = $it->no;

        $detail = DB::table('Luv2_it_req_detail')->where('no', $no)->where('item_code', $code)->first();
        if ($detail) {
            // Update qty_receive in the local variable
            $detail->qty_receive = $this->quantities[$index];
        }

        // Store the updated detail in a temporary array
        $this->updatedDetails[$index] = $detail;

        // Display a message or perform other actions if needed
    }
    public function save()
    {
        $it = $this->no;
        $no = $it->no;
        DB::beginTransaction();

        try {
            // Update the database with the changes stored in $updatedDetails
            foreach ($this->updatedDetails as $index => $detail) {
                if ($detail) {
                    DB::table('Luv2_it_req_detail')
                        ->where('no', $no)
                        ->where('item_code', $detail->item_code)
                        ->update(['qty_receive' => $detail->qty_receive]);
                }
            }

            // Retrieve the details where qty is different from qty_receive
            $hasDifference = DB::table('Luv2_it_req_detail')
                ->where('no', $no)
                ->whereColumn('qty', '!=', 'qty_receive')
                ->exists();

            // Update the status based on whether there are differences
            $status = $hasDifference ? 'Difference' : 'Same';

            // Update the status in the Luv2_it_req table
            DB::table('Luv2_it_req')
                ->where('no', $no)
                ->update(['status' => $status,
                            'sign' => 'Y']);

            // Commit the transaction
            DB::commit();

            // Display a success message
            $this->alert('success', 'Changes saved successfully!', [
                'position' => 'top-right',
                'timer' => 6000,
                'toast' => true,
                'width' => '400',
                'timerProgressBar' => true,
            ]);
            
        } catch (\Exception $e) {
            DB::rollBack();
            // Handle the error here
            $this->alert('error', 'An error occurred. Changes could not be saved.', [
                'position' => 'top-right',
                'timer' => 6000,
                'toast' => true,
                'width' => '400',
                'timerProgressBar' => true,
            ]);
        }
    }

    #[On('clear')]
    public function updated()
    {
        $this->details = DB::table('Luv2_it_req_detail')
            ->Join('Luv2_it_req', 'Luv2_it_req_detail.no', '=', 'Luv2_it_req.no')
            ->Join('Luv2_item', 'Luv2_it_req_detail.item_code', '=', 'Luv2_item.code')
            ->select('Luv2_item.code', 'Luv2_item.barcode', 'Luv2_item.name', DB::raw('SUM("Luv2_it_req_detail"."qty") as "qty"'), DB::raw('SUM("Luv2_it_req_detail"."qty_receive") as "qty_receive"'))
            ->where('Luv2_it_req.no', $this->noit)
            ->groupBy('Luv2_item.code', 'Luv2_item.barcode', 'Luv2_item.name')
            ->get();
        foreach ($this->details as $detail) {
            $this->quantities[] = $detail->qty_receive;
        }
        $this->no = DB::table('Luv2_it_req')
            ->where('no', $this->noit)->first();
    }
    public function render()
    {
        return view('livewire.pos.it.itreq-detail');
    }

    public function signITReq()
    {
        $it = $this->no;
        $insertData[] = [
            'whs_code' => $it->whs_code,
            'whs_code_from' => $it->whs_code_from,
            'date' => $it->date,
            'comments' => $it->comments,
            'no' => $it->no,
            'canceled' => $it->canceled,
            'id_user' => auth()->user()->id,
        ];

        DB::table('Luv2_it_in')->insert($insertData);

        foreach ($this->details as $key => $item) {
            DB::table('Luv2_it_in_detail')->insert([
                'no' => $it->no,
                'item_code' => $item->code,
                'qty' => $item->qty,
                'linenum' => $key + 1,
            ]);
        }

        DB::table('Luv2_it_req')->where('no', $it->no)
            ->update(['sign' => 'Y']);

        $this->alert('success', 'It Request Sign succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'width' => '400',
            'timerProgressBar' => true,
        ]);

        $this->dispatch('sleep');
    }

    #[On('sleep')]
    public function waiting()
    {
        sleep(2);
        $this->isloading = true;

        $this->dispatch('toRedirect');
    }

    
}
