<?php

namespace App\Livewire\Pos\It;

use App\Models\ItIn;
use Livewire\Attributes\On;
use Livewire\Component;

class ItInTable extends Component
{

    public function render()
    {
        $its = ItIn::with(['whsFrom', 'details'])
        ->where('canceled', 'N')
        ->withSum('details', 'qty')
            ->orderBy('Luv2_it_in.date', 'desc')
            ->orderBy('Luv2_it_in.no', 'desc')
            ->get();

            $totalSumQty = $its->sum('details_sum_qty');

        return view('livewire.pos.it.it-in-table', compact('its', 'totalSumQty'));
    }

    public function detail($it)
    {
        return redirect()->route('it_in_detail', ['it' => $it]);
    }

    #[On('refresh')]
    public function updated()
    {
    }
}
