<?php

namespace App\Livewire\Pos\It;

use Illuminate\Support\Facades\DB;
use Livewire\Component;

class ItInDetail extends Component
{
    public $details;
    public $no;

    public function mount($it)
    {
        $this->details = DB::table('Luv2_it_in_detail')
            ->Join('Luv2_it_in', 'Luv2_it_in_detail.no', '=', 'Luv2_it_in.no')
            ->Join('Luv2_item', 'Luv2_it_in_detail.item_code', '=', 'Luv2_item.code')
            ->select('Luv2_item.code', 'Luv2_item.barcode', 'Luv2_item.name', DB::raw('SUM("Luv2_it_in_detail"."qty") as "qty"'))
            ->where('Luv2_it_in.no', $it)
            ->groupBy('Luv2_item.code')
            ->get();

        $this->no = DB::table('Luv2_it_in')
            ->where('no', $it)->first();
    }

    public function close()
    {
        return redirect()->route('it.itin');
    }
    public function render()
    {
        return view('livewire.pos.it.it-in-detail');
    }
}
