<?php

namespace App\Livewire\Pos\It;

use App\Models\Settings;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;
use Livewire\Component;

class AddItemReq extends Component
{
    use LivewireAlert;

    public $isloading = false;
    public $itemcode = '';
    public $barcode = '';
    public $itemname = '';
    public $qty = 1;
    public $errMsg = '';
    public $no;

    public function render()
    {
        return view('livewire.pos.it.add-item-req');
    }

    public function mount($no)
    {
        $this->no = $no;
    }


    public function firstClick()
    {
        $this->isloading = true;
        $this->dispatch('toGetReq');
    }

    #[On('toGetReq')]
    public function getItemReq()
    {

        $now = Carbon::now()->toDateString();
        $user = Auth::user();
        $setting = Settings::where('wh_code', $user->whs_code)->first();
        $userId = auth()->user()->id;
        $wh = Warehouse::where('code', $user->whs_code)->first();
        $url = $setting->url;
        $whscode = $setting->wh_code;
        $id_pricelist = $wh->id_pricelist;
        $member_pricelist = $setting->member;

        $response = Http::post($url . '/api/search', [
            "Select" => "a.\"ItemCode\" as \"code\",c.\"CodeBars\" as \"barcode\",c.\"ItemName\" as \"name\",c.\"ItmsGrpCod\" as \"group_code\",'" . $userId . "' as \"id_user\",'" . $id_pricelist . "' as \"idprice1\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $id_pricelist . "'),0) \"price1\",'" . $member_pricelist . "' as \"idprice2\",ifnull((select \"Price\" from ITM1 where \"ItemCode\"=a.\"ItemCode\" and \"PriceList\"='" . $member_pricelist . "'),0) \"price2\" , c.\"InvntItem\" as \"inventory\" , c.\"PrchseItem\" as \"purchase\" , c.\"SellItem\" as \"sales\", case when case when \"frozenFrom\" is null and \"frozenTo\" is null then \"frozenFor\" else case when '" . $now . "' between \"frozenFor\" and \"frozenTo\" then 'N' else 'Y' end end = 'Y' then 'N' else 'Y' end as \"active\"",
            "From" => "OINM a inner join OITM c on a.\"ItemCode\"=c.\"ItemCode\"",
            "Where" => "a.\"Warehouse\"='" . $whscode . "' and a.\"ItemCode\" = '" . $this->itemcode . "' group by a.\"ItemCode\",c.\"CodeBars\",c.\"ItemName\",c.\"ItmsGrpCod\", c.\"InvntItem\", c.\"PrchseItem\", c.\"SellItem\", c.\"frozenFor\",c.\"frozenFrom\",c.\"frozenTo\"",
        ]);
        if ($response->successful()) {
            $jsonData = $response->json();
            if ($jsonData[0]['barcode'] != '') {
                $this->errMsg = '';
                $this->barcode = $jsonData[0]['barcode'];
                $this->itemname = $jsonData[0]['name'];
            } else {
                $this->errMsg = 'Item doesnt exists on SAP';
            }
        }
        $this->isloading = false;
    }


    public function updatedItemCode()
    {
        $this->errMsg = '';
        $this->barcode = '';
        $this->itemname = '';
    }

    public function closeButton()
    {
        $this->errMsg = '';
        $this->barcode = '';
        $this->itemname = '';
        $this->itemcode = '';
    }

    public function save()
    {
        $it = $this->no;
        $no = $it->no;
        $detail = DB::table('Luv2_it_req_detail')->where('no', $no)->where('item_code', $this->itemcode)->first();
        if ($detail) {
            DB::table('Luv2_it_req_detail')
                ->where('no', $no)
                ->where('item_code', $this->itemcode)
                ->increment('qty', $this->qty);
                
        } else {
            DB::table('Luv2_it_req_detail')->insert([
                'no' => $no,
                'item_code' => $this->itemcode,
                'qty' => $this->qty,
                'created_at' => now(),
                'updated_at' => now(),
                'linenum' => 0,
                'qty_receive' => $this->qty
            ]);
        }
        $this->alert('info', 'Item Transfer Request added succesfully', [
            'position' => 'top-right',
            'timer' => 3000,
            'toast' => true,
            'width' => '400',
            'timerProgressBar' => true,
        ]);
        $this->dispatch('clear')->to(ItreqDetail::class);
        $this->dispatch('closeButton');
    }
}
