<?php

namespace App\Livewire\Modals;

use App\Livewire\Cashier\Table;
use Livewire\Component;
use App\Models\Cart;
use App\Models\ItemPrice;
use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Attributes\On;

class EditPriceModal extends Component
{
    public $selectedCart;
    public $harga;

    use LivewireAlert;

    #[On('setHarga')]
    public function setHarga($id)
    {
        $cart = Cart::where('id', $id)
            ->where('user_code', auth()->user()->code)
            ->first();
        if ($cart) {
            $this->selectedCart = $cart;
            $this->harga = $cart->nprice;
        }
    }

    public function confirmUpdatePrice($value)
    {
        if (!$this->selectedCart) return;

        if ($value === 'N') {
            $this->selectedCart->update([
                'nprice' => $this->harga,
                'price' => $this->harga,
                'total_price' => $this->harga * $this->selectedCart->qty,
            ]);
            $this->alertSuccess('Harga berhasil diperbarui.');
        } elseif ($value === 'Y') {
            $user = Auth::user();
            $whs = Warehouse::where('company_code', $user->company_code)
                ->where('code', $user->whs_code)
                ->first();
            $pricelist = DB::table('Luv2_pricelist')->where('code', $whs->pricelist_code)->first()->code;

            $this->selectedCart->update([
                'nprice' => $this->harga,
                'price' => $this->harga,
                'total_price' => $this->harga * $this->selectedCart->qty,
            ]);

            $prices = ItemPrice::where('company_code', $user->company_code)
                ->where('item_code', $this->selectedCart->code)
                ->where('pricelist_code', $pricelist)
                ->first();

            if ($prices) {
                $prices->update(['price' => $this->harga]);
            }

            $this->alertSuccess('Harga berhasil diperbarui di database.');
        }

        $this->dispatch('cart-created')->to(Table::class);
    }

    private function alertSuccess($message)
    {
        $this->alert('success', $message, [
            'position' => 'top-end',
            'timer' => 3000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
    }

    public function render()
    {
        return view('livewire.modals.edit-price-modal');
    }
}
