<?php

namespace App\Livewire\Member;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class CreateMember extends Component
{
    public $name;
    public $email;
    public $phone;
    public $address;
    public $hobby;

    use LivewireAlert;

    protected function rules()
    {
        $user = Auth::user();

        return [
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:Luv2_member,email,NULL,id,company_code,' . $user->company_code,
            'phone' => 'required|string|max:15|unique:Luv2_member,phone,NULL,id,company_code,' . $user->company_code,
            'address' => 'nullable|string|max:500',
            'hobby' => 'nullable|string|max:255',
        ];
    }


    public function createMember()
    {
        $this->validate();

        $user = Auth::user();
        $currentYear = date('y');
        $currentMonth = date('m');

        $lastMember = DB::table('Luv2_member')
            ->where('company_code', $user->company_code)
            ->orderBy('code', 'desc')
            ->first();

        $newRunningNumber = $lastMember
            ? str_pad((int) substr($lastMember->code, -4) + 1, 4, '0', STR_PAD_LEFT)
            : '0001';

        $uniqueId = 'PM' . $currentYear . $currentMonth . $newRunningNumber;

        DB::table('Luv2_member')->insert([
            'company_code' => $user->company_code,
            'code' => $uniqueId,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'address' => $this->address,
            'hobby' => $this->hobby,
            'active' => 'Y',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        $this->alert('success', 'Member berhasil dibuat', [
            'position' => 'top-end',
            'timer' => 5000,
            'toast' => true,
            'timerProgressBar' => true,
        ]);
        $this->reset(['name', 'email', 'phone', 'address', 'hobby']);
    }

    public function render()
    {
        return view('livewire.member.create-member');
    }
}
