<?php

namespace App\Livewire\Forms;

use App\Models\Cart;
use App\Models\Item;
use App\Models\ItemPriceListDiscQty;
use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Form;


class CartForm extends Form
{
    public string $itemname = '';
    public string $itemprice = '';
    public string $itemcode = '';
    public string $itemqty = '';
    public $discount = '';
    public $promo = 0;
    public $promotipe = 0;
    public $pack = 0;
    public $benefit = 'N';
    public string $nprice = '';
    public string $sales = '';

    public function store()
    {

        $qty = (int) ($this->itemqty ?: 0);
        $price = (float) ($this->itemprice ?: $this->nprice ?: 0);
        $discount = (float) ($this->discount ?: 0);
        $user = Auth::user();
        $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
        $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();
        $pricelist = $getpricelist->code;
        $memberId = session('member');
        $sessionmember = session('discountmemb');
        $now = now();
        $getiditem = Item::where('code', $this->itemcode)->where('company_code', $user->company_code)->first();
        $cartItems = Cart::where('user_code', $user->code)->orderBy('linenum')->get();
        if ($cartItems) {
            $lineNumber = 1;
            foreach ($cartItems as $item) {
                $item->linenum = $lineNumber++;
                $item->save();
            }
        }

        $cartCount = Cart::where('user_code', $user->code)->count();
        $linenum = $cartCount === 0 ? 1 : $cartCount + 1;

        $totalprice = $qty * $price;
        $nprice = (float) ($this->nprice ?: 0);
        $item = Item::where('code', $this->itemcode)->where('company_code', $user->company_code)->first();
        $isConsignment = $item->consignment === 'Y';
        if ($isConsignment) {
            $supplier = DB::table('Luv2_supplier')->where('company_code', $user->company_code)->where('code', $item->supp_code)->first();
            $sharedMargin = $supplier->shared_margin ?? 0;
            $cost = ($price * ((100 - $sharedMargin) / 100)) * $qty;
        } else {
            $sharedMargin = 0;
            $cost = $item->avgprice * $qty;
        }
        $cart = Cart::create([
            'company_code' => $user->company_code,
            'whs_code' => $whs->code,
            'code' => $this->itemcode,
            'barcode' => $getiditem->barcode,
            'name' => $this->itemname,
            'price' => $price,
            'nprice' => $nprice,
            'sandbox' => 'N',
            'linenum' => $linenum,
            'discount' => $discount,
            'sales_code' => $this->sales,
            'user_code' => $user->code,
            'member_code' => $memberId,
            'qty' => $this->itemqty ?: 1,
            'total_price' => $totalprice,
            'promo' => $this->promo,
            'promo_tipe' => $this->promotipe,
            'pack' => $this->pack,
            'benefit' => $this->benefit,
            'grouping' => $this->promo,
            'unit' => 0,
            'qty_unit' => 1,
            'cost' => $cost,
            'consignment' => $item->consignment,
            'shared_margin' => $sharedMargin,

        ]);

        return $cart;
    }

    public function updateQty()
    {
        $existingCart = Cart::where('code', $this->itemcode)
            ->where('promo', $this->promo)
            ->where('user_code', auth()->user()->code)
            ->orderBy('linenum', 'desc')
            ->first();

        if ($existingCart) {
            // Check if existing cart has promo_tipe 3, if so redirect to store
            if ($existingCart->promo_tipe == 3) {

                // Reset promo-related properties to 0
                $this->itemprice = $existingCart->nprice;
                $this->promo = 0;
                $this->promotipe = 0;
                $this->benefit = 'N';
                $this->pack = 0;
                return $this->store();
            }

            $sessionmember = session('discountmemb');
            $memberId = $existingCart->member_id;
            $user = Auth::user();
            $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
            $pricelist = $whs->pricelist_code;

            if ($existingCart->promo !== 0) {
                $itemPriceDiscounts = DB::table('Luv2_promo_item_qty')
                    ->where('company_code', $user->company_code)
                    ->where('no', $existingCart->promo)
                    ->where('item_code', $existingCart->code)
                    ->orderBy('qty', 'asc')
                    ->get();
            } else {
                if ($sessionmember == 1 && !is_null($memberId)) {
                    $itemPriceDiscounts = ItemPriceListDiscQty::where('item_code', $this->itemcode)
                        ->where('company_code', $user->company_code)
                        ->where('cardcode', $memberId)
                        ->orderBy('qty', 'asc')
                        ->get();
                } else {
                    $itemPriceDiscounts = ItemPriceListDiscQty::where('item_code', $this->itemcode)
                        ->where('company_code', $user->company_code)
                        ->where('cardcode', '*' . $pricelist)
                        ->orderBy('qty', 'asc')->get();
                }
            }
            if ($itemPriceDiscounts->isNotEmpty()) {
                $totalAddedQty = $this->itemqty;

                foreach ($itemPriceDiscounts as $itemPriceDiscount) {
                    $existingCartplus = $existingCart->qty + $totalAddedQty;
                   

                    if($existingCart->promo_tipe == 1){
                        $item = Item::where('code', $this->itemcode)->where('company_code', auth()->user()->company_code)->first();
                        $isConsignment = $item->consignment === 'Y';
                        if ($isConsignment) {
                            $supplier = DB::table('Luv2_supplier')->where('company_code', $user->company_code)->where('code', $item->supp_code)->first();
                            $sharedMargin = $supplier->shared_margin ?? 0;
                            $cost = ($existingCart->price * ((100 - $sharedMargin) / 100)) * $existingCartplus;
                        } else {
                            $sharedMargin = 0;
                            $cost = $item->avgprice * $existingCartplus;
                        }
                        $disc = $itemPriceDiscount->disc / 100;
                        $valuedisc = $existingCart->nprice * $disc;
                        $price = $existingCart->nprice - $valuedisc;
                    }else{
                        $valuedisc = $existingCart->nprice - $itemPriceDiscount->disc_price;
                        $price = $itemPriceDiscount->disc_price;
                        $cost = $price * $existingCartplus;
                    }
                    if ($existingCartplus >= $itemPriceDiscount->qty) {
                        $existingCart->update([
                            'price' => $price,
                            'qty' => $existingCartplus,
                            'total_price' => $price * $existingCartplus,
                            'cost' => $cost,
                            'consignment' => $item->consignment,
                            'shared_margin' => $sharedMargin,
                        ]);
                    } else {
                        $item = Item::where('code', $this->itemcode)->where('company_code', auth()->user()->company_code)->first();
                        $isConsignment = $item->consignment === 'Y';
                        if ($isConsignment) {
                            $supplier = DB::table('Luv2_supplier')->where('company_code', $user->company_code)->where('code', $item->supp_code)->first();
                            $sharedMargin = $supplier->shared_margin ?? 0;
                            $cost = ($existingCart->price * ((100 - $sharedMargin) / 100)) * $existingCartplus;
                        } else {
                            $sharedMargin = 0;
                            $cost = $item->avgprice * $existingCartplus;
                        }
                        $existingCart->update([
                            'total_price' => $existingCart->price * ($existingCart->qty + $this->itemqty),
                            'qty' => $existingCart->qty + $totalAddedQty,
                            'cost' => $cost,
                            'consignment' => $item->consignment,
                            'shared_margin' => $sharedMargin,
                        ]);
                    }
                    $totalAddedQty = 0;
                }
            } else {
                if ($existingCart->unit != 0) {
                    $unit = DB::table('Luv2_item_unit')->where('item_code', $existingCart->code)->where('company_code', auth()->user()->company_code)->where('whs_code', auth()->user()->whs_code)->first();
                    $item = Item::where('code', $this->itemcode)->where('company_code', auth()->user()->company_code)->first();
                    $isConsignment = $item->consignment === 'Y';
                    if ($isConsignment) {
                        $supplier = DB::table('Luv2_supplier')->where('company_code', $user->company_code)->where('code', $item->supp_code)->first();
                        $sharedMargin = $supplier->shared_margin ?? 0;
                        $cost = ($existingCart->price * ((100 - $sharedMargin) / 100)) * (($existingCart->qty_unit + $this->itemqty) * $unit->qty);
                    } else {
                        $sharedMargin = 0;
                        $cost = $item->avgprice * (($existingCart->qty_unit + $this->itemqty) * $unit->qty);
                    }
                    $existingCart->update([
                        'total_price' => $existingCart->price * ($existingCart->qty + $this->itemqty),
                        'qty' => ($existingCart->qty_unit + $this->itemqty) * $unit->qty,
                        'qty_unit' => $existingCart->qty_unit + $this->itemqty,
                        'cost' => $cost,
                        'consignment' => $item->consignment,
                        'shared_margin' => $sharedMargin,
                    ]);
                } else {
                    $item = Item::where('code', $this->itemcode)->where('company_code', auth()->user()->company_code)->first();
                    $isConsignment = $item->consignment === 'Y';
                    if ($isConsignment) {
                        $supplier = DB::table('Luv2_supplier')->where('company_code', $user->company_code)->where('code', $item->supp_code)->first();
                        $sharedMargin = $supplier->shared_margin ?? 0;
                        $cost = ($existingCart->price * ((100 - $sharedMargin) / 100)) * ($existingCart->qty + $this->itemqty);
                    } else {
                        $sharedMargin = 0;
                        $cost = $item->avgprice * ($existingCart->qty + $this->itemqty);
                    }
                    $existingCart->update([
                        'total_price' => $existingCart->price * ($existingCart->qty + $this->itemqty),
                        'qty' => $existingCart->qty + $this->itemqty,
                        'cost' => $cost,
                        'consignment' => $item->consignment,
                        'shared_margin' => $sharedMargin,
                    ]);
                }
            }
        }else{
           return $this->store();
        }

        return $existingCart;
    }

    public function sameItemBundle()
    {
        $qty = (int) ($this->itemqty ?: 0);
        $price = (float) ($this->itemprice ?: 0);
        $discount = (float) ($this->discount ?: 0);
        $user = Auth::user();
        $memberId = session('member');
        $totalprice = $qty * $price;
        $nprice = (float) ($this->nprice ?: 0);
        $item = Item::where('code', $this->itemcode)->where('company_code', auth()->user()->company_code)->first();
        $isConsignment = $item->consignment === 'Y';
        if ($isConsignment) {
            $supplier = DB::table('Luv2_supplier')->where('company_code', $user->company_code)->where('code', $item->supp_code)->first();
            $sharedMargin = $supplier->shared_margin ?? 0;
            $cost = ($price * ((100 - $sharedMargin) / 100)) * $this->itemqty;
        } else {
            $sharedMargin = 0;
            $cost = $item->avgprice * $this->itemqty;
        }
        $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
        $cartCount = Cart::where('user_code', $user->code)->count();
        $linenum = $cartCount === 0 ? 1 : $cartCount + 1;
        $cart = Cart::create([
            'company_code' => $user->company_code,
            'whs_code' => $whs->code,
            'code' => $this->itemcode,
            'barcode' => $item->barcode,
            'name' => $this->itemname,
            'price' => $price,
            'nprice' => $nprice,
            'sandbox' => 'N',
            'linenum' => $linenum,
            'discount' => $discount,
            'sales_code' => $this->sales,
            'user_code' => $user->code,
            'member_code' => $memberId,
            'qty' => $this->itemqty ?: 1,
            'total_price' => $totalprice,
            'promo' => $this->promo,
            'promo_tipe' => $this->promotipe,
            'pack' => $this->pack,
            'benefit' => $this->benefit,
            'grouping' => $this->promo,
            'unit' => 0,
            'qty_unit' => 1,
            'cost' => $cost,
            'consignment' => $item->consignment,
            'shared_margin' => $sharedMargin,
        ]);

        return $cart;
    }

    public function update()
    {
        $existingCart = Cart::where('code', $this->itemcode)
            ->where('promo', $this->promo)
            ->where('user_code', auth()->user()->code)
            ->first();

        $existingCart->update([
            'pack' => $this->pack,
        ]);
        return $existingCart;
    }
}
