<?php

namespace App\Livewire\Cashier;

use App\Livewire\Cashier\Invoice as CashierInvoice;
use App\Livewire\Forms\CartForm;
use Livewire\Attributes\On;
use App\Models\Cart;
use App\Models\Invoice;
use App\Models\ItemPrice;
use App\Models\Item;
use App\Models\Member;
use App\Models\Sales;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;
use Illuminate\Support\Str;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use App\Traits\OTPManagement;


class Transaction extends Component
{
    use LivewireAlert;
    use OTPManagement;

    public $search = "";
    public $searchmember = "";
    public $searchsales = "";
    public $selectedProduct = null;
    public $selectedMember = null;
    public $selectedSales = null;
    public $price = "";
    public $dataDisc;
    public $itemcodeprice;
    public $isDropdownVisible = false;
    public $isDropdownsalesVisible = false;
    public $isSalesModalVisible = false;
    public $isEnter = false;
    public $isSuggestion = false;
    public $suggestion = [];
    public $suggestionName;
    public $product;
    public $products = [];
    public $selectedCode;
    public $selectedIndex;
    public $selectedCodeSales;
    public $selectedIndexSales;
    public $selectedCodeMember;
    public $selectedIndexMember;
    public $modalOpen = false;
    public $openmodalDisc = false;
    public $sales = [];
    public $members = [];
    public $otp;
    public $reqOTP;
    public $errMsg;
    public $memberCode;
    public $enable = true;
    public $isEnabledMinusTransaction = false;

    public CartForm $form;

    public function save()
    {

        $user = Auth::user();
        $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
        $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();
        $pricelist = $getpricelist->code;
        $memberId = session('member');

        if ($this->selectedProduct) {
            $itemCode = $this->selectedProduct->code;
            $prices = ItemPrice::where('item_code', $itemCode)->where('pricelist_code', $pricelist)->first();


            if (!$prices) {
                // do nothing
            } else {
                $user = Auth::user();

                $itemCode = $this->selectedProduct->code;
                if (session()->has('PromoTingkat' . $user->id)) {
                    $existingCart = null;
                } else {
                    $existingCart = Cart::where('code', $itemCode)
                        ->where('lostsale', 'N')
                        ->where('user_code', $user->code)
                        ->first();
                }
                $dataDisc = $this->dataDisc;
                //jika item sudah ada di cart
                if ($existingCart) {
                    if ($existingCart->promo_tipe == 3) {

                        $checkcart = Cart::where('code', $this->form->itemcode)
                            ->where('lostsale', 'N')
                            ->where('promo', $this->form->promo)
                            ->where('promo_tipe', 3) // bundle
                            ->where('user_code', auth()->user()->code)
                            ->first();
                        $nopromo = $this->form->promo;
                        $promo_tipe = $this->form->promotipe;
                        $itemcode = $this->form->itemcode;
                        //jika dapat promonya
                        if ($checkcart) {
                            $this->form->itemprice = $checkcart->price;
                            $this->form->discount = $checkcart->discount;
                            $this->form->promo = $checkcart->promo;
                            $this->form->promotipe = $checkcart->promo_tipe;
                            // ambil pack pertama yang tersedia
                            $firstAvailablePack = $this->checkAvailablePacks($itemcode, $this->form->promo, $this->form->promotipe);
                            if ($firstAvailablePack) {

                                $this->form->pack = $firstAvailablePack;
                                $cart = $this->form->sameItemBundle();
                                $this->updatePriceBundle($nopromo);
                                $this->reset(['search', 'selectedProduct', 'price']);
                                $this->products = [];
                                $this->dispatch('suggestion', $nopromo, $promo_tipe);
                                $this->dispatch('cart-created')->to(Table::class);
                                $this->dispatch('updatePrice');
                                $this->form->reset();


                                //jika promo pack sudah terpenuhi
                            } else {
                                $sessionKey = 'PromoBundlingFulfill' . auth()->user()->id;

                                if (session()->has($sessionKey) && session($sessionKey) == $checkcart->promo) {
                                    $this->form->promo = 0;
                                    $this->form->promotipe = 0;
                                    $this->form->pack = 0;
                                    $this->form->itemprice = $this->form->nprice;
                                    $cart = $this->form->store();
                                    $this->products = [];
                                    $this->dispatch('cart-created')->to(Table::class);
                                    $this->dispatch('updatePrice');
                                    $this->form->reset();

                                    // dd('kesini pastinya');
                                } else {
                                    $cart = $this->form->updateQty();
                                    $this->reset(['search', 'selectedProduct', 'price']);
                                    $this->products = [];
                                    $this->dispatch('cart-created')->to(Table::class);
                                    $this->dispatch('updatePrice');
                                    $this->form->reset();
                                }
                            }
                            //jika tidak dapat promonya
                        } else {
                            if ($this->form->benefit == 'Free') {
                                $cart = $this->form->store();
                                $this->dispatch('clearDiscount');
                            } else {
                                $cart = $this->form->updateQty();
                            }
                            $this->reset(['search', 'selectedProduct', 'price']);
                            $this->products = [];
                            $this->dispatch('cart-created')->to(Table::class);
                            $this->dispatch('updatePrice');
                            $this->form->reset();
                        }
                    } elseif ($existingCart->promo_tipe == 4) {
                        $this->form->promo = $existingCart->promo;
                        $checkcart = Cart::where('code', $this->form->itemcode)
                            ->where('lostsale', 'N')
                            ->where('promo', $this->form->promo)
                            ->where('promo_tipe', 4) // bundle
                            ->where('user_code', auth()->user()->code)
                            ->first();
                        $nopromo = $this->form->promo;
                        $promo_tipe = $this->form->promotipe;
                        $itemcode = $this->form->itemcode;
                        //jika dapat promonya
                        if ($checkcart) {
                            $this->form->itemprice = $checkcart->price;
                            $this->form->discount = $checkcart->discount;
                            $this->form->promo = $checkcart->promo;
                            $this->form->promotipe = $checkcart->promo_tipe;
                            // ambil pack pertama yang tersedia
                            $firstAvailablePack = $this->checkAvailablePacks($itemcode, $this->form->promo, $this->form->promotipe);
                            if ($firstAvailablePack) {
                                $this->form->pack = $firstAvailablePack;
                                // dd($this->form);
                                $cart = $this->form->sameItemBundle();
                                $this->updatePriceBundle($nopromo);
                                $this->reset(['search', 'selectedProduct', 'price']);
                                $this->products = [];
                                $this->dispatch('suggestion', $nopromo, $checkcart->promo_tipe);
                                $this->dispatch('cart-created')->to(Table::class);
                                $this->dispatch('updatePrice');
                                $this->form->reset();
                                //jika promo pack sudah terpenuhi
                            } else {
                                $cart = $this->form->updateQty();
                                $this->reset(['search', 'selectedProduct', 'price']);
                                $this->dispatch('cart-created')->to(Table::class);
                                $this->dispatch('updatePrice');
                                $this->form->reset();
                            }
                            //jika tidak dapat promonya
                        } else {
                            $cart = $this->form->updateQty();
                            $this->reset(['search', 'selectedProduct', 'price']);
                            $this->products = [];
                            $this->dispatch('cart-created')->to(Table::class);
                            $this->dispatch('updatePrice');
                            $this->form->reset();
                        }
                    } elseif ($existingCart->promo_tipe == 5) {
                    } else {
                        if ($existingCart->benefit == 'Free' || $existingCart->benefit == 'Cheapest') {
                            $cart = $this->form->store();
                        } else {
                            $this->form->promo = $existingCart->promo;
                            $cart = $this->form->updateQty();
                        }
                        $this->reset(['search', 'selectedProduct', 'price']);
                        $this->products = [];
                        $this->dispatch('cart-created')->to(Table::class);
                        $this->dispatch('updatePrice');
                        $this->form->reset();
                    }

                    //jika barang belum ada pada table cart
                } else {
                    $dataDiscCollection = collect($dataDisc);
                    $countDataDisc = $dataDiscCollection->pluck('no')->unique()->count();
                    if ($countDataDisc > 1 && $this->isEnter) { //jika promo ada lebih dari satu dan melalui scan
                        $this->dispatch('selectDiscount', $dataDisc)->to(SelectDiscount::class);
                        $this->isEnter = false;
                    } else {
                        $nopromo = $this->form->promo;
                        $promo_tipe = $this->form->promotipe;
                        $itemcode = $this->form->itemcode;

                        if (session()->has('Promo-GWP-FreeItem' . auth()->user()->id) || session()->has('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id)) {
                            $promoGWPFreeItem = session('Promo-GWP-FreeItem' . auth()->user()->id) ?? session('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id);
                            $freeItems = DB::table('Luv2_promo_item_gwp')->where('no', $promoGWPFreeItem)->pluck('item_code')->toArray();
                            if (in_array($this->form->itemcode, $freeItems)) {
                                session(['StatusPromo' => 'Diskon nih']);
                                $dataDiscountGWP = DB::table('Luv2_promo_item_gwp')->where('no', $promoGWPFreeItem)->where('item_code', $this->form->itemcode)->first();
                                $item = DB::table('Luv2_item')->where('code', $this->form->itemcode)->first();
                                if ($dataDiscountGWP->disc_price == 0 && $dataDiscountGWP->disc == 0) {
                                    $this->form->itemname = $item->name . ' ( FREE ITEM )';
                                    $this->form->itemprice = 0;
                                    $this->form->discount = - ($this->form->nprice);
                                    $this->form->promo = 0;
                                    $this->form->promotipe = 0;
                                    $this->form->pack = 0;
                                    $this->form->benefit = 'Free';

                                    $this->dispatch('clearDiscount');
                                } elseif ($dataDiscountGWP->disc == 0) {
                                    $this->form->itemname = $item->name . ' ( Special Price )';
                                    $this->form->itemprice = $dataDiscountGWP->disc_price;
                                    $this->form->discount = $this->form->nprice - $dataDiscountGWP->disc_price;
                                    $this->form->promo = 0;
                                    $this->form->promotipe = 0;
                                    $this->form->pack = 0;
                                    $this->form->benefit = 'GWP Special Price';

                                    $this->dispatch('clearDiscount');
                                } else {
                                    $discountPercentage = $dataDiscountGWP->disc; // Example discount percentage
                                    $discountedPrice = $this->form->nprice * (1 - $discountPercentage / 100);
                                    $this->form->itemname = $item->name . ' ( Disc Special Price )';
                                    $this->form->itemprice = $discountedPrice;
                                    $this->form->discount = $this->form->nprice - $discountedPrice;
                                    $this->form->promo = 0;
                                    $this->form->promotipe = 0;
                                    $this->form->pack = 0;
                                    $this->form->benefit = 'GWP Special Price';

                                    $this->dispatch('clearDiscount');
                                }
                            } else {
                                session(['StatusPromo' => 'Enggak Diskon nih']);

                                // Do something if $this->form->itemcode does not exist in $freeItems
                                // For example:
                                // echo "Item code does not exist in free items array";
                            }
                        } elseif (session()->has('PromoBundlingFulfill' . auth()->user()->id)) {
                            $this->form->promo = 0;
                            $this->form->promotipe = 0;
                            $this->form->pack = 0;
                            // dd('kesini beda item dia', $this->form);
                        }

                        $cart = $this->form->store();
                        if ($cart->promo != 0) {
                            //jika pack belum terpenuhi
                            $firstAvailablePack = $this->checkAvailablePacks($itemcode, $this->form->promo, $this->form->promotipe);

                            if ($firstAvailablePack) {
                                $this->form->pack = $firstAvailablePack;
                                // dd($this->form);
                                $this->form->update();
                            }

                            $this->dispatch('suggestion', $nopromo, $promo_tipe);
                            $this->updatePriceBundle($nopromo);
                        }
                        $this->reset(['search', 'selectedProduct', 'price']);
                        $this->products = [];
                        $this->dispatch('cart-created')->to(Table::class);
                        $this->dispatch('updatePrice');
                        $this->form->reset();
                    }
                }

                $this->dataDisc = [];
                if (session()->has('Promo-GWP-ValueFreeItem' . auth()->user()->id) || session()->has('Promo-GWP-ValueCheapest' . auth()->user()->id) || session()->has('Promo-Voucher-Value' . auth()->user()->id)) {
                    $this->dispatch('checkCartValue');
                } else {
                    $this->dispatch('toActiveNcheckGWPValue'); // pindahkan
                }
                //Hilangkan ini jika ingin promo bertumpuk
                // $this->dispatch('checkPromoBertumpuk'); //perlu diperbaiki lagi
                $this->dispatch('refreshjs');
                $this->isSuggestion = false;
                // $this->dispatch('clearAfterSelectProduct');


            }
        }
    }


    #[On('toActiveNcheckGWPValue')]
    public function activencheckgwpvalue()
    {

        $currentDate = Carbon::now()->toDateString();

        $carts = Cart::where('user_code', auth()->user()->code)->get();
        $promoVoucherExists = false;

        foreach ($carts as $cartItem) {
            $promocheck = DB::table('Luv2_promo')->where('no', $cartItem->promo)->where('company_code', auth()->user()->company_code)->where('deleted', 'N')->first();
            if ($promocheck) {
                if ($promocheck->tipe == 4 && $promocheck->benefit == 3) {
                    $promoVoucherExists = true;
                    break;
                }
            } else {
                $promoVoucherExists = false;
            }
        }
        // dd($promoVoucherExists);
        if ($promoVoucherExists) {
            $promo = DB::table('Luv2_promo')
                ->whereDate('from_date', '<=', $currentDate)
                ->whereDate('to_date', '>=', $currentDate)
                ->where('deleted', 'N')
                ->where('tipe', 5)
                ->where('company_code', auth()->user()->company_code)
                ->get();
        } else {
            $promo = DB::table('Luv2_promo')
                ->where('deleted', 'N')
                ->where('company_code', auth()->user()->company_code)
                ->whereDate('from_date', '<=', $currentDate)
                ->whereDate('to_date', '>=', $currentDate)
                ->where(function ($query) {
                    $query->where('tipe', 5)
                        ->orWhere(function ($query) {
                            $query->where('tipe', 6)
                                ->where('benefit', 2);
                        });
                })
                ->get();
        }


        if (empty($promo) || $promo->isEmpty()) {
            // $promo is either null or an empty collection
            // Handle the case where $promo is empty
        } else {

            // $promo is not empty
            if ($promo->count() > 1) {
                $cart = Cart::where('user_code', auth()->user()->code)->get();
                if ($cart->count() >= 1) {
                    $this->dispatch('selectValue', $promo)->to(SelectDiscount::class);
                }
            } else {
                if ($promoVoucherExists) {
                    if ($promo[0]->tipe == 5 && $promo[0]->benefit == 1) {
                        session(['Promo-GWP-ValueFreeItem' . auth()->user()->id => $promo[0]->no]);
                    } elseif ($promo[0]->tipe == 5 && $promo[0]->benefit == 2) {
                        session(['Promo-GWP-ValueCheapest' . auth()->user()->id => $promo[0]->no]);
                    } elseif ($promo[0]->tipe == 5 && $promo[0]->benefit == 3) {
                        // no discount again
                    }
                } else {
                    if ($promo[0]->tipe == 5 && $promo[0]->benefit == 1) {
                        session(['Promo-GWP-ValueFreeItem' . auth()->user()->id => $promo[0]->no]);
                    } elseif ($promo[0]->tipe == 5 && $promo[0]->benefit == 2) {
                        session(['Promo-GWP-ValueCheapest' . auth()->user()->id => $promo[0]->no]);
                    } elseif ($promo[0]->tipe == 5 && $promo[0]->benefit == 3) {
                        session(['Promo-Voucher-Value' . auth()->user()->id => $promo[0]->no]);
                    }
                }
            }
        }
    }

    #[On('checkCartValue')]
    public function checkCartValue()
    {
        if (session()->has('Promo-GWP-ValueFreeItem' . auth()->user()->id)) {
            $session = session('Promo-GWP-ValueFreeItem' . auth()->user()->id);
        } elseif (session()->has('Promo-GWP-ValueCheapest' . auth()->user()->id)) {
            $session = session('Promo-GWP-ValueCheapest' . auth()->user()->id);
        } elseif (session()->has('Promo-Voucher-Value' . auth()->user()->id)) {
            $session = session('Promo-Voucher-Value' . auth()->user()->id);
        }

        $promo = DB::table('Luv2_promo')->where('no', $session)->where('company_code', auth()->user()->company_code)->where('deleted', 'N')->first();
        $cart = Cart::where('promo', 0)
            ->where('user_code', auth()->user()->code)
            ->get();
        $cartTotalPrice = $cart->sum('total_price');

        if ($cartTotalPrice >= $promo->value_pack) {
            if ($promo->tipe == 5 && $promo->benefit == 1) {
                session(['Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id => $session]);
            } elseif ($promo->tipe == 5 && $promo->benefit == 2) {
                if (session()->has('Promo-GWP-ValueCheapestFulfil' . auth()->user()->id)) {
                } else {
                    $this->dispatch('openModalCheapest');
                }
            } elseif ($promo->tipe == 5 && $promo->benefit == 3) {
                session(['Promo-Voucher-ValueFulfil' . auth()->user()->id => $session]);
            }
        }
    }

    #[On('checkCartValueafterDelete')]
    public function checkCartValueafterDelete()
    {
        if (session()->has('Promo-GWP-ValueFreeItem' . auth()->user()->id)) {
            $session = session('Promo-GWP-ValueFreeItem' . auth()->user()->id);
        } elseif (session()->has('Promo-GWP-ValueCheapest' . auth()->user()->id)) {
            $session = session('Promo-GWP-ValueCheapest' . auth()->user()->id);
        } elseif (session()->has('Promo-Voucher-Value' . auth()->user()->id)) {
            $session = session('Promo-Voucher-Value' . auth()->user()->id);
        }

        $promo = DB::table('Luv2_promo')->where('deleted', 'N')->where('company_code', auth()->user()->company_code)->where('no', $session)->first();
        $cart = Cart::where('promo', 0)
            ->where('user_code', auth()->user()->code)
            ->get();
        $cartTotalPrice = $cart->sum('total_price');

        if ($cartTotalPrice < $promo->value_pack) {
            if ($promo->tipe == 5 && $promo->benefit == 1) {
                $freeItems = DB::table('Luv2_promo_item_gwp')->where('company_code', auth()->user()->company_code)->where('no', $promo->no)->pluck('item_code')->toArray();
                $cartItems = Cart::whereIn('code', $freeItems)->where('benefit', 'Free')->where('user_code', auth()->user()->code)->get();
                $cartItems->each->delete();
                session()->forget('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id);
            } elseif ($promo->tipe == 5 && $promo->benefit == 2) {
                $cartItems = Cart::where('benefit', 'Cheapest')->where('user_code', auth()->user()->code)->get();
                $cartItems->each->delete();
                session()->forget('Promo-GWP-ValueCheapestFulfil' . auth()->user()->id);
            } elseif ($promo->tipe == 5 && $promo->benefit == 3) {
                session()->forget('Promo-Voucher-ValueFulfil' . auth()->user()->id);
            }
        }
        $this->dispatch('cart-created');
    }

    #[On('checkCartValueafterDeleteBundling')]
    public function checkCartValueafterDeleteBundling()
    {
        if (session()->has('PromoBundlingFulfill' . auth()->user()->id)) {
            $session = session('PromoBundlingFulfill' . auth()->user()->id);
        }
        $promo = DB::table('Luv2_promo')->where('deleted', 'N')->where('company_code', auth()->user()->company_code)->where('no', $session)->first();
        $cart = Cart::where('promo', $session)
            ->where('user_code', auth()->user()->code)
            ->get();
        $cartCount = $cart->count();

        if ($cartCount < $promo->qty_pack) {
            session()->forget('PromoBundlingFulfill' . auth()->user()->id);
            foreach ($cart as $item) {
                $product = DB::table('Luv2_item')->where('company_code', auth()->user()->company_code)->where('code', $item->code)->first();
                $item->update([
                    'name' => $product->name,
                    'price' => $item->nprice,
                    'total_price' => $item->nprice * $item->qty,
                ]);
            }
        }
        $this->dispatch('cart-created');
    }
    #[On('clearses')]
    public function clearses()
    {
        session()->forget('Promo-GWP-CheapestItemNONAKTIF' . auth()->user()->id);
        session()->forget('Promo-GWP-ValueCheapest' . auth()->user()->id);
        session()->forget('Promo-GWP-ValueFreeItem' . auth()->user()->id);
        session()->forget('Promo-GWP-ValueCheapestFulfil' . auth()->user()->id);
        session()->forget('Promo-Voucher-QTY' . auth()->user()->id);
        session()->forget('Promo-Voucher-Value' . auth()->user()->id);
        session()->forget('Promo-Voucher-ValueFulfil' . auth()->user()->id);
        session()->forget('Promo-GWP-FreeItem' . auth()->user()->id);
        session()->forget('Promo-GWP-CheapestItem' . auth()->user()->id);
        session()->forget('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id);
        session()->forget('PromoBundlingFulfill' . auth()->user()->id);
        session()->forget('PromoSudahAda' . auth()->user()->id);
        session()->forget('PromoTingkat' . auth()->user()->id);
        session()->forget('PromoExclude' . auth()->user()->id);

        session()->forget('member');
    }

    #[On('clearDiscount')]
    public function clearDiscount()
    {
        session()->forget('Promo-GWP-FreeItem' . auth()->user()->id);
        session()->forget('Promo-GWP-CheapestItem' . auth()->user()->id);
        session()->forget('StatusPromo');
    }

    #[On('suggestion')]
    public function suggestion($nopromo, $promo_tipe)
    {
        // dd($nopromo, $promo_tipe);
        $this->isSuggestion = true;
        $promo = DB::table('Luv2_promo')->where('deleted', 'N')->where('company_code', auth()->user()->company_code)->where('no', $nopromo)->get();
        if ($promo_tipe == 3) {
            if ($promo[0]->benefit == 1) {
                $this->suggestionName = 'Bundling Disc';
            } elseif ($promo[0]->benefit == 2) {
                $this->suggestionName = 'Bundling Special Price';
            } else {
                $this->suggestionName = 'Bundling';
            }
        } elseif ($promo_tipe == 4) {
            if ($promo[0]->benefit == 1) {
                $this->suggestionName = 'GWP Free Item';
            } elseif ($promo[0]->benefit == 2) {
                $this->suggestionName = 'GWP Cheapest Item';
            } else {
                $this->suggestionName = 'GWP Voucher Cashback';
            }
        } elseif ($promo_tipe == 5) {
        } elseif ($promo_tipe == 6) {
            // if ($promo[0]->benefit == 1) {
            //     $this->suggestionName = 'Voucher Cashback';
            // }
        }
        $cart = Cart::where('promo', $nopromo)->where('user_code', auth()->user()->code)->get();
        $cartPacks = $cart->pluck('pack');

        $checkbundle = DB::table('Luv2_promo_item')
            ->where('Luv2_promo_item.company_code', auth()->user()->company_code)
            ->join('Luv2_promo', 'Luv2_promo_item.no', '=', 'Luv2_promo.no')
            ->where('Luv2_promo_item.no', $nopromo)
            ->where('Luv2_promo.tipe', $promo_tipe)
            ->whereNotIn('pack', $cartPacks)
            ->orderByRaw('RANDOM()') // Order by random
            ->get();

        $fulfilled = true;
        $unfulfilledItems = [];

        foreach ($checkbundle as $bundleItem) {
            if (!in_array($bundleItem->pack, $cart->pluck('pack')->toArray())) {
                $fulfilled = false;
                $unfulfilledItems[] = $bundleItem; // Add unfulfilled items to the array
            }
        }
        // dd($unfulfilledItems, $checkbundle);
        $unfulfilledItemsCollect = collect($unfulfilledItems);
        // dd($unfulfilledItemsCollect);
        $unfulfilledItemDetails = [];
        foreach ($unfulfilledItemsCollect->unique('pack') as $item) {
            $itemDetails = DB::table('Luv2_item')->where('company_code', auth()->user()->company_code)->where('code', $item->item_code)->first();

            // Check if the pack is in the cart
            $packInCart = $cart->pluck('pack')->contains($item->pack);

            // Check if the item details exist and the pack is not in the cart
            if ($itemDetails && !$packInCart) {
                $itemDetails->no = $item->no; // Add the 'no' field to the item details
                $itemDetails->pack = $item->pack;
                $unfulfilledItemDetails[] = $itemDetails;
            }
        }
        if (!$fulfilled) {
            $this->isSuggestion = true;
            $this->suggestion = $unfulfilledItemDetails;
        } else {
            $this->isSuggestion = false;
            $this->suggestion = [];
        }

        $this->dispatch('suggestionToTable', $this->isSuggestion, $this->suggestionName, $this->suggestion)->to(Table::class);
    }

    #[On('addSuggestion')]
    public function addSuggestion($itemcode)
    {
        $product = DB::table('Luv2_item')
            ->where('company_code', auth()->user()->company_code)
            ->where('code', $itemcode)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();
        $this->isEnter = true;
        $this->dispatch('toAddProductSuggestion', $product, true);
    }

    #[On('addSuggestionFirst')]
    public function addSuggestionFirst($itemcode)
    {
        $product = DB::table('Luv2_item')
            ->where('company_code', auth()->user()->company_code)
            ->where('code', $itemcode)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();
        $this->isEnter = true;
        $this->dispatch('toAddProductSuggestion', $product, true);
        $this->dispatch('reRender')->to(Table::class);
    }


    #[On('toAddProductSuggestion')]
    public function toaddproduct($product, $isEnter)
    {
        $objectProduct = (object) $product;

        $this->toProduct($objectProduct, $isEnter);
        $this->save();
    }

    #[On('checkPriceBundle')]
    public function updatePriceBundleafterDelete($cart)
    {
        $nopromo = $cart['promo'];
        $cart = Cart::where('promo', $nopromo)->where('user_code', auth()->user()->code)->get();
        $checkbundle = DB::table('Luv2_promo_item')->where('company_code', auth()->user()->company_code)->where('no', $nopromo)->get();
        $fulfilled = true;

        foreach ($checkbundle as $bundleItem) {
            if (!in_array($bundleItem->pack, $cart->pluck('pack')->toArray())) {
                $fulfilled = false;
                break;
            }
        }

        if ($fulfilled) {
            $promo = DB::table('Luv2_promo')->where('company_code', auth()->user()->company_code)->where('no', $nopromo)->where('deleted', 'N')->first();
            $cart = Cart::where('promo', $nopromo)->where('user_code', auth()->user()->code)->get();
            if ($promo->tipe == 7) {
                if ($promo->benefit == 1) {
                    $cartcount = $cart->count();

                    $qtyDiscs = DB::table('Luv2_promo_bundling_qty')->where('no', $promo->no)
                        ->where('company_code', auth()->user()->company_code)
                        ->orderBy('qty', 'desc')
                        ->get();

                    $firstApplicableQty = null;
                    foreach ($qtyDiscs as $qtyDisc) {
                        if ($cartcount >= $qtyDisc->qty) {
                            $firstApplicableQty = $qtyDisc->qty;
                            break; // Stop looping once we find the highest applicable quantity
                        }
                    }

                    if ($firstApplicableQty !== null) {
                        // Find the corresponding discount record
                        $applicableQtyDisc = $qtyDiscs->firstWhere('qty', $firstApplicableQty);
                        // Apply discount only if a discount record is found
                        if ($applicableQtyDisc) {
                            $benefitDisc = $applicableQtyDisc->disc;
                            foreach ($cart as $crt) {
                                if (!Str::contains($crt->name, '( Pack Unlimited )')) {
                                    $crt->name = $crt->name . ' ( Pack Unlimited )';
                                }
                                // Calculate discount based on percentage
                                $discountAmount = ($applicableQtyDisc->disc / 100) * $crt->nprice;

                                $price = $crt->nprice - $discountAmount;
                                // Apply the discount
                                $crt->price = $price;
                                $crt->discount = $benefitDisc;
                                $crt->total_price = $crt->price * $crt->qty;

                                // Save the updated item
                                $crt->save();
                            }
                        }
                    } else {
                        foreach ($cart as $crt) {
                            $item = Item::where('code', $crt->code)
                                ->where('company_code', auth()->user()->company_code)->first();
                            // Update the price with the discount
                            $crt->name = $item->name;
                            $crt->price = $crt->nprice;
                            $crt->total_price = $crt->price * $crt->qty;

                            // Save the updated cart item
                            $crt->save();
                        }
                    }
                }
            }
        } else {
            $promo = DB::table('Luv2_promo')->where('company_code', auth()->user()->company_code)->where('no', $nopromo)->where('deleted', 'N')->first();
            $cart = Cart::where('promo', $nopromo)->where('user_code', auth()->user()->code)->get();
            if ($promo->tipe == 7) {
                if ($promo->benefit == 1) {
                    //do something
                }
            } else {
                //ubah ke harga normal
                session()->forget('Promo-' . $nopromo);
                if ($promo->tipe == 3) {
                    foreach ($cart as $crt) {
                        $item = Item::where('code', $crt->code)
                            ->where('company_code', auth()->user()->company_code)->first();
                        // Update the price with the discount
                        $crt->name = $item->name;
                        $crt->price = $crt->nprice;
                        $crt->discount = 0;
                        $crt->total_price = $crt->price * $crt->qty;

                        // Save the updated cart item
                        $crt->save();
                    }
                } elseif ($promo->tipe == 4) {
                    if ($promo->benefit == 1) { // free item
                        $freeItems = DB::table('Luv2_promo_item_gwp')->where('company_code', auth()->user()->company_code)->where('no', $promo->no)->pluck('item_code')->toArray();

                        foreach ($cart as $crt) {
                            $item = Item::where('code', $crt->code)
                                ->where('company_code', auth()->user()->company_code)->first();
                            // Update the price with the discount
                            $crt->name = $item->name;
                            $crt->price = $crt->nprice;
                            $crt->discount = 0;
                            $crt->total_price = $crt->price * $crt->qty;

                            // Save the updated cart item
                            $crt->save();
                        }
                        $cartItems = Cart::whereIn('code', $freeItems)->where('benefit', 'Free')
                            ->where('user_code', auth()->user()->code)
                            ->get();
                        $cartItems->each->delete();

                        session()->forget('Promo-GWP-FreeItem' . auth()->user()->id);

                        // Do something if $this->form->itemcode exists in $freeItems
                        // For example:
                        // echo "Item code exists in free items array";


                    } elseif ($promo->benefit == 2) {
                        foreach ($cart as $crt) {
                            $item = Item::where('code', $crt->code)
                                ->where('company_code', auth()->user()->company_code)->first();
                            // Update the price with the discount
                            $crt->name = $item->name;
                            $crt->price = $crt->nprice;
                            $crt->discount = 0;
                            $crt->total_price = $crt->price * $crt->qty;

                            // Save the updated cart item
                            $crt->save();
                        }
                        $cartItems = Cart::where('benefit', 'Cheapest')
                            ->where('user_code', auth()->user()->code)
                            ->get();
                        $cartItems->each->delete();

                        session()->forget('Promo-GWP-CheapestItem' . auth()->user()->id);
                        session()->forget('Promo-GWP-CheapestItemNONAKTIF' . auth()->user()->id);
                    } elseif ($promo->benefit == 3) {
                        session()->forget('Promo-Voucher-QTY' . auth()->user()->id);
                    }
                } elseif ($promo->tipe == 5) {
                } elseif ($promo->tipe == 6) {
                    // if ($promo->benefit == 1) {
                    //     session()->forget('Promo-Voucher-QTY' . auth()->user()->id);
                    // }
                }
            }
        }
        $this->dispatch('cart-created');
    }

    public function updatePriceBundle($nopromo)
    {
        $promo = DB::table('Luv2_promo')->where('deleted', 'N')->where('no', $nopromo)->where('company_code', auth()->user()->company_code)->first();
        $cart = Cart::where('promo', $nopromo)->where('user_code', auth()->user()->code)->get();

        $fulfilled = true;
        if ($promo->tipe == 7 && $promo->benefit == 1) { // jika unlimited bundle
            $checkbundle = DB::table('Luv2_promo_bundling_qty')->where('company_code', auth()->user()->company_code)->where('no', $promo->no)
                ->orderBy('qty', 'asc')
                ->first();
            if ($cart->count() >= $checkbundle->qty) {
            } else {
                $fulfilled = false;
            }
        } else {
            $syaratString = $promo->qty_pack;

            // Parse the string into an integer
            $syarat = intval($syaratString);

            // Generate an array from 1 to $syarat
            $requiredPacks = range(1, $syarat);

            foreach ($requiredPacks as $requiredPack) {
                // Check if any cart item has this required pack
                $packExistsInCart = false;

                // Loop through each cart item to check if it has the required pack
                foreach ($cart as $cartItem) {
                    if ($cartItem->pack == $requiredPack) {
                        $packExistsInCart = true;
                        break; // Exit the loop if the pack is found in the cart
                    }
                }

                // If the required pack is not found in any cart item, set fulfilled to false
                if (!$packExistsInCart) {
                    $fulfilled = false;
                    break; // Exit the loop if any required pack is not found in the cart
                }
            }
        }
        if ($fulfilled) {
            $promo = DB::table('Luv2_promo')->where('no', $nopromo)->where('deleted', 'N')->where('company_code', auth()->user()->company_code)->first();
            $cart = Cart::where('promo', $nopromo)->where('user_code', auth()->user()->code)->get();
            $totalPrice = $cart->sum('price');
            if ($promo->tipe == 7) {
                if ($promo->benefit == 1) {

                    $cartcount = $cart->count();
                    $qtyDiscs = DB::table('Luv2_promo_bundling_qty')->where('company_code', auth()->user()->company_code)->where('no', $promo->no)
                        ->where('qty', '>=', $cartcount)
                        ->orderBy('qty', 'asc')
                        ->get();

                    $firstApplicableQty = null;
                    foreach ($qtyDiscs as $qtyDisc) {
                        if ($cart->count() >= $qtyDisc->qty) {
                            $firstApplicableQty = $qtyDisc->qty;
                            break; // Stop looping once we find the first applicable quantity
                        }
                    }
                    if ($qtyDiscs) {
                        if ($firstApplicableQty !== null) {
                            // Find the corresponding discount record
                            $applicableQtyDisc = $qtyDiscs->firstWhere('qty', $firstApplicableQty);
                            // Apply discount only if a discount record is found
                            if ($applicableQtyDisc) {
                                $benefitDisc = $applicableQtyDisc->disc;
                                foreach ($cart as $crt) {
                                    if (!Str::contains($crt->name, '( Pack Unlimited )')) {
                                        $crt->name = $crt->name . ' ( Pack Unlimited )';
                                    }
                                    // Calculate discount based on percentage
                                    $discountAmount = ($applicableQtyDisc->disc / 100) * $crt->nprice;

                                    $price = $crt->nprice - $discountAmount;
                                    // Apply the discount
                                    $crt->price = $price;
                                    $crt->discount = $benefitDisc;
                                    $crt->total_price = $crt->price * $crt->qty;

                                    // Save the updated item
                                    $crt->save();
                                }
                            }
                        } else {

                            $prevcartdisc = Cart::where('promo', $nopromo)
                                ->where('user_code', auth()->user()->code)
                                ->first();

                            $benefitDisc = $prevcartdisc->discount;
                            foreach ($cart as $crt) {
                                if (!Str::contains($crt->name, '( Pack Unlimited )')) {
                                    $crt->name = $crt->name . ' ( Pack Unlimited )';
                                }
                                // Calculate discount based on percentage
                                $discountAmount = ($benefitDisc / 100) * $crt->nprice;

                                $price = $crt->nprice - $discountAmount;
                                // Apply the discount
                                $crt->price = $price;
                                $crt->discount = $benefitDisc;
                                $crt->total_price = $crt->price * $crt->qty;

                                // Save the updated item
                                $crt->save();
                            }
                        }
                    } else {
                    }
                } else {
                }
            } else {
                foreach ($cart as $crt) {
                    //Jika promo tipe bundling
                    if ($promo->tipe == 3) {
                        if ($promo->benefit == 1) { // bundle disc
                            $benefitDisc = $promo->disc;

                            // Calculate discount based on percentage
                            $discountAmount = ($promo->disc / 100) * $crt->price;
                            // Update the price with the discount
                            $crt->name = $crt->name . ' ( Pack ' . $crt->pack . ' )';
                            $crt->price -= $discountAmount;
                            $crt->discount = $benefitDisc;
                            $crt->total_price = $crt->price * $crt->qty;

                            //disini set sesuatu untuk stop the discount
                            session(['PromoBundlingFulfill' . auth()->user()->id => $promo->no]);
                        } elseif ($promo->benefit == 2) { // bundle special price
                            $benefitPrice = $promo->disc_price;
                            $benefitDecimal = ($totalPrice - $benefitPrice) / $totalPrice;

                            // Calculate the discount based on the percentage of the benefit price
                            $benefitDiscountforSpecialPrice = $crt->price * $benefitDecimal;
                            $afterBenefit = $crt->price - $benefitDiscountforSpecialPrice;
                            $crt->name = $crt->name . ' ( Pack ' . $crt->pack . ' )';

                            $crt->price = $afterBenefit;

                            $crt->discount = $benefitDiscountforSpecialPrice;
                            $crt->total_price = $crt->price * $crt->qty;

                            //disini set sesuatu untuk stop the discount
                            session(['PromoBundlingFulfill' . auth()->user()->id => $promo->no]);
                        } else {
                            // Handle other scenarios or default case
                        }
                        // Save the updated cart item
                        $crt->save();
                    } elseif ($promo->tipe == 4) {
                        if ($promo->benefit == 1) { // free item
                            $crt->name = $crt->name . ' ( Pack ' . $crt->pack . ' )';
                            session(['Promo-GWP-FreeItem' . auth()->user()->id => $promo->no]);
                        } elseif ($promo->benefit == 2) {
                            $crt->name = $crt->name . ' ( Pack ' . $crt->pack . ' )';
                            session(['Promo-GWP-CheapestItem' . auth()->user()->id => $promo->no]);
                            session(['PromoTingkat' . auth()->user()->id => $promo->no]);
                            $this->dispatch('openModalCheapest');
                        } elseif ($promo->benefit == 3) {
                            session(['Promo-Voucher-QTY' . auth()->user()->id => $promo->no]);
                        }
                        $crt->save();
                    } elseif ($promo->tipe == 5) {
                    } elseif ($promo->tipe == 6) {
                    }
                }
            }
        } else {
        }
        $this->dispatch('cart-created');
    }

    #[On('invoiceStatusChanged')]
    public function render()
    {
        $results = [];
        $members = [];
        $sales = [];
        $user = Auth::user();
        $wh = DB::table('Luv2_warehouse')->where('code', $user->whs_code)->where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
        if ($wh->pricelist_code == null || $wh->pricelist_code == '') {
            $this->alert('info', 'Pricelist pada warehouse ini belum di setting !', [
                'position' => 'top',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
        if (strlen($this->search) >= 1) {
            $results = DB::table('Luv2_item')->where('Luv2_item.company_code', auth()->user()->company_code)
                // ->join('Luv2_item_pricelist', function ($join) use ($user, $wh) {
                //     $join->on('Luv2_item.code', '=', 'Luv2_item_pricelist.item_code')
                //         ->where('Luv2_item_pricelist.company_code', '=', $user->company_code)
                //         ->where('Luv2_item_pricelist.pricelist_code', '=', $wh->pricelist_code);
                // })
                ->where(function ($query) {
                    $query->where('Luv2_item.code', 'ILIKE', '%' . $this->search . '%')
                        ->orWhere('Luv2_item.barcode', 'LIKE', '%' . $this->search . '%')
                        ->orWhere('Luv2_item.name', 'ILIKE', '%' . $this->search . '%');
                })
                ->limit(10)
                ->get();


            $this->products = $results;
        }

        if (strlen($this->searchmember) >= 1) {
            $members = DB::table('Luv2_member')->where('company_code', auth()->user()->company_code)->where('phone', 'LIKE', '%' . $this->searchmember . '%')
                ->limit(10)->get();
            $this->members = $members;
        }

        if (strlen($this->searchsales) >= 1) {
            $sales = DB::table('Luv2_salesemp')->where('company_code', auth()->user()->company_code)->where('name', 'ILIKE', '%' . $this->searchsales . '%')->where('active', 'Y')
                ->limit(10)->get();
            $this->sales = $sales;
        }

        $countinv = Invoice::where('sandbox', 'Y')->count();
        return view('livewire.cashier.transaction', [
            'products' => $results,
            'members' => $members,
            'sales' => $sales,
            'countinv' => $countinv,
            'carts' => Cart::where('user_code', $user->code)->get(),
        ]);
    }



    public function funcSelectProduct($identifier = null, $type = 'search')
    {
        // Determine the search value based on type
        $searchValue = null;
        $isEnter = false;

        switch ($type) {
            case 'search':
                $searchValue = $this->search;
                $isEnter = true;
                break;
            case 'click':
                $searchValue = $identifier; // barcode passed as parameter (from view)
                $isEnter = false;
                break;
            case 'button':
                $searchValue = $identifier; // barcode passed as parameter
                $isEnter = false;
                break;
            case 'dropdown':
                $this->selectedIndex = $identifier;           // Set the index
                if (isset($this->products[$identifier])) {
                    $this->selectedCode = $this->products[$identifier]->code;  // Get product code
                    $searchValue = $this->selectedCode;           // Search by product code
                    $isEnter = true;
                } else {
                    $this->handleProductError('notfound');
                    return;
                }
                break;
            default:
                $searchValue = $this->search;
                $isEnter = true;
        }

        // Validate search value
        if (empty($searchValue)) {
            if ($type === 'search') {
                $this->alert('info', 'Barcode is empty !', [
                    'position' => 'top',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
            return;
        }

        // Check if product is already selected (only for search type)
        if ($type === 'search' && $this->selectedProduct) {
            $this->dispatch('afterProduct')->to(CashierInvoice::class);
            return;
        }

        // Get product with stock information
        $product = DB::table('Luv2_item')
            ->leftJoin('Luv2_item_trans', 'Luv2_item.code', '=', 'Luv2_item_trans.item_code')
            ->select('Luv2_item.*', DB::raw('COALESCE(SUM("Luv2_item_trans"."qty"), 0) as trans_qty'))
            ->where('Luv2_item.company_code', auth()->user()->company_code)
            ->where(function ($query) use ($searchValue, $type) {
                if ($type === 'search' || $type === 'click') {
                    $query->where('Luv2_item.barcode', $searchValue);
                } else {
                    $query->where('Luv2_item.code', $searchValue);
                }
            })
            ->where('Luv2_item.sales', 'Y')
            ->where('Luv2_item.active', 'Y')
            ->where(function ($query) {
                $query->whereNull('Luv2_item_trans.company_code')
                    ->orWhere('Luv2_item_trans.company_code', auth()->user()->company_code);
            })
            ->where(function ($query) {
                $query->whereNull('Luv2_item_trans.whs_code')
                    ->orWhere('Luv2_item_trans.whs_code', auth()->user()->whs_code);
            })
            ->groupBy(
                'Luv2_item.code',
                'Luv2_item.barcode',
                'Luv2_item.name',
                'Luv2_item.active',
                'Luv2_item.sales',
                'Luv2_item.company_code'
            )
            ->first();


        // If product not found with stock info, try without
        if (!$product) {
            $product = DB::table('Luv2_item')
                ->select('Luv2_item.*', DB::raw('0 as trans_qty'))
                ->where('Luv2_item.company_code', auth()->user()->company_code)
                ->where(function ($query) use ($searchValue, $type) {
                    if ($type === 'search' || $type === 'click') {
                        $query->where('Luv2_item.barcode', $searchValue);
                    } else {
                        $query->where('Luv2_item.code', $searchValue);
                    }
                })
                ->first();
        }

        // Handle product validation errors
        if (!$product) {
            $this->handleProductError('notfound');
            return;
        }
        if ($product->active != 'Y') {
            $this->handleProductError('nonactive');
            return;
        }
        if ($product->sales != 'Y') {
            $this->handleProductError('nonsales');
            return;
        }
        if (!$this->isEnabledMinusTransaction && $product->trans_qty <= 0) {
            $this->handleProductError('outofstock');
            return;
        }

        // Check pricelist
        $wh = DB::table('Luv2_warehouse')
            ->where('code', auth()->user()->whs_code)
            ->where('company_code', auth()->user()->company_code)
            ->where('code', auth()->user()->whs_code)
            ->first();

        $pricelist = DB::table('Luv2_item_pricelist')
            ->where('company_code', auth()->user()->company_code)
            ->where('pricelist_code', $wh->pricelist_code)
            ->where('item_code', $product->code)
            ->first();

        if (!$pricelist) {
            $this->noPricelistProduct($searchValue);
            return;
        }

        // Process the product
        $this->toProduct($product, $isEnter);

        // Auto-save for all types
        $this->save();

        // Reset selection state for dropdown type
        if ($type === 'dropdown') {
            $this->selectedCode = null;
            $this->selectedIndex = null;
        }

        $this->isEnter = $isEnter;
    }

    public function selectProduct($index)
    {
        $this->funcSelectProduct($index, 'dropdown');
    }

    // Legacy method aliases for backward compatibility
    public function selectProductByName()
    {
        $this->funcSelectProduct(null, 'search');
    }

    public function selectProductByClick($itemCode)
    {
        $this->funcSelectProduct($itemCode, 'click');
    }

    public function selectProductByButton($barcode)
    {
        $this->funcSelectProduct($barcode, 'button');
    }

    // The original selectProduct method is now the unified function above

    public function noProduct($code)
    {
        $productcheck = Item::where('barcode', $code)
            ->where('company_code', auth()->user()->company_code)
            ->first();
        if ($productcheck) {
            if ($productcheck->active == 'N') {
                $this->dispatch('itemnonactive');
            } else {
                $this->dispatch('itemnonsales');
            }
            $this->reset(['search', 'selectedProduct', 'price', 'products']);
        } else {
            $this->dispatch('itemnotfound');
        }
    }

    public function noPricelistProduct($code)
    {

        $this->dispatch('itemnonpricelist');
        $this->reset(['search', 'selectedProduct', 'price', 'products']);
    }




    // #[On('clearAfterSelectProduct')]
    // public function clearAfterSelectProduct()
    // {
    //     $this->reset(['search', 'selectedProduct', 'price']);
    //     $this->products = [];
    // }

    public function toProduct($product, $isEnter)
    {
        $user = Auth::user();
        $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
        $getpricelist = DB::table('Luv2_pricelist')->where('code', $whs->pricelist_code)->first();
        $pricelist = $getpricelist->code;
        $this->isEnter = $isEnter;


        // if (session('discountmemb') == 1) { // dinonaktifkandulu
        //     // Apply discount for member
        //     $pricelist = $setting->member_pricelist;
        // }
        $this->selectedProduct = $product;
        $itemCode = $product->code;
        $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $itemCode)->where('pricelist_code', $pricelist)->first();
        // dd($prices);
        // Check apakah ada discount di periode tanggal sekarang
        $currentDate = Carbon::now()->toDateString();
        $dataDisc = DB::table('Luv2_promo')
            ->where('deleted', 'N')
            ->join('Luv2_promo_item', 'Luv2_promo.no', '=', 'Luv2_promo_item.no')
            ->whereDate('from_date', '<=', $currentDate)
            ->whereDate('to_date', '>=', $currentDate)
            ->where('item_code', $itemCode)
            ->where('Luv2_promo.company_code', auth()->user()->company_code)
            ->select(
                'Luv2_promo.no',
                'Luv2_promo.name',
                'Luv2_promo.from_date',
                'Luv2_promo.to_date',
                'Luv2_promo.voucher_from_date',
                'Luv2_promo.voucher_to_date',
                'Luv2_promo.tipe',
                'Luv2_promo.benefit',
                'Luv2_promo.disc',
                'Luv2_promo.disc_price',
                'Luv2_promo_item.company_code',
                'Luv2_promo_item.item_code',
                'Luv2_promo_item.pack',
                'Luv2_promo_item.disc',
                'Luv2_promo_item.disc_price',
            )
            ->groupBy('Luv2_promo.no', 'Luv2_promo.name', 'Luv2_promo.from_date', 'Luv2_promo.to_date', 'Luv2_promo.voucher_from_date', 'Luv2_promo.voucher_to_date', 'Luv2_promo.tipe', 'Luv2_promo.benefit', 'Luv2_promo.benefit', 'Luv2_promo.disc', 'Luv2_promo.disc_price', 'Luv2_promo_item.company_code', 'Luv2_promo_item.item_code', 'Luv2_promo_item.pack', 'Luv2_promo_item.disc', 'Luv2_promo_item.disc_price',)
            ->get();
        if (session()->has('Promo-GWP-FreeItem' . auth()->user()->id)) {
            $dataDisc = [];
        }
        $this->dataDisc = $dataDisc;
        if (session()->has('Promo-Voucher-Value' . auth()->user()->id)) {
            $dataDiscFilter = [];
            foreach ($dataDisc as $record) {

                if (!($record->tipe == 4 && $record->benefit == 3)) {
                    $no = $record->no;
                    $pack = $record->pack;
                    if (!isset($dataDiscFilter[$no]) || $pack < $dataDiscFilter[$no]->pack) {
                        $dataDiscFilter[$no] = $record;
                    }
                }
            }

            $dataDiscFilter = array_values($dataDiscFilter);
            $this->dataDisc = $dataDiscFilter;
        }
        if (session()->has('Promo-GWP-ValueCheapest' . auth()->user()->id)) {
            $dataDiscFilter = [];
            foreach ($dataDisc as $record) {

                if (!($record->tipe == 4 && $record->benefit == 3)) {
                    $no = $record->no;
                    $pack = $record->pack;
                    if (!isset($dataDiscFilter[$no]) || $pack < $dataDiscFilter[$no]->pack) {
                        $dataDiscFilter[$no] = $record;
                    }
                }
            }

            $dataDiscFilter = array_values($dataDiscFilter);
            $this->dataDisc = $dataDiscFilter;
        }

        $dataDiscCollection = collect($this->dataDisc);
        $countDataDisc = $dataDiscCollection->pluck('no')->unique()->count();
        $productprices = $prices->price;

        $this->form->nprice = $productprices;
        // Jika ada pakai discountnya
        if (empty($dataDisc) || $dataDisc->isEmpty()) {
            $this->form->itemprice = $productprices;
            $this->price = $productprices;
            $this->form->discount = 0;
            // dd($this->form);
        } else {
            if ($countDataDisc > 1) {
                $existingCart = Cart::where('code', $itemCode)
                    ->where('user_code', auth()->user()->code)
                    ->first();
                if (!$existingCart) {
                    $this->dispatch('selectDiscount', $dataDisc)->to(SelectDiscount::class);
                }
            } else {
                if ($dataDisc[0]->tipe == 3) {
                    $checkcart = Cart::where('promo', $dataDisc[0]->no)
                        ->where('user_code', auth()->user()->code)
                        ->first();
                    if ($checkcart) {
                        //tambahkan logic kalau sudah ada packnya ambil pack yang belum ada
                        $packinCarts = Cart::where('promo', $dataDisc[0]->no)
                            ->where('user_code', auth()->user()->code)
                            ->pluck('pack');
                        $filteredDataDisc = $dataDisc->whereNotIn('pack', $packinCarts);
                        $filteredDataDiscArray = array_values($filteredDataDisc->toArray());
                        // dd($filteredDataDiscArray, $filteredDataDisc);
                        $productprices = $prices->price;

                        if (empty($filteredDataDiscArray)) {
                            $this->form->pack = $dataDisc[0]->pack;
                        } else {
                            $this->form->pack = $filteredDataDiscArray[0]->pack;
                        }
                    } else {
                        $productprices = $prices->price;

                        $this->form->pack = $dataDisc[0]->pack;
                    }

                    $this->form->itemprice = $productprices;
                    $this->price = $productprices;
                    $this->form->discount = 0;
                    $this->form->promo = $dataDisc[0]->no;
                    $this->form->promotipe = $dataDisc[0]->tipe;

                    $existsInDataDisc = false;
                    foreach ($this->dataDisc as $disc) {
                        if ($disc->no == $dataDisc[0]->no) {
                            $existsInDataDisc = true;
                            break;
                        }
                    }
                    if ($existsInDataDisc) {
                        if ($this->isEnter) {
                            $this->dispatch('toModalProcessDiscBundle', $dataDisc[0]);
                        } else {
                            $this->dispatch('toModalProcessDiscBundleWithDisc', $dataDisc[0], $this->form);
                        }
                    }
                } elseif ($dataDisc[0]->tipe == 4) {
                    // Add logic for tipe == 4
                    // For example:
                    $productprices = $prices->price;
                    $this->form->itemprice = $productprices;
                    $this->price = $productprices;
                    $this->form->discount = $dataDisc[0]->disc;
                    $this->form->promo = $dataDisc[0]->no;
                    $this->form->promotipe = $dataDisc[0]->tipe;
                    $this->form->pack = $dataDisc[0]->pack;
                    $existsInDataDisc = false;

                    foreach ($this->dataDisc as $disc) {
                        if ($disc->no === $dataDisc[0]->no) {
                            $existsInDataDisc = true;
                            break;
                        }
                    }
                    if ($existsInDataDisc) {
                        $this->dispatch('toModalProcessDiscount', $dataDisc[0], $this->form);
                    }
                    $this->reset(['search', 'selectedProduct', 'price']);
                    $this->products = [];
                } elseif ($dataDisc[0]->tipe == 5) {
                    $productprices = $prices->price;
                    $this->form->itemprice = $productprices;
                    $this->price = $productprices;
                    $this->form->discount = $dataDisc[0]->disc;
                    $this->form->promo = $dataDisc[0]->no;
                    $this->form->promotipe = $dataDisc[0]->tipe;
                    $this->form->pack = $dataDisc[0]->pack;
                } elseif ($dataDisc[0]->tipe == 6) {
                    $productprices = $prices->price;
                    $this->form->itemprice = $productprices;
                    $this->price = $productprices;
                    $this->form->discount = $dataDisc[0]->disc;
                    $this->form->promo = $dataDisc[0]->no;
                    $this->form->promotipe = $dataDisc[0]->tipe;
                    $this->form->pack = $dataDisc[0]->pack;
                } elseif ($dataDisc[0]->tipe == 7) {
                    $productprices = $prices->price;
                    $this->form->itemprice = $productprices;
                    $this->price = $productprices;
                    $this->form->discount = $dataDisc[0]->disc;
                    $this->form->promo = $dataDisc[0]->no;
                    $this->form->promotipe = $dataDisc[0]->tipe;
                    $this->form->pack = $dataDisc[0]->pack;
                    if ($this->isEnter) {
                        $this->dispatch('toModalProcessDiscBundle', $dataDisc[0]);
                    } else {
                        $this->dispatch('toModalProcessDiscBundleWithDisc', $dataDisc[0], $this->form);
                    }
                    $this->reset(['search', 'selectedProduct', 'price']);
                    $this->products = [];
                } elseif ($dataDisc[0]->tipe == 2) {
                    $productprices = $dataDisc[0]->disc_price;
                    $this->form->itemprice = $productprices;
                    $this->price = $productprices;
                    $this->form->discount = $this->form->nprice - $productprices;
                    $this->form->promo = $dataDisc[0]->no;
                    $this->form->promotipe = $dataDisc[0]->tipe;
                } else {
                    $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $itemCode)->where('pricelist_code', $pricelist)->first();
                    $itemPrice = $prices->price; // Assuming $this->form->itemprice is a numeric value
                    $discountPercentage = $dataDisc[0]->disc; // Example discount percentage
                    $itemPrice = floatval($itemPrice);
                    $discountedPrice = $itemPrice * (1 - $discountPercentage / 100);
                    $productprices = $prices->price * $dataDisc[0]->disc;
                    $this->form->itemprice = $discountedPrice;
                    $this->price = $discountedPrice;
                    $this->form->discount = $this->form->nprice - $discountedPrice;
                    $this->form->promo = $dataDisc[0]->no;
                    $this->form->promotipe = $dataDisc[0]->tipe;
                }
            }
        }

        $this->selectedProduct = $product;
        //Populate form
        $this->form->itemname = $product->name;
        $this->form->itemcode = $product->code;
        $this->form->itemqty = 1;
        $this->search = $product->code; // Update the search field with the selected product's code
        $this->itemcodeprice = $product->code;
        $this->products = [];
        $this->dispatch('updateTotalAmount')->to(CashierInvoice::class);
        $this->dispatch('cart-created')->to(Table::class);
    }

    #[On('selectedNormalPrice')]
    public function selectedNormalPrice($itemcode): void
    {
        //Nanti diisi disini jika ada kondisi logic normal price
    }

    #[On('selectedDiscountData')]
    public function toModalProcessDiscount($data): void
    {
        $user = Auth::user();
        $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
        $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();
        $pricelist = $getpricelist->code;

        if ($data['tipe'] == 3) {
            $prices = ItemPrice::where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
            $productprices = floatval($prices->price);

            $checkcart = Cart::where('promo', $data['no'])
                ->where('lostsale', 'N')
                ->where('user_code', auth()->user()->code)
                ->first();
            $promo = DB::table('Luv2_promo')->where('no', $data['no'])->where('deleted', 'N')->first();


            $firstAvailablePack = $this->checkAvailablePacks($data['item_code'], $data['no'], $data['tipe']);

            if ($firstAvailablePack) {
                $this->form->pack = $firstAvailablePack;
            } else {
                $this->form->pack = $data['pack'];
            }

            $this->form->itemprice = $productprices;
            $this->price = $productprices;
            $this->form->discount = floatval($data['disc']);
            $this->form->promo = $data['no'];
            $this->form->promotipe = $data['tipe'];
        } elseif ($data['tipe'] == 4) { // tambahkan jika datadisc 4 dan seterusnya
            $prices = ItemPrice::where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
            $productprices = floatval($prices->price);

            $this->form->itemprice = $productprices;
            $this->price = $productprices;
            $this->form->discount = floatval($data['disc']);
            $this->form->promo = $data['no'];
            $this->form->promotipe = $data['tipe'];
            $firstAvailablePack = $this->checkAvailablePacks($data['item_code'], $data['no'], $data['tipe']);

            if ($firstAvailablePack) {

                $this->form->pack = $firstAvailablePack;
            } else {
                $this->form->pack = $data['pack'];
            }
        } elseif ($data['tipe'] == 5) {
            $prices = ItemPrice::where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
            $productprices = floatval($prices->price);

            $this->form->itemprice = $productprices;
            $this->price = $productprices;
            $this->form->discount = floatval($data['disc']);
            $this->form->promo = $data['no'];
            $this->form->promotipe = $data['tipe'];
            $this->form->pack = $data['pack'];
        } elseif ($data['tipe'] == 6) {
            $prices = ItemPrice::where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
            $productprices = floatval($prices->price);

            $this->form->itemprice = $productprices;
            $this->price = $productprices;
            $this->form->discount = floatval($data['disc']);
            $this->form->promo = $data['no'];
            $this->form->promotipe = $data['tipe'];
            $firstAvailablePack = $this->checkAvailablePacks($data['item_code'], $data['no'], $data['tipe']);

            if ($firstAvailablePack) {

                $this->form->pack = $firstAvailablePack;
            } else {
                $this->form->pack = $data['pack'];
            }
        } elseif ($data['tipe'] == 2) {
            if ($data['benefit'] == 1) {
                $promo = DB::table('Luv2_promo')->where('no', $data['no'])->first();

                //nanti disini ya 3
                $cart = Cart::where('user_code', auth()->user()->code)
                    ->where('lostsale', 'N')
                    ->where(function ($query) {
                        $query->where('benefit', 'N')
                            ->orWhere('benefit', 0);
                    })
                    ->get();

                $cartTotalPrice = floatval($cart->sum('total_price'));
                if ($cartTotalPrice >= floatval($promo->value_pack)) {
                    $productprices = floatval($data['disc_price']);
                    $this->form->itemprice = $productprices;
                    $this->price = $productprices;
                    $this->form->discount = floatval($this->form->nprice) - $productprices;
                    $this->form->promo = $data['no'];
                    $this->form->promotipe = $data['tipe'];
                } else {
                    $this->form->itemprice = floatval($this->form->nprice);
                    $this->price = floatval($this->form->nprice);
                    $this->form->discount = 0;
                    $this->form->promo = 0;
                    $this->form->promotipe = 0;
                }
            } else {
                $productprices = floatval($data['disc_price']);
                $this->form->itemprice = $productprices;
                $this->price = $productprices;
                $this->form->discount = floatval($this->form->nprice) - $productprices;
                $this->form->promo = $data['no'];
                $this->form->promotipe = $data['tipe'];
                $cart = Cart::where('code', $data['item_code'])
                    ->where('user_code', auth()->user()->code)
                    ->where('lostsale', 'N')
                    ->first();
                $cart->update([
                    'price' => $this->form->itemprice,
                    'discount' => $this->form->discount,
                    'promo' => $this->form->promo,
                    'promo_tipe' => $this->form->promotipe,
                    'pack' => $this->form->pack,
                    'total_price' => floatval($this->form->itemprice) * $cart->qty,
                ]);

                $this->dispatch('cart-created')->to(Table::class);
            }
        } elseif ($data['tipe'] == 7) {
            $prices = ItemPrice::where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
            $productprices = floatval($prices->price);

            $this->form->itemprice = $productprices;
            $this->price = $productprices;
            $this->form->discount = floatval($data['disc']);
            $this->form->promo = $data['no'];
            $this->form->promotipe = $data['tipe'];
            $this->form->pack = $data['pack'];
            $this->dispatch('toModalProcessDiscBundleWithDisc', $data, $this->form);
            $this->reset(['search', 'selectedProduct', 'price']);
        } else {
            $prices = ItemPrice::where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
            $itemPrice = floatval($prices->price); // Assuming $this->form->itemprice is a numeric value

            //nanti disini ya 4
            if ($data['benefit'] == 1) {
                $promo = DB::table('Luv2_promo')->where('no', $data['no'])->first();
                $cart = Cart::where('user_code', auth()->user()->code)
                    ->where('lostsale', 'N')
                    ->where(function ($query) {
                        $query->where('benefit', 'N')
                            ->orWhere('benefit', 0);
                    })
                    ->get();

                $cartTotalPrice = floatval($cart->sum('total_price'));
                if ($cartTotalPrice >= floatval($promo->value_pack)) {
                    $discountPercentage = floatval($data['disc']); // Example discount percentage
                    $discountedPrice = $itemPrice * (1 - $discountPercentage / 100);
                    $productprices = $itemPrice * $discountPercentage;
                    $this->form->itemprice = $discountedPrice;
                    $this->price = $discountedPrice;
                    $this->form->discount = floatval($this->form->nprice) - $discountedPrice;
                    $this->form->promo = $data['no'];
                    $this->form->promotipe = $data['tipe'];
                    $cart = Cart::where('code', $data['item_code'])
                        ->where('user_code', auth()->user()->code)
                        ->where('lostsale', 'N')
                        ->first();
                    $cart->update([
                        'price' => $this->form->itemprice,
                        'discount' => $this->form->discount,
                        'promo' => $this->form->promo,
                        'promo_tipe' => $this->form->promotipe,
                        'pack' => $this->form->pack,
                        'total_price' => floatval($this->form->itemprice) * $cart->qty,
                    ]);
                    $this->dispatch('cart-created')->to(Table::class);
                } else {
                    $this->form->itemprice = $itemPrice;
                    $this->price = $itemPrice;
                    $this->form->discount = 0;
                    $this->form->promo = 0;
                    $this->form->promotipe = 0;
                    $cart = Cart::where('code', $data['item_code'])
                        ->where('user_code', auth()->user()->code)
                        ->where('lostsale', 'N')
                        ->first();
                    $cart->update([
                        'price' => $this->form->itemprice,
                        'discount' => $this->form->discount,
                        'promo' => $this->form->promo,
                        'promo_tipe' => $this->form->promotipe,
                        'pack' => $this->form->pack,
                        'total_price' => floatval($this->form->itemprice) * $cart->qty,
                    ]);
                }
            } else {

                $discountPercentage = floatval($data['disc']); // Example discount percentage
                $discountedPrice = $itemPrice * (1 - $discountPercentage / 100);
                $discount = $itemPrice - $discountedPrice;
               
                $this->form->itemprice = $discountedPrice;
                $this->price = $discountedPrice;
                $this->form->discount = $discount;
                $this->form->promo = $data['no'];
                $this->form->promotipe = $data['tipe'];
                $cart = Cart::where('code', $data['item_code'])
                ->where('user_code', auth()->user()->code)
                ->where('lostsale', 'N')
                ->first();
            $cart->update([
                'price' => $this->form->itemprice,
                'discount' => $this->form->discount,
                'promo' => $this->form->promo,
                'promo_tipe' => $this->form->promotipe,
                'pack' => $this->form->pack,
                'total_price' => floatval($this->form->itemprice) * $cart->qty,
            ]);
            }
        }
        if ($data['tipe'] == 4) {
            $this->dispatch('toModalProcessDiscount', $data, $this->form);
            $this->reset(['search', 'selectedProduct', 'price']);
            $this->products = [];
            // dd($data);
        } elseif ($data['tipe'] == 3) {
            if ($this->isEnter) {
                $this->dispatch('toModalProcessDiscBundle', $data);
            } else {
                $this->dispatch('toModalProcessDiscBundleWithDisc', $data, $this->form);
            }
        } else {
            $this->save();
            $this->dispatch('cart-created')->to(Table::class);
        }
    }



    #[On('openModalSelect')]
    public function openModalSelect()
    {
        $this->openmodalDisc = true;
        $this->dispatch('openTheModal');
    }

    #[On('closeModalDisctoTransaction')]
    public function closeModalSelect()
    {
        $this->openmodalDisc = false;
    }

    #[On('selectedValueData')]
    public function selectedValueData($data)
    {
        $promo = DB::table('Luv2_promo')->where('deleted', 'N')->where('no', $data)->where('company_code', auth()->user()->company_code)->first();
        if ($promo->tipe == 5 && $promo->benefit == 1) {
            session(['Promo-GWP-ValueFreeItem' . auth()->user()->id => $promo->no]);
        } elseif ($promo->tipe == 5 && $promo->benefit == 2) {
            session(['Promo-GWP-ValueCheapest' . auth()->user()->id => $promo->no]);
        } elseif ($promo->tipe == 6 && $promo->benefit == 2) {
            session(['Promo-Voucher-Value' . auth()->user()->id => $promo->no]);
        }
    }

    // #[On('selectedDiscountData')]
    // public function selectedDiscountData($data)
    // {
    //     $user = Auth::user();
    //     $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
    //     $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();

    //     $pricelist = $getpricelist->code;

    //     // if (session('discountmemb') == 1) { //dinonaktifkandulu
    //     //     // Apply discount for member
    //     //     $pricelist = $setting->member_pricelist;
    //     // }
    //     $checkcart = Cart::where('code', $data['item_code'])
    //         ->where('user_code', auth()->user()->code)
    //         ->first();
    //     if ($checkcart) {
    //         $productprices = $data['disc_price'];

    //         $checkcart->update([
    //             'price' => $productprices,
    //             'total_price' => $productprices * $checkcart->qty,
    //             'promo' => $data['no'],
    //             'promo_tipe' => $data['tipe'],
    //             'pack' => $data['pack']
    //         ]);
    //     } else {
    //         if ($data['tipe'] == 3) {
    //             $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
    //             $productprices = $prices->price;
    //             $checkcart = Cart::where('promo', $data['no'])
    //                 ->where('user_code', auth()->user()->code)
    //                 ->first();
    //             $promo = DB::table('Luv2_promo')->where('company_code', auth()->user()->company_code)->where('no', $data['no'])->where('deleted', 'N')->first();
    //             if ($promo->benefit == 3) {
    //                 $benefitDisc = $promo->disc;

    //                 // Calculate discount based on percentage
    //                 $discountAmount = ($benefitDisc / 100) * $productprices;
    //                 $this->price = $productprices - $discountAmount;
    //                 $this->form->itemprice = $productprices - $discountAmount;

    //                 $this->form->discount = $benefitDisc;
    //             } else {
    //                 $firstAvailablePack = $this->checkAvailablePacks($data['item_code'], $data['no'], $data['tipe']);

    //                 if ($firstAvailablePack) {
    //                     $this->form->pack = $firstAvailablePack;
    //                 } else {
    //                     $this->form->pack = $data['pack'];
    //                 }

    //                 $this->form->itemprice = $productprices;
    //                 $this->price = $productprices;
    //                 $this->form->discount = $data['disc'];
    //             }


    //             $this->form->promo = $data['no'];
    //             $this->form->promotipe = $data['tipe'];
    //         } elseif ($data['tipe'] == 4) { // tambahkan jika datadisc 4 dan seterusnya
    //             $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
    //             $productprices = $prices->price;
    //             $this->form->itemprice = $productprices;
    //             $this->price = $productprices;
    //             $this->form->discount = $data['disc'];
    //             $this->form->promo = $data['no'];
    //             $this->form->promotipe = $data['tipe'];
    //             $firstAvailablePack = $this->checkAvailablePacks($data['item_code'], $data['no'], $data['tipe']);

    //             if ($firstAvailablePack) {

    //                 $this->form->pack = $firstAvailablePack;
    //             } else {
    //                 $this->form->pack = $data['pack'];
    //             }
    //         } elseif ($data['tipe'] == 5) {
    //             $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
    //             $productprices = $prices->price;
    //             $this->form->itemprice = $productprices;
    //             $this->price = $productprices;
    //             $this->form->discount = $data['disc'];
    //             $this->form->promo = $data['no'];
    //             $this->form->promotipe = $data['tipe'];
    //             $this->form->pack = $data['pack'];
    //         } elseif ($data['tipe'] == 6) {
    //             $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
    //             $productprices = $prices->price;
    //             $this->form->itemprice = $productprices;
    //             $this->price = $productprices;
    //             $this->form->discount = $data['disc'];
    //             $this->form->promo = $data['no'];
    //             $this->form->promotipe = $data['tipe'];
    //             $firstAvailablePack = $this->checkAvailablePacks($data['item_code'], $data['no'], $data['tipe']);

    //             if ($firstAvailablePack) {

    //                 $this->form->pack = $firstAvailablePack;
    //             } else {
    //                 $this->form->pack = $data['pack'];
    //             }
    //         } elseif ($data['tipe'] == 2) {
    //             $productprices = $data['disc_price'];
    //             $this->form->itemprice = $productprices;
    //             $this->price = $productprices;
    //             $this->form->discount = $this->form->nprice - $productprices;
    //             $this->form->promo = $data['no'];
    //             $this->form->promotipe = $data['tipe'];
    //         } elseif ($data['tipe'] == 7) {
    //             $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
    //             $productprices = $prices->price;
    //             $this->form->itemprice = $productprices;
    //             $this->price = $productprices;
    //             $this->form->discount = $data['disc'];
    //             $this->form->promo = $data['no'];
    //             $this->form->promotipe = $data['tipe'];
    //             $this->form->pack = $data['pack'];
    //         } else {
    //             $prices = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $data['item_code'])->where('pricelist_code', $pricelist)->first();
    //             $itemPrice = $prices->price; // Assuming $this->form->itemprice is a numeric value
    //             $discountPercentage = $data['disc']; // Example discount percentage
    //             $itemPrice = floatval($itemPrice);
    //             $discountedPrice = $itemPrice * (1 - $discountPercentage / 100);
    //             $productprices = $prices->price * $data['disc'];
    //             $this->form->itemprice = $discountedPrice;
    //             $this->price = $discountedPrice;
    //             $this->form->discount = $this->form->nprice - $discountedPrice;
    //             $this->form->promo = $data['no'];
    //             $this->form->promotipe = $data['tipe'];
    //         }
    //         $this->save();
    //     }
    //     $this->dispatch('cart-created')->to(Table::class);
    // }

    #[On('disabledbutton')]
    public function disabledbutton()
    {
        $this->enable = false;
    }

    #[On('enablebutton')]
    public function enablebutton()
    {
        $this->enable = true;
    }

    public function selectMemberByCode()
    {

        $member = Member::where('code', $this->searchmember)
            ->where('company_code', auth()->user()->company_code)
            ->first();

        if ($member) {
            $this->otp = $this->generateOTP();
            $this->storeOTP($member->code, $this->otp);
            $this->sendOTPMessage($member->code, $this->otp);
            $this->memberCode = $this->searchmember;
            $this->dispatch('openModalOTP');
            $this->dispatch('countdown');
        } else {
            $this->searchmember = null;
            $this->dispatch('openModalCreateMember');
        }
    }
    public function resendOTP()
    {
        $this->otp = $this->generateOTP();
        $this->storeOTP($this->memberCode, $this->otp);
        $this->sendOTPMessage($this->memberCode, $this->otp);
        $this->dispatch('countdown');
    }


    public function verifyOTP()
    {
        // $this->sendOTPMessage($member->phone, $this->otp);
        $memberId = $this->memberCode;
        $member = Member::where('code', $memberId)->first();

        if ($this->verifyStoredOTP($memberId, $this->reqOTP)) {
            // Set the session variable 'member' to the member's ID
            session(['member' => $member->code]);
            $user = Auth::user();

            $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
            $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();

            $pricelist = $getpricelist->code;

            $now = now();

            // Update the member ID for the user's cart items
            $carts = Cart::where('user_code', auth()->user()->code)->get();

            if ($carts) {
                // First loop to update the 'price' and save the changes
                foreach ($carts as $cart) {
                    $price = $cart->price;
                    if ($cart->member_code === null) { //dinonaktifkandulu
                        // if (session('discountmemb') == 2) { // 2 dan pakai member

                        //     $price = $cart->price - ($cart->price * $setting->member_disc);
                        // } elseif (session('discountmemb') == 1) {
                        //     $pricedisc = ItemPriceListDisc::where('item_code', $cart->code)
                        //         ->where('cardcode', $memberId)
                        //         ->whereDate('from_date', '<=', $now)
                        //         ->whereDate('to_date', '>=', $now)
                        //         ->first();

                        //     if ($pricedisc) {
                        //         $price = $pricedisc->disc_price;
                        //         $discount = 1;
                        //     } else {
                        //         $discount = 0;
                        //     }
                        // } else {
                        //     // No discount applies
                        // }
                        $cart->price = $price; // Adjust the price calculation as needed
                        $cart->member_code = $member->code;
                        $cart->save(); // Save the updated 'price' values
                    }
                    $cart->member_code = $member->code;
                    $cart->save(); // Save the updated 'price' values
                }

                // Second loop to update the 'total_price' based on the updated 'price' values
                foreach ($carts as $cart) {
                    $cart->total_price = $cart->price * $cart->qty;
                    $cart->save(); // Save the updated 'total_price' values
                }
            } else {
                // Do nothing if there are no carts
            }
            $this->errMsg = 'OTP is Valid';

            $this->alert('info', 'Member selected: ' . $member->name, [
                'position' => 'top',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
            $this->isDropdownVisible = false; // Close the dropdown

            $this->dispatch('cart-created');
            $this->dispatch('closeModalOTP');
            $this->errMsg = '';
            $this->reqOTP = '';
        } else {
            $this->errMsg = 'OTP is not Valid';
            session()->forget('member');
        }
    }

    public function selectMemberByClick($memberId)
    {

        $member = Member::where('code', $memberId)
            ->where('company_code', auth()->user()->company_code)
            ->first();
        $this->otp = $this->generateOTP();
        $this->storeOTP($member->code, $this->otp);
        $this->sendOTPMessage($member->code, $this->otp);
        $this->searchmember = $member->name;
        $this->memberCode = $memberId;
        $this->dispatch('countdown');
    }

    public function selectMember($index)
    {
        $this->selectedIndexMember = $index;
        $this->selectedCodeMember = $this->members[$index]->code;
        $member = Member::where('code', $this->selectedCodeMember)
            ->where('company_code', auth()->user()->company_code)
            ->first();
        if ($member) {
            $this->otp = $this->generateOTP();
            $this->storeOTP($this->selectedCodeMember, $this->otp);
            $this->sendOTPMessage($member->code, $this->otp);
            $this->memberCode = $this->selectedCodeMember;
            $this->searchmember = $member->name;
            $this->dispatch('openModalOTP');
            $this->dispatch('countdown');
            $this->selectedIndexMember = null;
            $this->selectedCodeMember = null;
        }
    }

    public function selectSalesByClick($salesCode)
    {

        $sales = Sales::where('code', $salesCode)->first();

        if ($sales) {

            $this->searchsales = $sales->name;
            $this->selectedSales = $sales;
            $this->form->sales = $sales->code;

            $this->dispatch('selectedSalesChanged', $this->selectedSales);
            $this->dispatch('selectedSalesChangedAfterModal', $this->selectedSales)->to(Table::class);
            $this->dispatch('selectedSalesChanged', $this->selectedSales)->to(CashierInvoice::class);
            $this->dispatch('selectedSalesChangedAfterModal', $this->selectedSales)->to(Table::class);

            $this->isDropdownsalesVisible = false; // Close the dropdown
            $this->alert('info', 'Sales: ' . $sales->name, [
                'position' => 'top',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
        $this->isSalesModalVisible = false;
        $this->dispatch('closeSalesModal', $this->isSalesModalVisible)->to(Table::class);
    }

    public function selectSalesBySave()
    {
        if ($this->selectedSales) {
        } else {
            $sales = Sales::whereRaw('LOWER(name) = ?', strtolower($this->searchsales))->first();

            if ($sales) {

                $this->searchsales = $sales->name;
                $this->selectedSales = $sales;
                $this->form->sales = $sales->code;

                $this->dispatch('selectedSalesChanged', $this->selectedSales);
                $this->dispatch('selectedSaleschangedAfterModal', $this->selectedSales)->to(Table::class);

                $this->dispatch('selectedSalesChanged', $this->selectedSales)->to(CashierInvoice::class);
                $this->dispatch('selectedSalesChangedAfterModal', $this->selectedSales)->to(Table::class);

                $this->isDropdownsalesVisible = false; // Close the dropdown
                $this->dispatch('salesSelectedModal');

                $this->alert('info', 'Sales: ' . $sales->name, [
                    'position' => 'top',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
                $this->isSalesModalVisible = false;
                $this->dispatch('closeSalesModal', $this->isSalesModalVisible)->to(Table::class);
            } else {
                $this->alert('warning', 'Theres no sales name : ' . $this->searchsales, [
                    'position' => 'top',
                    'timer' => 3000,
                    'toast' => true,
                    'timerProgressBar' => true,
                ]);
            }
        }
    }

    public function skipSalesModal()
    {
        $this->modalOpen = true;
        $this->dispatch('modalInvoiceOpenorClose', $this->modalOpen)->to(Transaction::class);

        $this->dispatch('skipSales')->to(CashierInvoice::class);
        $this->dispatch('openModalInvoice');
    }

    public function selectSalesModal($index)
    {
        $this->selectedIndexSales = $index;
        $this->selectedCodeSales = $this->sales[$index]->code;

        $sales = Sales::where('code', $this->selectedCodeSales)->first();

        if ($sales) {

            $this->searchsales = $sales->name;
            $this->selectedSales = $sales;
            $this->form->sales = $sales->code;

            $this->dispatch('selectedSalesChanged', $this->selectedSales);
            $this->dispatch('selectedSalesChangedAfterModal', $this->selectedSales)->to(Table::class);
            $this->dispatch('selectedSalesChanged', $this->selectedSales)->to(CashierInvoice::class);
            $this->isDropdownsalesVisible = false; // Close the dropdown
            // Clear selectedCodeSales and selectedIndexSales
            $this->selectedCodeSales = null;
            $this->selectedIndexSales = null;
            $this->alert('info', 'Sales: ' . $sales->name, [
                'position' => 'top',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
        $this->isSalesModalVisible = false;
        $this->dispatch('closeSalesModalIndex', $this->isSalesModalVisible)->to(Table::class);
    }


    public function updatedSearch()
    {
        $this->selectedProduct = null; // Clear the selected product when the search field changes
        $this->products = [];
    }

    public function updatedSearchmember()
    {
        $this->isDropdownVisible = (strlen($this->searchmember) >= 1);
    }

    public function updatedSearchsales()
    {
        $this->selectedSales = null; // Clear the selected product when the search field changes
        $this->dispatch('selectedSalesChanged', $this->selectedSales)->to(Table::class);
        $this->dispatch('keepFocusSales');
        $this->isDropdownsalesVisible = (strlen($this->searchsales) >= 1);
    }


    public function clearSession()
    {
        if (session()->has('member')) {
            session()->forget('member');
            $carts = Cart::where('user_code', auth()->user()->code)->get();
            $user = Auth::user();
            $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
            $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();

            $pricelist = $getpricelist->code;

            if ($carts) {
                // First loop to update the 'price' and save the changes
                foreach ($carts as $cart) {
                    $cartCode = $cart->code;
                    $price = ItemPrice::where('company_code', auth()->user()->company_code)->where('item_code', $cartCode)->where('pricelist_code', $pricelist)->first();
                    $cart->price = $price->price; // Adjust the price calculation as needed
                    $cart->member_code = null;
                    $cart->save(); // Save the updated 'price' values
                }
                // Second loop to update the 'total_price' based on the updated 'price' values
                foreach ($carts as $cart) {
                    $cart->total_price = $cart->price * $cart->qty;
                    $cart->save(); // Save the updated 'total_price' values
                }
            } else {
                // Do nothing if there are no carts
            }
            $this->searchmember = '';
            $this->search = '';
            $this->selectedProduct = '';
            $this->dispatch('cart-created');
            $this->alert('warning', 'Member deleted', [
                'position' => 'top',
                'timer' => 3000,
                'toast' => true,
                'timerProgressBar' => true,
            ]);
        }
    }


    //check pack belum terpenuhi
    public function checkAvailablePacks($itemCode, $promoCode, $promoTipe)
    {
        $checkCartPacks = Cart::where('promo', $promoCode)
            ->where('promo_tipe', $promoTipe)
            ->where('user_code', auth()->user()->code)
            ->pluck('pack')
            ->toArray();

        $availablePacks = DB::table('Luv2_promo_item')
            ->where('company_code', auth()->user()->company_code)
            ->where('no', $promoCode)
            ->where('item_code', $itemCode)
            ->whereNotIn('pack', $checkCartPacks)
            ->pluck('pack')
            ->toArray();

        // ambil pack pertama yang tersedia
        // Sort the available packs in ascending order
        sort($availablePacks);

        // Get the first available pack
        $firstAvailablePack = reset($availablePacks);

        return $firstAvailablePack;
    }


    public function createInvoice()
    {
        $this->dispatch('createInvoice');
    }

    public function closeSalesModal()
    {
        $this->isSalesModalVisible = false;
    }

    #[On('salesModal')]
    public function openSalesModal($isSalesModalVisible)
    {
        $this->isSalesModalVisible = $isSalesModalVisible;
    }


    #[On('selectedSalesafterInvoice')]
    public function updatedSelectedSales()
    {
        $this->isSalesModalVisible = false;
        $this->selectedSales = null;
        $this->searchsales = '';
    }

    #[On('printernotfound')]
    public function printernotfound()
    {
        $this->dispatch('printernotfound');
    }

    #[On('updatePrice')]
    public function updatedSubtotal() {}
    #[On('focusInput')]
    public function focusInput()
    {
        $this->dispatch('focusInput');
    }

    #[On('modalInvoiceOpenorClose')]
    public function modalInvoiceOpenorClose($data)
    {
        $this->modalOpen = $data;
        $this->dispatch('modalInvoiceOpenorClose', $this->modalOpen)->to(CashierInvoice::class);
    }

    public function saveDiscount()
    {
        $this->dispatch('savetheDiscount')->to(SelectDiscount::class);
    }

    #[On('updateSearch')]
    public function updatedAfterSandbox()
    {
        $this->search = '';
        $this->selectedProduct = null; // Clear the selected product when the search field changes
        $this->products = [];
    }

    #[On('toPrintComponent')]
    public function toPrintComponent($no)
    {
        $this->dispatch('toPrint', $no);
    }

    public function mount()
    {
        $company = DB::table('Luv2_company')->where('code', auth()->user()->company_code)->first();
        $this->isEnabledMinusTransaction = $company->minus_transaction == 'Y' ? true : false;

        if (session()->has('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id) || session()->has('Promo-GWP-ValueCheapestFulfil' . auth()->user()->id) || session()->has('Promo-Voucher-ValueFulfil' . auth()->user()->id)) {
            $this->checkCartValueafterDelete();
        }
        if (session()->has('PromoBundlingFulfill' . auth()->user()->id)) {
            $this->checkCartValueafterDeleteBundling();
        }
    }

    private function handleProductError($type)
    {
        switch ($type) {
            case 'notfound':
                $this->dispatch('itemnotfound');
                break;
            case 'nonactive':
                $this->dispatch('itemnonactive');
                break;
            case 'nonsales':
                $this->dispatch('itemnonsales');
                break;
            case 'outofstock':
                $this->dispatch('outofstock');
                break;
        }
        $this->reset(['search', 'selectedProduct', 'price', 'products']);
    }

    #[On('openModalProcessDiscount')]
    public function openTheModalProcess()
    {
        $this->dispatch('openModalProcessDiscountBlade');
        $this->products = [];
        $this->reset(['search', 'selectedProduct', 'price']);
    }

    #[On('openModalProcessDiscBundle')]
    public function openTheModalProcDiscBundle()
    {
        $this->dispatch('openModalProcessDiscBundleBlade');
        $this->products = [];
        $this->reset(['search', 'selectedProduct', 'price']);
    }

    #[On('removeSuggestion')]
    public function removeSuggestion()
    {
        $this->isSuggestion = false;
    }

    #[On('afterBackToTransaction')]
    public function afterBackToTransaction($itemCode)
    {
        $currentDate = Carbon::now()->toDateString();
        $dataDisc = DB::table('Luv2_promo')
            ->where('deleted', 'N')
            ->join('Luv2_promo_item', 'Luv2_promo.no', '=', 'Luv2_promo_item.no')
            ->whereDate('from_date', '<=', $currentDate)
            ->whereDate('to_date', '>=', $currentDate)
            ->where('item_code', $itemCode)
            ->where('Luv2_promo.company_code', auth()->user()->company_code)
            ->select(
                'Luv2_promo.no',
                'Luv2_promo.name',
                'Luv2_promo.from_date',
                'Luv2_promo.to_date',
                'Luv2_promo.voucher_from_date',
                'Luv2_promo.voucher_to_date',
                'Luv2_promo.tipe',
                'Luv2_promo.benefit',
                'Luv2_promo.disc',
                'Luv2_promo.disc_price',
                'Luv2_promo_item.company_code',
                'Luv2_promo_item.item_code',
                'Luv2_promo_item.pack',
                'Luv2_promo_item.disc',
                'Luv2_promo_item.disc_price',
            )
            ->groupBy('Luv2_promo.no', 'Luv2_promo.name', 'Luv2_promo.from_date', 'Luv2_promo.to_date', 'Luv2_promo.voucher_from_date', 'Luv2_promo.voucher_to_date', 'Luv2_promo.tipe', 'Luv2_promo.benefit', 'Luv2_promo.benefit', 'Luv2_promo.disc', 'Luv2_promo.disc_price', 'Luv2_promo_item.company_code', 'Luv2_promo_item.item_code', 'Luv2_promo_item.pack', 'Luv2_promo_item.disc', 'Luv2_promo_item.disc_price',)
            ->get();
        $this->dispatch('selectDiscount', $dataDisc)->to(SelectDiscount::class);
    }
}
