<?php

namespace App\Livewire\Cashier;

use App\Livewire\Forms\CartForm;
use App\Models\Auths;
use App\Models\Cart;
use App\Models\Item;
use App\Models\ItemPrice;
use App\Models\Settings;
use App\Models\Warehouse;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Attributes\On;
use Illuminate\Support\Str;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class ProcessDiscBundling extends Component
{
    use LivewireAlert;

    public $name = '';
    public $no = '';
    public $carts = [];
    public $products = [];
    public $searchitem = '';
    public $selectedProduct;
    public $refreshKey = 0;
    public $isEnter = false;
    public $selectedCode;
    public $selectedIndex;
    public $increment = 1;
    public $fulfilled = false;

    public $isSuggestion = false;
    public $suggestion = [];
    public $suggestionName;

    public $promoExclude = false;


    public CartForm $form;

    public function render()
    {
        $results = [];

        $user = Auth::user();
        $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
        $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();
        $pricelist = $getpricelist->code;
        $no = $this->no['no'] ?? '';
        $type = $this->no['tipe'] ?? '';

        if ($type != 7) {
            if (strlen($this->searchitem) >= 1) {
                $existingPacks = array_column($this->carts, 'pack');

                $results = DB::table('Luv2_item')
                    ->where('Luv2_item.company_code', $user->company_code)
                    ->leftJoin('Luv2_item_pricelist', function ($join) use ($pricelist) {
                        $join->on('Luv2_item.code', '=', 'Luv2_item_pricelist.item_code')
                            ->where('Luv2_item_pricelist.pricelist_code', '=', $pricelist);
                    })
                    ->select('Luv2_item.*', 'Luv2_item_pricelist.price')
                    ->where(function ($query) {
                        $query->where('Luv2_item.code', 'ILIKE', '%' . $this->searchitem . '%')
                            ->orWhere('Luv2_item.barcode', 'LIKE', '%' . $this->searchitem . '%')
                            ->orWhere('Luv2_item.name', 'ILIKE', '%' . $this->searchitem . '%');
                    })
                    ->whereExists(function ($query) use ($no, $existingPacks) {
                        $query->select(DB::raw(1))
                            ->from('Luv2_promo_item')
                            ->whereColumn('Luv2_promo_item.item_code', 'Luv2_item.code')
                            ->where('Luv2_promo_item.no', '=', $no)
                            ->whereNotIn('Luv2_promo_item.pack', $existingPacks);
                    })
                    ->limit(10)
                    ->get();

                $this->products = $results;
            }
        } else {
            if (strlen($this->searchitem) >= 1) {
                $results = DB::table('Luv2_item')
                    ->where('Luv2_item.company_code', $user->company_code)
                    ->leftJoin('Luv2_item_pricelist', function ($join) use ($pricelist) {
                        $join->on('Luv2_item.code', '=', 'Luv2_item_pricelist.item_code')
                            ->where('Luv2_item_pricelist.pricelist_code', '=', $pricelist);
                    })
                    ->select('Luv2_item.*', 'Luv2_item_pricelist.price')
                    ->where(function ($query) {
                        $query->where('Luv2_item.code', 'ILIKE', '%' . $this->searchitem . '%')
                            ->orWhere('Luv2_item.barcode', 'LIKE', '%' . $this->searchitem . '%')
                            ->orWhere('Luv2_item.name', 'ILIKE', '%' . $this->searchitem . '%');
                    })
                    ->whereExists(function ($query) use ($no) {
                        $query->select(DB::raw(1))
                            ->from('Luv2_promo_item')
                            ->whereColumn('Luv2_promo_item.item_code', 'Luv2_item.code')
                            ->where('Luv2_promo_item.no', '=', $no);
                    })
                    ->limit(10)
                    ->get();

                $this->products = $results;
            }
        }
        return view('livewire.cashier.process-disc-bundling');
    }

    #[On('toModalProcessDiscBundleWithDisc')]
    public function openTheModalwithDisc($no, $carts)
    {
        $this->no = $no;
        $this->name = $no['name'];
        $price = (float) $carts['itemprice'];
        $qty = $carts['itemqty'];
        
        // If price is 0, get price from database
        if ($price == 0) {
            $user = Auth::user();
            $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
            $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();
            $pricelist = $getpricelist->code;
            
            $itemPrice = DB::table('Luv2_item_pricelist')
                ->where('company_code', $user->company_code)
                ->where('item_code', $this->no['item_code'])
                ->where('pricelist_code', $pricelist)
                ->first();
                
            $price = $itemPrice ? (float) $itemPrice->price : 0;
        }
        $carttodelete = Cart::where('code', $this->no['item_code'])
            ->where('user_code', auth()->user()->code)
            ->orderBy('created_at', 'desc')
            ->first();
        if($carttodelete){
            $carts = $carttodelete;
            $carttodelete->delete();
        }
        $item = DB::table('Luv2_item')->where('company_code', auth()->user()->company_code)->where('code', $this->no['item_code'])->first();
        $promoExclude = session('PromoExclude' . auth()->user()->id, []);
        if (in_array($this->no['no'], $promoExclude)) {
            $this->carts = [
                [
                    "id" => 1,
                    "itemname" => $item->name,
                    "itemprice" => $price,
                    "itemcode" => $item->code,
                    "itemqty" => $qty,
                    "discount" => $carts['discount'],
                    "promo" => 0,
                    "promotipe" => 0,
                    "pack" => 0,
                    "benefit" => 0,
                    "nprice" => $carts['nprice'],
                ]
            ];
        } else {
            $this->carts = [
                [
                    "id" => 1,
                    "itemname" => $item->name,
                    "itemprice" => $price,
                    "itemcode" => $item->code,
                    "itemqty" => $qty,
                    "discount" => $carts['discount'],
                    "promo" => $this->no['no'],
                    "promotipe" => $this->no['tipe'],
                    "pack" => $this->no['pack'],
                    "benefit" => $this->no['benefit'],
                    "nprice" => $carts['nprice'],
                ]
            ];
        }


        $this->dispatch('openModalProcessDiscBundle')->to(Transaction::class);

    }

    #[On('toModalProcessDiscBundle')]
    public function openTheModal($no)
    {
        $this->no = $no;
        $this->name = $no['name'];
        $promoExclude = session('PromoExclude' . auth()->user()->id, []);

        $carttodelete = Cart::where('code', $this->no['item_code'])
            ->where('user_code', auth()->user()->code)
            ->orderBy('created_at', 'desc')
            ->first();
            
        if($carttodelete){
            $carts = $carttodelete;
            $carttodelete->delete();
        } else {
            // Create a cart-like object from promo data when no cart exists
            $carts = (object) [
                'code' => $no['item_code'],
                'name' => $no['item_name'] ?? '',
                'price' => $no['item_price'] ?? 0,
                'nprice' => $no['item_price'] ?? 0,
                'discount' => 0,
                'qty' => 1,
                'total_price' => $no['item_price'] ?? 0,
            ];
        }
        
        $item = DB::table('Luv2_item')->where('company_code', auth()->user()->company_code)->where('code', $this->no['item_code'])->first();

        if (in_array($this->no['no'], $promoExclude)) {
            $this->carts = [
                [
                    "id" => 1,
                    "itemname" => $item->name,
                    "itemprice" => $carts->nprice,
                    "itemcode" => $carts->code,
                    "itemqty" => 1,
                    "discount" => $carts->discount,
                    "promo" => 0,
                    "promotipe" => 0,
                    "pack" => 0,
                    "benefit" => 0,
                    "nprice" => $carts->nprice,
                ]
            ];
            
            // Only save if it's an actual cart object
            if (isset($carts->save)) {
                $carts->qty = 1;
                $carts->total_price = $carts->price;
                $carts->save();
            }
            $this->promoExclude = true;
        } else {
            $this->carts = [
                [
                    "id" => 1,
                    "itemname" => $carts->name,
                    "itemprice" => $carts->price,
                    "itemcode" => $carts->code,
                    "itemqty" => 1,
                    "discount" => $carts->discount,
                    "promo" => $this->no['no'],
                    "promotipe" => $this->no['tipe'],
                    "pack" => $this->no['pack'],
                    "benefit" => $this->no['benefit'],
                    "nprice" => $carts->nprice,
                ]
            ];
            
            // Only delete if it's an actual cart object
            if (isset($carts->delete)) {
                $carts->delete();
            }
        }

        $this->dispatch('openModalProcessDiscBundle')->to(Transaction::class);
    }

    public function updatedSearchitem()
    {
        $this->selectedProduct = null;
        $this->products = [];
        $this->refreshKey++;
    }

    public function selectProductByName()
    {
        $product = Item::where('barcode', $this->searchitem)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();

        if ($product) {
            $this->toProduct($product);
            // $this->dispatch('toIsEnter');
        } else {
            $this->noProduct();
        }
    }

    #[On('toIsEnter')]
    public function trueIsEnter()
    {
        $this->isEnter = true;
        $this->dispatch('toSave');
    }

    public function byClick($itemCode)
    {

        $product = DB::table('Luv2_item')->where('code', $itemCode)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();
        if ($product) {
            $this->toProduct($product);
        } else {
            $this->noProduct();
        }
    }
    public function selectProduct($index)
    {
        $this->selectedIndex = $index;
        $this->selectedCode = $this->products[$index]->code;

        $product = DB::table('Luv2_item')
            ->where('code', $this->selectedCode)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();

        if ($product) {
            $this->selectedProduct = $product;
            $this->toProduct($product);
        }

        // Clear selectedCode and selectedIndex
        $this->selectedCode = null;
        $this->selectedIndex = null;
        $this->isEnter = true;
        // $this->dispatch('toSave');
    }

    public function noProduct()
    {
        $productcheck = Item::where('barcode', $this->searchitem)
            ->first();
        if ($productcheck) {
            if ($productcheck->active == 'N') {
                $this->alert('warning', 'Item Is Not Active', [
                    'position' => 'top-center',
                    'timer' => 3000,
                    'toast' => true,
                    'text' => 'Please enter active item !',
                    'width' => '800',
                    'timerProgressBar' => true,
                ]);
            } else {
                $this->alert('warning', 'Item Is Non Sales', [
                    'position' => 'top-center',
                    'timer' => 3000,
                    'toast' => true,
                    'text' => 'Please enter sales item !',
                    'width' => '800',
                    'timerProgressBar' => true,
                ]);
            }
        } else {
            $this->alert('warning', 'Item Not Found', [
                'position' => 'top-center',
                'timer' => 3000,
                'toast' => true,
                'text' => 'Please enter valid item barcode !',
                'width' => '800',
                'timerProgressBar' => true,
            ]);
        }
    }

    public function toProduct($product)
    {
        $user = Auth::user();
        $whs = Warehouse::where('company_code', $user->company_code)->where('code', auth()->user()->whs_code)->first();
        $getpricelist = DB::table('Luv2_pricelist')->where('company_code', $whs->company_code)->first();
        $pricelist = $getpricelist->code;

        $this->selectedProduct = $product;
        $itemCode = $product->code;
        $currentDate = Carbon::now()->toDateString();

        $prices = ItemPrice::where('company_code', $user->company_code)->where('item_code', $itemCode)->where('pricelist_code', $pricelist)->first();
        $dataDisc = DB::table('Luv2_promo')
            ->where('Luv2_promo.company_code', $user->company_code)
            ->where('Luv2_promo.deleted', 'N')
            ->where('Luv2_promo.no', $this->no)
            ->join('Luv2_promo_item', 'Luv2_promo.no', '=', 'Luv2_promo_item.no')
            ->whereDate('Luv2_promo.from_date', '<=', $currentDate)
            ->whereDate('Luv2_promo.to_date', '>=', $currentDate)
            ->where('Luv2_promo_item.item_code', $itemCode)
            ->select(
                'Luv2_promo.no',
                'Luv2_promo.name',
                'Luv2_promo.from_date',
                'Luv2_promo.to_date',
                'Luv2_promo.voucher_from_date',
                'Luv2_promo.voucher_to_date',
                'Luv2_promo.tipe',
                'Luv2_promo.benefit',
                'Luv2_promo.disc',
                'Luv2_promo.disc_price',
                'Luv2_promo_item.company_code',
                'Luv2_promo_item.item_code',
                'Luv2_promo_item.pack',
                'Luv2_promo_item.disc',
                'Luv2_promo_item.disc_price',
            )
            ->groupBy('Luv2_promo.no', 'Luv2_promo.name', 'Luv2_promo.from_date', 'Luv2_promo.to_date', 'Luv2_promo.voucher_from_date', 'Luv2_promo.voucher_to_date', 'Luv2_promo.tipe', 'Luv2_promo.benefit', 'Luv2_promo.benefit', 'Luv2_promo.disc', 'Luv2_promo.disc_price', 'Luv2_promo_item.company_code', 'Luv2_promo_item.item_code', 'Luv2_promo_item.pack', 'Luv2_promo_item.disc', 'Luv2_promo_item.disc_price', )
            ->get();
        $existingCartIndex = null;
        foreach ($this->carts as $index => $cart) {
            if ($cart['itemcode'] == $itemCode) {
                $existingCartIndex = $index;
                break;
            }
        }

        // if ($existingCartIndex !== null) {
        //     $this->updateItemQty($existingCartIndex, $this->carts[$existingCartIndex]['itemqty'] + 1);
        // } else {
        $item = $this->itemResource($product, $prices, $dataDisc, $pricelist);

        $this->addToCarts($item);

        // }

        if (session()->has('Promo-GWP-ValueFreeItem' . auth()->user()->id) || session()->has('Promo-GWP-ValueCheapest' . auth()->user()->id) || session()->has('Promo-Voucher-Value' . auth()->user()->id)) {
            $this->dispatch('checkCartValue');
        } else {
            // $this->dispatch('toActiveNcheckGWPValue');
        }

        $this->searchitem = '';
    }

    public function addToCarts($item)
    {
        $existingCart = array_filter($this->carts, function ($cartItem) use ($item) {
            return $cartItem['itemcode'] == $item['itemcode'] && $cartItem['promotipe'] == $item['promotipe'];
        });

        $existingCart = reset($existingCart);
        if (!empty($existingCart)) {
            if ($existingCart['promotipe'] == 3) {
                $checkcart = array_filter($this->carts, function ($cartItem) use ($item) {
                    return $cartItem['itemcode'] == $item['itemcode'] &&
                        $cartItem['promo'] == $item['promo'] &&
                        $cartItem['promotipe'] == 3;
                });

                $checkcart = reset($checkcart);

                if ($checkcart) {
                    $firstAvailablePack = $this->checkAvailablePacks($item['itemcode'], $item['promo'], $item['promotipe']);
                    if ($firstAvailablePack) {

                        $item['pack'] = $firstAvailablePack;
                    }
                }
            } elseif ($existingCart['promotipe'] == 4) {
                $checkcart = array_filter($this->carts, function ($cartItem) use ($item) {
                    return $cartItem['itemcode'] == $item['itemcode'] &&
                        $cartItem['promo'] == $item['promo'] &&
                        $cartItem['promotipe'] == 4;
                });

                $checkcart = reset($checkcart);
                if ($checkcart) {
                    $firstAvailablePack = $this->checkAvailablePacks($item['itemcode'], $item['promo'], $item['promotipe']);
                    if ($firstAvailablePack) {
                        $item['pack'] = $firstAvailablePack;
                    }
                }
            } elseif ($existingCart['promotipe'] == 7) {
                $checkcart = array_filter($this->carts, function ($cartItem) use ($item) {
                    return $cartItem['itemcode'] == $item['itemcode'] &&
                        $cartItem['promo'] == $item['promo'] &&
                        $cartItem['promotipe'] == 7;
                });
            }
        } else {
            if ($this->no['tipe'] == 7) {
                $item['promotipe'] == 7;
            } else {
                $firstAvailablePack = $this->checkAvailablePacks($item['itemcode'], $item['promo'], $item['promotipe']);
                if ($firstAvailablePack) {
                    $item['pack'] = $firstAvailablePack;
                }
            }
        }
        // if ($this->discountMoreThanOne) {
        // } else {
        $this->carts[] = $item;
        // }
        if ($item['promo'] != 0) {
            $this->updatePriceBundle($item['promo']);
        } else {
        }
    }
    public function updatePriceBundle($nopromo)
    {
        $user = Auth::user();
        // Get promo details
        $promo = DB::table('Luv2_promo')->where('company_code', $user->company_code)->where('no', $nopromo)->first();

        if (!$promo) {
            return; // If promo doesn't exist, exit the function
        }

        // Filter cart items based on promo
        $cart = array_filter($this->carts, function ($cartItem) use ($nopromo) {
            return $cartItem['promo'] == $nopromo;
        });

        $cart = array_values($cart); // Re-index array
        $this->fulfilled = true;

        // Check if promo is an unlimited bundle
        if ($promo->tipe == 7 && $promo->benefit == 1) {
            $checkbundle = DB::table('Luv2_promo_bundling_qty')
                ->where('company_code', $user->company_code)
                ->where('no', $promo->no)
                ->orderBy('qty', 'asc')
                ->first();

            if ($checkbundle && count($cart) >= $checkbundle->qty) {
                // Bundle fulfilled
            } else {
                $this->fulfilled = false;
            }
        } else {
            // Non-unlimited bundles
            $syaratString = $promo->qty_pack;
            $syarat = intval($syaratString);
            $requiredPacks = range(1, $syarat);

            foreach ($requiredPacks as $requiredPack) {
                $packExistsInCart = false;

                foreach ($cart as $cartItem) {
                    if ($cartItem['pack'] == $requiredPack) {
                        $packExistsInCart = true;
                        break;
                    }
                }

                if (!$packExistsInCart) {
                    $this->fulfilled = false;
                    break;
                }
            }
        }
        if ($this->fulfilled) {
            $promo = DB::table('Luv2_promo')->where('company_code', $user->company_code)->where('no', $nopromo)->where('deleted', 'N')->first();

            if (!$promo) {
                return; // If promo is deleted or doesn't exist, exit the function
            }

            $cart = array_filter($this->carts, function ($cartItem) use ($nopromo) {
                return $cartItem['promo'] == $nopromo;
            });

            $cart = array_values($cart);
            $totalPrice = array_sum(array_column($cart, 'itemprice'));
            if ($promo->tipe == 7) {
                if ($promo->benefit == 1) {
                    $cartcount = count($cart);
                    $qtyDiscs = DB::table('Luv2_promo_bundling_qty')
                        ->where('company_code', $user->company_code)
                        ->where('no', $promo->no)
                        ->where('qty', '>=', $cartcount)
                        ->orderBy('qty', 'asc')
                        ->get();

                    $firstApplicableQty = $qtyDiscs->firstWhere('qty', '>=', $cartcount);

                    if ($firstApplicableQty) {
                        $benefitDisc = $firstApplicableQty->disc;
                        foreach ($cart as &$crt) {
                            if (!str_contains($crt['itemname'], '( Pack Unlimited )')) {
                                $crt['itemname'] .= ' ( Pack Unlimited )';
                            }

                            $discountAmount = (floatval($benefitDisc) / 100) * floatval($crt['nprice']);
                            $crt['itemprice'] = floatval($crt['nprice']) - $discountAmount;
                            $crt['discount'] = $benefitDisc;
                            $crt['total_price'] = floatval($crt['itemprice']) * floatval($crt['itemqty']);

                        }
                    }
                }
            } else {
                foreach ($cart as &$crt) {
                    if ($promo->tipe == 3) { // Bundling
                        if ($promo->benefit == 1) { // Bundle discount
                            $benefitDisc = $promo->disc;
                            $discountAmount = (floatval($benefitDisc) / 100) * floatval($crt['itemprice']);
                            $crt['itemname'] .= ' ( Pack ' . $crt['pack'] . ' )';
                            $crt['itemprice'] = floatval($crt['itemprice']) - $discountAmount;
                            $crt['discount'] = $benefitDisc;
                            $crt['total_price'] = floatval($crt['itemprice']) * floatval($crt['itemqty']);
                        } elseif ($promo->benefit == 2) { // Bundle special price
                            $benefitPrice = $promo->disc_price;
                            $benefitDecimal = ($totalPrice - $benefitPrice) / $totalPrice;
                            $benefitDiscountforSpecialPrice = floatval($crt['itemprice']) * floatval($benefitDecimal);
                            $crt['itemname'] .= ' ( Pack ' . $crt['pack'] . ' )';
                            $crt['itemprice'] = floatval($crt['itemprice']) - $benefitDiscountforSpecialPrice;
                            $crt['discount'] = $benefitDiscountforSpecialPrice;
                            $crt['total_price'] = floatval($crt['itemprice']) * floatval($crt['itemqty']);
                        }

                        // Session management
                        session(['PromoBundlingFulfill' . auth()->user()->id => $promo->no]);
                    } elseif ($promo->tipe == 4) { // Free item or cheapest item
                        if ($promo->benefit == 1) {
                            $crt['itemname'] .= ' ( Pack ' . $crt['pack'] . ' )';
                            $this->fulfilled = true;
                            session(['Promo-GWP-FreeItem' . auth()->user()->id => $promo->no]);
                        } elseif ($promo->benefit == 2) {
                            $crt['itemname'] .= ' ( Pack ' . $crt['pack'] . ' )';
                            session(['Promo-GWP-CheapestItem' . auth()->user()->id => $promo->no]);
                            session(['PromoTingkat' . auth()->user()->id => $promo->no]);

                            $this->fulfilled = true;
                        } elseif ($promo->benefit == 3) {
                            session(['Promo-Voucher-QTY' . auth()->user()->id => $promo->no]);
                        }
                    }
                }
            }

            // Assuming `$this->carts` is an array of arrays or objects, update them accordingly
            foreach ($cart as $updatedCartItem) {
                foreach ($this->carts as &$originalCartItem) {
                    if ($originalCartItem['id'] == $updatedCartItem['id']) {
                        $originalCartItem = array_merge($originalCartItem, $updatedCartItem);
                        break;
                    }
                }
            }
        }
        // if (!$this->discountMoreThanOne) {
        // }
        $this->dispatch('cart-created');
    }

    private function itemResource($product, $prices, $dataDisc, $pricelist)
    {
        $user = Auth::user();
        $promoExclude = session('PromoExclude' . auth()->user()->id, []);

        $productCode = is_array($product) ? $product['code'] : $product->code;
        $productName = is_array($product) ? $product['name'] : $product->name;

        $this->increment++;

        $prices = ItemPrice::where('item_code', $productCode)
            ->where('company_code', $user->company_code)
            ->where('pricelist_code', $pricelist)
            ->first();

        $productPrice = $prices->price;
        $item = [
            'id' => $this->increment,
            'itemname' => $productName,
            'itemcode' => $productCode,
            'itemqty' => 1,
            'oldqty' => 1,
            'itemprice' => $productPrice,
            'nprice' => $productPrice,
            'promo' => 0,
            'promotipe' => 0,
            'pack' => 0,
            'discount' => 0,
            'benefit' => 'N',
        ];


        $arrayDataDisc = is_array($dataDisc) ? true : false;

        if ($arrayDataDisc) {
            $dataDiscEmpty = empty($dataDisc);
        } else {
            $dataDiscEmpty = $dataDisc->isEmpty();
        }

        // Handle discounts if any are provided
        if (!$dataDiscEmpty) {
            $dataDiscCollection = collect($dataDisc);
            $countDataDisc = $dataDiscCollection->pluck('no')->unique()->count();
            if ($countDataDisc > 1) {
                // $this->selectDiscount($product, $prices, $dataDisc, $pricelist);
            } else {
                if ($arrayDataDisc) {
                    $dataDiscNo = $dataDisc['no'];
                    $dataDiscDisc = $dataDisc['disc'];
                    $discountType = $dataDisc['tipe'];
                    $dataDiscDiscPrice = $dataDisc['disc_price'];
                    $dataDiscPack = $dataDisc['pack'];
                    $dataDiscBenefit = $dataDisc['benefit'];
                } else {
                    $dataDiscNo = $dataDisc[0]->no;
                    $dataDiscDisc = $dataDisc[0]->disc;
                    $discountType = $dataDisc[0]->tipe;
                    $dataDiscDiscPrice = $dataDisc[0]->disc_price;
                    $dataDiscPack = $dataDisc[0]->pack;
                    $dataDiscBenefit = $dataDisc[0]->benefit;
                }

                if ($discountType == 1) {
                    // Percentage discount
                    $discountPercentage = $dataDiscDisc;
                    $discountedPrice = $productPrice * (1 - $discountPercentage / 100);
                    $item['itemprice'] = $discountedPrice;
                    $item['promo'] = $dataDiscNo;
                    $item['promotipe'] = $discountType;
                    $item['discount'] = $productPrice - $discountedPrice;
                    $item['benefit'] = $dataDiscBenefit;
                } elseif ($discountType == 2) {
                    // Fixed discount price
                    $discountPrice = $dataDiscDiscPrice;
                    $item['itemprice'] = $discountPrice;
                    $item['promo'] = $dataDiscNo;
                    $item['promotipe'] = $discountType;
                    $item['discount'] = $productPrice - $discountPrice;
                    $item['benefit'] = $dataDiscBenefit;
                } elseif ($discountType == 3) {
                    $checkcart = collect($this->carts)->firstWhere('promo', $dataDiscNo);

                    if ($checkcart) {
                        $packInCarts = collect($this->carts)
                            ->where('promo', $dataDiscNo)
                            ->pluck('pack')
                            ->toArray();

                        $filteredDataDisc = $dataDisc->filter(function ($item) use ($packInCarts) {
                            return !in_array($item->pack, $packInCarts);
                        });

                        $pack = $filteredDataDisc->isNotEmpty() ? $filteredDataDisc->first()->pack : $dataDiscPack;
                    } else {
                        $pack = $dataDiscPack;
                    }

                    $item['promo'] = $dataDiscNo;
                    $item['promotipe'] = $discountType;
                    $item['pack'] = $pack;
                    $item['benefit'] = $dataDiscBenefit;
                } elseif ($discountType == 4) {
                    $item['promo'] = $dataDiscNo;
                    $item['promotipe'] = $discountType;
                    $item['discount'] = $dataDiscDisc;
                    $item['pack'] = $dataDiscPack;
                    $item['benefit'] = $dataDiscBenefit;
                } elseif ($discountType == 5) {
                    $item['promo'] = $dataDiscNo;
                    $item['promotipe'] = $discountType;
                    $item['discount'] = $dataDiscDisc;
                    $item['pack'] = $dataDiscPack;
                    $item['benefit'] = $dataDiscBenefit;
                } elseif ($discountType == 7) {
                    $item['promo'] = $dataDiscNo;
                    $item['promotipe'] = $discountType;
                    $item['discount'] = $dataDiscDisc;
                    $item['pack'] = $dataDiscPack;
                    $item['benefit'] = $dataDiscBenefit;
                }
            }
        } else {
        }

        if (session()->has('Promo-GWP-FreeItem' . auth()->user()->id) || session()->has('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id)) {
            $promoGWPFreeItem = session('Promo-GWP-FreeItem' . auth()->user()->id) ?? session('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id);
            $freeItems = DB::table('Luv2_promo_item_gwp')->where('no', $promoGWPFreeItem)->pluck('item_code')->toArray();
            if (in_array($item['itemcode'], $freeItems)) {
                session(['StatusPromo' => 'Diskon nih']);
                $dataDiscountGWP = DB::table('Luv2_promo_item_gwp')->where('company_code', $user->company_code)->where('no', $promoGWPFreeItem)->where('item_code', $item['itemcode'])->first();
                $product = DB::table('Luv2_item')->where('company_code', $user->company_code)->where('code', $item['itemcode'])->first();
                if ($dataDiscountGWP->disc_price == 0 && $dataDiscountGWP->disc == 0) {
                    $item['itemname'] = $product->name . ' ( FREE ITEM )';
                    $item['itemprice'] = 0;
                    $item['discount'] = -($item['nprice']);
                    $item['promo'] = 0;
                    $item['promotipe'] = 0;
                    $item['pack'] = 0;
                    $item['benefit'] = 'Free';

                    $this->dispatch('clearDiscount');
                } elseif ($dataDiscountGWP->disc == 0) {
                    $item['itemname'] = $product->name . ' ( Special Price )';
                    $item['itemprice'] = $dataDiscountGWP->disc_price;
                    $item['discount'] = $item['nprice'] - $dataDiscountGWP->disc_price;
                    $item['promo'] = 0;
                    $item['promotipe'] = 0;
                    $item['pack'] = 0;
                    $item['benefit'] = 'GWP Special Price';

                    $this->dispatch('clearDiscount');
                } else {
                    $discountPercentage = $dataDiscountGWP->disc; // Example discount percentage
                    $discountedPrice = $item['nprice'] * (1 - $discountPercentage / 100);
                    $item['itemname'] = $product->name . ' ( Disc Special Price )';
                    $item['itemprice'] = $discountedPrice;
                    $item['discount'] = $item['nprice'] - $discountedPrice;
                    $item['promo'] = 0;
                    $item['promotipe'] = 0;
                    $item['pack'] = 0;
                    $item['benefit'] = 'GWP Special Price';

                    $this->dispatch('clearDiscount');
                }
            } else {
                session(['StatusPromo' => 'Enggak Diskon nih']);

                // Do something if $this->form->itemcode does not exist in $freeItems
                // For example:
                // echo "Item code does not exist in free items array";
            }
        } elseif (session()->has('PromoBundlingFulfill' . auth()->user()->id)) {
            $item['promo'] = 0;
            $item['promotipe'] = 0;
            $item['pack'] = 0;
            // dd('kesini beda item dia', $this->form);
        } elseif (in_array($this->no['no'], $promoExclude)) {
            $item['promo'] = 0;
            $item['promotipe'] = 0;
            $item['pack'] = 0;
            $item['benefit'] = 0;
        }

        return $item;
    }

    public function checkAvailablePacks($itemCode, $promoCode, $promoTipe)
    {
        $user = Auth::user();
        $checkCartPacks = array_filter($this->carts, function ($cartItem) use ($promoCode, $promoTipe) {
            return $cartItem['promo'] == $promoCode && $cartItem['promotipe'] == $promoTipe;
        });

        $checkCartPacks = array_column($checkCartPacks, 'pack');

        $availablePacks = DB::table('Luv2_promo_item')
            ->where('company_code', $user->company_code)
            ->where('no', $promoCode)
            ->where('item_code', $itemCode)
            ->whereNotIn('pack', $checkCartPacks)
            ->pluck('pack')
            ->toArray();

        sort($availablePacks);

        $firstAvailablePack = reset($availablePacks);

        return $firstAvailablePack;
    }

    public function deleteFromCarts($index)
    {
        $itemdeleted = $this->carts[$index];
        if (isset($this->carts[$index])) {
            $cart = $this->carts[$index];
            unset($this->carts[$index]);
            $this->carts = array_values($this->carts);
            if ($itemdeleted['promo'] != 0) {
                $this->updatePriceBundleafterDelete($itemdeleted);
            }
            if (session()->has('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id) || session()->has('Promo-GWP-ValueCheapestFulfil' . auth()->user()->id) || session()->has('Promo-Voucher-ValueFulfil' . auth()->user()->id)) {
                $this->checkCartValueafterDelete();
            }
            if (session()->has('PromoBundlingFulfill' . auth()->user()->id)) {
                $this->checkCartValueafterDeleteBundling();
            }
        }
    }

    public function updatePriceBundleafterDelete($cart)
    {
        $user = Auth::user();
        $nopromo = $cart['promo'];

        $cartItems = array_filter($this->carts, function ($item) use ($nopromo) {
            return $item['promo'] == $nopromo;
        });

        $checkbundle = DB::table('Luv2_promo_item')->where('company_code', $user->company_code)->where('no', $nopromo)->get();
        $this->fulfilled = true;

        foreach ($checkbundle as $bundleItem) {
            if (!in_array($bundleItem->pack, array_column($cartItems, 'pack'))) {
                $this->fulfilled = false;
                break;
            }
        }

        if ($this->fulfilled) {
            $promo = DB::table('Luv2_promo')->where('company_code', $user->company_code)->where('no', $nopromo)->where('deleted', 'N')->first();

            if ($promo->tipe == 7) {
                if ($promo->benefit == 1) {
                    $cartcount = count($cartItems);

                    $qtyDiscs = DB::table('Luv2_promo_bundling_qty')->where('company_code', $user->company_code)->where('no', $promo->no)
                        ->orderBy('qty', 'desc')
                        ->get();

                    $firstApplicableQty = null;
                    foreach ($qtyDiscs as $qtyDisc) {
                        if ($cartcount >= $qtyDisc->qty) {
                            $firstApplicableQty = $qtyDisc->qty;
                            break;
                        }
                    }

                    if ($firstApplicableQty !== null) {
                        $applicableQtyDisc = $qtyDiscs->firstWhere('qty', $firstApplicableQty);

                        if ($applicableQtyDisc) {
                            $benefitDisc = $applicableQtyDisc->disc;
                            foreach ($cartItems as &$crt) {
                                if (!Str::contains($crt['itemname'], '( Pack Unlimited )')) {
                                    $crt['itemname'] .= ' ( Pack Unlimited )';
                                }
                                $discountAmount = (floatval($applicableQtyDisc->disc) / 100) * floatval($crt['nprice']);

                                $crt['price'] = floatval($crt['nprice']) - $discountAmount;
                                $crt['itemprice'] = floatval($crt['nprice']) - $discountAmount;
                                $crt['discount'] = $benefitDisc;
                                $crt['total_price'] = floatval($crt['price']) * floatval($crt['itemqty']);

                                // Update the cart item in $this->carts
                                $this->updateCartItem($crt);
                            }
                        }
                    } else {
                        foreach ($cartItems as &$crt) {
                            $item = Item::where('code', $crt['itemcode'])->first();
                            $crt['itemname'] = $item->name;
                            $crt['price'] = $crt['nprice'];
                            $crt['itemprice'] = $crt['nprice'];
                            $crt['total_price'] = floatval($crt['price']) * floatval($crt['itemqty']);

                            // Update the cart item in $this->carts
                            $this->updateCartItem($crt);
                        }
                    }
                }
            }
        } else {
            $promo = DB::table('Luv2_promo')->where('company_code', $user->company_code)->where('no', $nopromo)->where('deleted', 'N')->first();

            if ($promo->tipe == 7 && $promo->benefit == 1) {
                // Additional logic if needed
            } else {
                foreach ($cartItems as &$crt) {
                    $item = Item::where('code', $crt['itemcode'])->first();
                    $crt['itemname'] = $item->name;
                    $crt['itemprice'] = $crt['nprice'];
                    $crt['price'] = $crt['nprice'];
                    $crt['discount'] = 0;
                    $crt['total_price'] = floatval($crt['price']) * floatval($crt['itemqty']);

                    // Update the cart item in $this->carts
                    $this->updateCartItem($crt);
                }

                if ($promo->tipe == 4) {
                    if ($promo->benefit == 1) { // Free item
                        $freeItems = DB::table('Luv2_promo_item_gwp')->where('company_code', $user->company_code)->where('no', $promo->no)->pluck('item_code')->toArray();

                        foreach ($cartItems as &$crt) {
                            $item = Item::where('code', $crt['itemcode'])->first();
                            $crt['itemname'] = $item->name;
                            $crt['itemprice'] = $crt['nprice'];
                            $crt['price'] = $crt['nprice'];
                            $crt['discount'] = 0;
                            $crt['total_price'] = floatval($crt['price']) * floatval($crt['itemqty']);

                            // Update the cart item in $this->carts
                            $this->updateCartItem($crt);
                        }

                        $this->carts = array_filter($this->carts, function ($cart) use ($freeItems) {
                            return !in_array($cart['itemcode'], $freeItems) || $cart['benefit'] !== 'Free';
                        });

                        session()->forget('Promo-GWP-FreeItem' . auth()->user()->id);
                    } elseif ($promo->benefit == 2) { // Cheapest item
                        foreach ($cartItems as &$crt) {
                            $item = Item::where('code', $crt['itemcode'])->first();
                            $crt['itemname'] = $item->name;
                            $crt['itemprice'] = $crt['nprice'];
                            $crt['price'] = $crt['nprice'];
                            $crt['discount'] = 0;
                            $crt['total_price'] = floatval($crt['price']) * floatval($crt['itemqty']);

                            // Update the cart item in $this->carts
                            $this->updateCartItem($crt);
                        }

                        $this->carts = array_filter($this->carts, function ($cart) {
                            return $cart['benefit'] !== 'Cheapest';
                        });

                        session()->forget('Promo-GWP-CheapestItem' . auth()->user()->id);
                        session()->forget('PromoTingkat' . auth()->user()->id);
                        session()->forget('Promo-GWP-CheapestItemNONAKTIF' . auth()->user()->id);
                    } elseif ($promo->benefit == 3) {
                        session()->forget('Promo-Voucher-QTY' . auth()->user()->id);
                    }
                }
            }
        }

        $this->dispatch('cart-created');
    }

    public function checkCartValueafterDeleteBundling()
    {
        $user = Auth::user();
        if (session()->has('PromoBundlingFulfill' . auth()->user()->id)) {
            $session = session('PromoBundlingFulfill' . auth()->user()->id);
        }

        $promo = DB::table('Luv2_promo')->where('company_code', $user->company_code)->where('no', $session)->first();

        // Filter the cart items that match the promo and belong to the current user
        $cart = array_filter($this->carts, function ($cartItem) use ($session) {
            return $cartItem['promo'] == $session;
        });

        $cartCount = count($cart);

        if ($cartCount < $promo->qty_pack) {
            session()->forget('PromoBundlingFulfill' . auth()->user()->id);

            foreach ($cart as &$item) {
                $product = DB::table('Luv2_item')->where('company_code', $user->company_code)->where('code', $item['itemcode'])->first();
                $item['name'] = $product->name;
                $item['itemprice'] = $item['nprice'];
                $item['total_price'] = floatval($item['nprice']) * floatval($item['itemqty']);
            }
            // dd($cart);
            // Update $this->carts with the modified items
            $this->carts = array_map(function ($cartItem) use ($cart) {
                return in_array($cartItem, $cart) ? $cartItem : $cartItem;
            }, $this->carts);
        }
        // dd($this->carts);

        $this->dispatch('cart-created');
    }

    #[On('checkCartValueafterDelete')]
    public function checkCartValueafterDelete()
    {
        $user = Auth::user();
        if (session()->has('Promo-GWP-ValueFreeItem' . auth()->user()->id)) {
            $session = session('Promo-GWP-ValueFreeItem' . auth()->user()->id);
        } elseif (session()->has('Promo-GWP-ValueCheapest' . auth()->user()->id)) {
            $session = session('Promo-GWP-ValueCheapest' . auth()->user()->id);
        } elseif (session()->has('Promo-Voucher-Value' . auth()->user()->id)) {
            $session = session('Promo-Voucher-Value' . auth()->user()->id);
        }

        $promo = DB::table('Luv2_promo')->where('company_code', $user->company_code)->where('no', $session)->first();
        $cart = array_filter($this->carts, function ($cartItem) {
            return $cartItem['promo'] == 0 && $cartItem['benefit'] != 'GWP Special Price';
        });

        $cartTotalPrice = array_reduce($cart, function ($sum, $cartItem) {
            return $sum + (floatval($cartItem['itemqty']) * floatval($cartItem['itemprice']));
        }, 0);

        if ($cartTotalPrice < $promo->value_pack) {
            if ($promo->tipe == 5 && $promo->benefit == 1) {
                $freeItems = DB::table('Luv2_promo_item_gwp')->where('company_code', $user->company_code)->where('no', $promo->no)->pluck('item_code')->toArray();

                // Filter out free items from $this->carts
                $this->carts = array_filter($this->carts, function ($cartItem) use ($freeItems) {
                    return !in_array($cartItem['itemcode'], $freeItems) ||
                        !in_array($cartItem['benefit'], ['Free', 'GWP Special Price']);
                });

                session()->forget('Promo-GWP-ValueFreeItemFulfil' . auth()->user()->id);
            } elseif ($promo->tipe == 5 && $promo->benefit == 2) {
                // Filter out the cheapest items from $this->carts
                $this->carts = array_filter($this->carts, function ($cartItem) {
                    return $cartItem['benefit'] != 'Cheapest';
                });

                session()->forget('Promo-GWP-ValueCheapestFulfil' . auth()->user()->id);
            } elseif ($promo->tipe == 5 && $promo->benefit == 3) {
                session()->forget('Promo-Voucher-ValueFulfil' . auth()->user()->id);
            }
        }

        $this->dispatch('cart-created');
    }
    private function updateCartItem($updatedItem)
    {
        foreach ($this->carts as &$cart) {
            if ($cart['id'] === $updatedItem['id']) {
                $cart = $updatedItem;
                break;
            }
        }
    }

    public function backToTransaction()
    {
        // Reset promo values for all cart items
        foreach ($this->carts as &$cartItem) {
            $cartItem['promo'] = 0;
            $cartItem['promotipe'] = 0; 
            $cartItem['pack'] = 0;
        }

        // Store only the first item
        if (!empty($this->carts)) {
            $firstCartItem = $this->carts[0];
            
            $this->form->itemname = $firstCartItem['itemname'];
            $this->form->itemcode = $firstCartItem['itemcode'];
            $this->form->itemqty = 1;
            $this->form->itemprice = $firstCartItem['itemprice'];
            $this->form->nprice = $firstCartItem['nprice'];
            $this->form->promo = $firstCartItem['promo'];
            $this->form->promotipe = $firstCartItem['promotipe'];
            $this->form->pack = $firstCartItem['pack'];
            $this->form->discount = $firstCartItem['discount'];
            $this->form->benefit = $firstCartItem['benefit'];

            $cart = $this->form->store();
        }

            $this->reset(['searchitem', 'selectedProduct']);
            $this->dispatch('cart-created')->to(Table::class);
            $this->dispatch('updatePrice')->to(Transaction::class);

       $this->fulfilled = false;

        $this->products = [];
        $this->carts = [];
        $this->dispatch('clearsesthis');
        $this->dispatch('removeSuggestion')->to(Transaction::class);
        $this->dispatch('afterBackToTransaction', $firstCartItem['itemcode'])->to(Transaction::class);
    }

    public function save()
    {
        if(!$this->fulfilled) {
            foreach ($this->carts as &$cartItem) {
                $cartItem['promo'] = 0;
                $cartItem['promotipe'] = 0; 
                $cartItem['pack'] = 0;
            }
        }
        $user = Auth::user();

        foreach ($this->carts as $cartItem) {
            $this->form->itemname = $cartItem['itemname'];
            $this->form->itemcode = $cartItem['itemcode'];
            $this->form->itemqty = 1;
            $this->form->itemprice = $cartItem['itemprice'];
            $this->form->nprice = $cartItem['nprice'];
            $this->form->promo = $cartItem['promo'];
            $this->form->promotipe = $cartItem['promotipe'];
            $this->form->pack = $cartItem['pack'];
            $this->form->discount = $cartItem['discount'];
            $this->form->benefit = $cartItem['benefit'];

            $cart = $this->form->store();
        }

            $this->reset(['searchitem', 'selectedProduct']);
            $this->dispatch('cart-created')->to(Table::class);
            $this->dispatch('updatePrice')->to(Transaction::class);
            // $this->form->reset();
        


        if ($this->fulfilled) {
            // if($this->no['tipe'] != 7){
                $promoExclude = session('PromoExclude' . auth()->user()->id, []);
                $promoExclude[] = $this->no['no'];
                session(['PromoExclude' . auth()->user()->id => $promoExclude]);
            // }
        }

        $this->products = [];
        $this->carts = [];
        $this->dispatch('clearsesthis');
        $this->dispatch('removeSuggestion')->to(Transaction::class);
    }

    #[On('clearsesthis')]
    public function clearses()
    {
        session()->forget('PromoBundlingFulfill' . auth()->user()->id);
    }

    #[On('toAddProductSuggestions')]
    public function toaddproduct($product)
    {
        $objectProduct = (object) $product;

        $this->toProduct($objectProduct);
    }

    #[On('trueSuggestion')]
    public function trueSuggestion()
    {
        $this->isSuggestion = true;
    }

    #[On('trueSuggestionToProcDiscBundle')]
    public function trueSuggestionToProcDiscBundle()
    {
        $user = Auth::user();
        $this->isSuggestion = true;
        $nopromo = $this->no['no'] ?? 0;
        $promo_tipe = $this->no['tipe'] ?? 0;
        $promo = DB::table('Luv2_promo')->where('company_code', $user->company_code)->where('no', $nopromo)->get();

        // Use $this->carts instead of querying the Cart model
        $cart = collect($this->carts);
        $cartPacks = $cart->pluck('pack');

        $checkbundle = DB::table('Luv2_promo_item')
            ->join('Luv2_promo', 'Luv2_promo_item.no', '=', 'Luv2_promo.no')
            ->where('Luv2_promo.company_code', $user->company_code)
            ->where('Luv2_promo_item.no', $nopromo)
            ->where('Luv2_promo.tipe', $promo_tipe)
            ->whereNotIn('pack', $cartPacks)
            ->orderByRaw('RANDOM()') // Order by random
            ->get();

        $fulfilled = true;
        $unfulfilledItems = [];

        foreach ($checkbundle as $bundleItem) {
            if (!$cartPacks->contains($bundleItem->pack)) {
                $fulfilled = false;
                $unfulfilledItems[] = $bundleItem;
            }
        }

        $unfulfilledItemsCollect = collect($unfulfilledItems);
        $unfulfilledItemDetails = [];

        foreach ($unfulfilledItemsCollect->unique('pack') as $item) {
            $itemDetails = DB::table('Luv2_item')->where('company_code', $user->company_code)->where('code', $item->item_code)->first();

            // Check if the item details exist and the pack is not in the cart
            if ($itemDetails && !$cartPacks->contains($item->pack)) {
                $itemDetails->no = $item->no; // Add the 'no' field to the item details
                $itemDetails->pack = $item->pack;
                $unfulfilledItemDetails[] = $itemDetails;
            }
        }

        $this->suggestion = $unfulfilledItemDetails;


    }

    public function addSuggestion($itemcode)
    {
        $user = Auth::user();
        $product = DB::table('Luv2_item')->where('company_code', $user->company_code)->where('code', $itemcode)
            ->where('company_code', $user->company_code)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();
        $this->isEnter = true;
        $this->dispatch('toAddProductSuggestions', $product);
    }

    public function addSuggestionFirst($itemcode)
    {
        $user = Auth::user();
        $product = DB::table('Luv2_item')
            ->where('company_code', $user->company_code)
            ->where('code', $itemcode)
            ->where('sales', 'Y')
            ->where('active', 'Y')
            ->first();
        $this->isEnter = true;
        $this->dispatch('toAddProductSuggestions', $product);
    }

}
