<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;

class ValidateProCompany
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();
        if ($user) {
            $company = DB::table('Luv2_company')
                ->where('code', $user->company_code)
                ->where('plan', '!=', 'Basic')
                ->first();

            if ($company) {
                return $next($request); 
            } else {
                return redirect()->route('home'); 
            }
        }

        return redirect()->route('home'); 
    }
}
