<?php

namespace App\Http\Middleware;

use Carbon\Carbon;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;

class ValidateExpiredCompany
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();

        if ($user) {
            $company = DB::table('Luv2_company')
                ->where('code', $user->company_code)
                ->first();

            if ($company && Carbon::now()->greaterThan($company->expired_at)) {
                if ($request->is('paymentrenew') || $request->is('paymentable')) {
                    return $next($request); 
                } else {
                    return redirect()->route('paymentrenew');
                    // return response()->json(['message' => 'Access forbidden: your company subscription has expired.'], 403);
                }
                // if ($request->route()->getName() !== 'paymentrenew') {
                //     return redirect()->route('paymentrenew');
                // }
            }
        }

        return $next($request);
    }
}
