<?php

namespace App\Http\Controllers;

use App\Models\Member;
use App\Models\Settings;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class MemberController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $members = Member::all();
        $userId = Auth::id();
        $tutorials = DB::table('Luv2_tutorial')
            ->where('id_user', $userId)
            ->where('menu', 'Member')
            ->first();
        if ($tutorials && $tutorials->active === 'Y') {
            $istutorials = true;
        } else {
            $istutorials = false;
        }

        return view('member.index', compact('members', 'istutorials'));
    }

    public function thanks()
    {
        return view('welcome.thankyou');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function createoauth()
    {
        $user = Auth::user();

        return view('welcome.registermember', compact('user'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function storeoauth(Request $request)
    {
        $user = Auth::user();
        $setting = Settings::first();
        $prefix = $setting->member_prefix;
        $url = $setting->url;
        $urladmin = $setting->url_admin;
        $group_code = $setting->member_group;
        $currentYear = date('y');
        $currentMonth = date('m');
        $runningNumber = str_pad(mt_rand(1, 9999), 4, '0', STR_PAD_LEFT);
        $unique = $prefix . $currentYear . $currentMonth;

        $response = Http::get($urladmin . 'member/' . $setting->id_company . '/' . $unique);
        $jsonData = $response->json();
        if (isset($jsonData['error']) && $jsonData['error'] === 'Member not found') {
            $runningCode = '0001';
            $newrunningNumber = $runningCode;
        } else {
            $jsonData = $response->json();
            $cardcode = $jsonData['code'];
            $runningNumber = substr($cardcode, -4);
            $newNumericPart = str_pad((int) $runningNumber + 1, strlen($runningNumber), '0', STR_PAD_LEFT);
            $newrunningNumber = $newNumericPart;
        }
        $uniqueId = $prefix . $currentYear . $currentMonth . $newrunningNumber;


        $data = [
            'id_company' => $setting->id_company,
            'code' => $uniqueId,
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address,
            'hobby' => $request->hobby,
            'active' => 'Y',
        ];

        $url = $setting->url;
        try {
            $responsedata = Http::post($urladmin . 'member', $data);
            if ($responsedata->successful()) {
                if (isset($responseData['success']) && $responseData['success'] === 'Member berhasil dibuat') {
                    $newMember = Member::create([
                        'code' => $uniqueId,
                        'name' => $request->name,
                        'email' => $request->email,
                        'phone' => $request->phone,
                        'address' => $request->address,
                        'hobby' => $request->hobby,
                        'active' => 'Y',
                        'social_id' => $user->social_id,
                    ]);

                    if ($user->social_type == 'Twitter') {
                        $user->update([
                            'id_member' => $newMember->code,
                            'email' => $request->email,
                            'whs_code' => $setting->wh_code,
                        ]);

                        $newMember->update([
                            'email' => $request->email,
                        ]);
                    }
                    $user->update([
                        'id_member' => $newMember->code,
                        'whs_code' => $setting->wh_code,
                    ]);
                    Auth::logout();

                    $user->delete();

                    return redirect('/thankyou')->with('status', 'success');
                } else {
                    dd('error');
                }
            } else {
            }
        } catch (\Throwable $th) {
            //throw $th;
        }
    }

    public function create()
    {
    }

    public function storemandiri(Request $request)
    {
        $user = Auth::user();
        $currentYear = date('y');
        $currentMonth = date('m');

        $lastMember = DB::table('Luv2_member')
            ->where('company_code', $user->company_code)
            ->orderBy('code', 'desc')
            ->first();

        if ($lastMember) {
            $lastRunningNumber = (int) substr($lastMember->code, -4);
            $newRunningNumber = str_pad($lastRunningNumber + 1, 4, '0', STR_PAD_LEFT);
        } else {
            $newRunningNumber = '0001';
        }

        // Create the unique ID
        $uniqueId = 'PM' . $currentYear . $currentMonth . $newRunningNumber;

        $data = [
            'company_code' => $user->company_code,
            'code' => $uniqueId,
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address,
            'hobby' => $request->hobby,
            'active' => 'Y',
        ];

        $newMember = DB::table('Luv2_member')->insert([
            'company_code' => $user->company_code,
            'code' => $uniqueId,
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address,
            'hobby' => $request->hobby,
            'active' => 'Y',
            'created_at' => now(),
            'updated_at' => now()
        ]);

        return redirect()->back()->with('status', 'Member berhasil dibuat');
    }


    public function store(Request $request)
    {
        $user = Auth::user();
        $setting = Settings::first();
        $prefix = $setting->member_prefix;
        $url = $setting->url;
        $urladmin = $setting->url_admin;
        $group_code = $setting->member_group;
        $currentYear = date('y');
        $currentMonth = date('m');
        $runningNumber = str_pad(mt_rand(1, 9999), 4, '0', STR_PAD_LEFT);
        $unique = $prefix . $currentYear . $currentMonth;

        try {
            // Make a GET request to a reliable website
            $responseinternet = Http::get('https://www.google.com');

            // Check if the status code is 200 (OK)
            if ($responseinternet->status() === 200) {
                $internet = true;
            } else {
                // Internet connection is not available
                $internet = false;
            }
        } catch (\Exception $e) {
            // An exception occurred, indicating no conn connection
            $internet = false;
        }

        if ($internet) {
            $response = Http::get($urladmin . 'member/' . $setting->id_company . '/' . $unique);

            $jsonData = $response->json();

            if (isset($jsonData['error']) && $jsonData['error'] === 'Member not found') {
                $runningCode = '0001';
                $newrunningNumber = $runningCode;
            } else {
                $jsonData = $response->json();
                $cardcode = $jsonData['code'];
                $runningNumber = substr($cardcode, -4);
                $newNumericPart = str_pad((int) $runningNumber + 1, strlen($runningNumber), '0', STR_PAD_LEFT);
                $newrunningNumber = $newNumericPart;
            }
            $uniqueId = $prefix . $currentYear . $currentMonth . $newrunningNumber;


            $data = [
                'id_company' => $setting->id_company,
                'code' => $uniqueId,
                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'address' => $request->address,
                'hobby' => $request->hobby,
                'active' => 'Y',
            ];

            try {
                $responsedata = Http::post($urladmin . 'member', $data);
                // Check if the request was successful
                if ($responsedata->successful()) {
                    // Get the response body
                    $responseData = $responsedata->json();
                    // Check if the member was successfully created
                    if (isset($responseData['success']) && $responseData['success'] === 'Member berhasil dibuat') {
                        $newMember = Member::create([
                            'code' => $uniqueId,
                            'name' => $request->name,
                            'email' => $request->email,
                            'phone' => $request->phone,
                            'address' => $request->address,
                            'hobby' => $request->hobby,
                            'active' => 'Y', //Active
                        ]);
                        return redirect()->back()->with('status', 'Member berhasil dibuat');
                    } else {
                        return redirect()->back()->with('danger', 'Failed to create member. Please try again.');
                    }
                } else {
                    return redirect()->back()->with('danger', 'Failed to create member. Please try again.');
                }
            } catch (\Throwable $th) {
                return redirect()->back()->with('danger', 'Failed to create member. Please try again.');
            }
        } else {
            return redirect()->back()->with('danger', 'Failed to create member. Please check your connection.');

        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    public function updateStatus($id)
    {
        $currentTime = Carbon::now();
        $member = Member::findOrFail($id);

        if ($member->active === 'Y') {
            $member->update([
                'active' => 'N',
                'updated_at' => $currentTime,
            ]);

            return redirect('/member')->with('status', 'success')->with('message', 'Member status changed to Inactive');
        } else {
            $member->update([
                'active' => 'Y',
                'updated_at' => $currentTime,
            ]);

            return redirect('/member')->with('status', 'success')->with('message', 'Member status changed to Active');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
