<?php

use App\Models\Warehouse;
use Illuminate\Support\Facades\Auth;

if (!function_exists('userWarehouse')) {
    /**
     * Get the user's warehouse.
     *
     * @return mixed
     */
    function userWarehouse()
    {
        $user = Auth::user();

        // Check if user is authenticated and has a warehouse code
        if ($user && $user->whs_code) {
            $warehouse = Warehouse::where('code', $user->whs_code)->first();

            // Return warehouse name if found, otherwise return "-"
            return $warehouse ? $warehouse->name : '-';
        }

        // Return "-" if user is not authenticated or doesn't have a warehouse code
        return '-';
    }
}