<?php

namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class ReportLossSales implements FromView, ShouldAutoSize, WithEvents
{
    /**
     * @return \Illuminate\Support\Collection
     */
    private $data;
    private $dates;
    private $period;

    public function __construct($data, $dates, $period)
    {
        $this->data = $data;
        $this->dates = $dates;
        $this->period = $period;
    }

    public function view(): View
    {
        return view('export.report-loss-sales', [
            'data' => $this->data,
            'dates' => $this->dates,
            'period' => $this->period,
        ]);
    }

    protected function getColumnLetter($index)
    {
        return Coordinate::stringFromColumnIndex($index);
    }

    public function registerEvents(): array
    {
        return [

            AfterSheet::class => function (AfterSheet $event) {

                //$lastColumn = $event->sheet->getHighestColumn();
                $lastRow = $event->sheet->getHighestRow();
                //$range = 'A6:' . $lastColumn . $lastRow;
                //$rangeCode = 'A6:A' . $lastRow;
                //$rangeBarcode = 'B6:B' . $lastRow;
                //$rangeName = 'C6:C' . $lastRow;
                // $rangeQty = $this->getColumnLetter($qtyColumnIndex) . '5:' . $this->getColumnLetter($qtyColumnIndex) . $lastRow;
                // $rangeGross = $this->getColumnLetter($grossColumnIndex) . '5:' . $this->getColumnLetter($grossColumnIndex) . $lastRow;
                // $rangeDisc = $this->getColumnLetter($discColumnIndex) . '5:' . $this->getColumnLetter($discColumnIndex) . $lastRow;
                // $rangeNett = $this->getColumnLetter($nettColumnIndex) . '5:' . $this->getColumnLetter($nettColumnIndex) . $lastRow;
                // $rangeOnhand = $this->getColumnLetter($onhandColumnIndex) . '5:' . $this->getColumnLetter($onhandColumnIndex) . $lastRow;

                // $chunkSize = 100;
                // $collection = collect($this->datadetail);
                // $collection->chunk($chunkSize, function ($chunk) use ($event) {
                //     $startIndex = $chunk->first()->getKey();

                //     $chunk->each(function ($item, $key) use ($event, $startIndex) {
                //         $event->sheet->getCell('A' . ($key + $startIndex + 1 + 5))->setValueExplicit($item['code'], DataType::TYPE_STRING);
                //         $event->sheet->getCell('B' . ($key + $startIndex + 1 + 5))->setValueExplicit($item['barcode'], DataType::TYPE_STRING);
                //         $event->sheet->getCell('C' . ($key + $startIndex + 1 + 5))->setValueExplicit($item['name'], DataType::TYPE_STRING);
                //     });
                // });


                foreach ($this->data as $key => $item) {
                    // Mengatur tipe data kolom A sebagai teks
                    $event->sheet->getCell('B' . ($key + 6))->setValueExplicit($item->code, DataType::TYPE_STRING);
                    $event->sheet->getCell('C' . ($key + 6))->setValueExplicit($item->name, DataType::TYPE_STRING);
                    // $event->sheet->getCell('D' . ($key + 6))->setValueExplicit($item->name, DataType::TYPE_STRING);
                }

                // $event->sheet->getStyle($rangeQty)
                //     ->getNumberFormat()
                //     ->setFormatCode('#,##0');
                // $event->sheet->getStyle($rangeGross)
                //     ->getNumberFormat()
                //     ->setFormatCode('#,##0');
                // $event->sheet->getStyle($rangeDisc)
                //     ->getNumberFormat()
                //     ->setFormatCode('#,##0');
                // $event->sheet->getStyle($rangeNett)
                //     ->getNumberFormat()
                //     ->setFormatCode('#,##0');
                // $event->sheet->getStyle($rangeOnhand)
                //     ->getNumberFormat()
                //     ->setFormatCode('#,##0');
            }
        ];
    }
}
