<?php

namespace App\Exports;

use App\Models\Sales;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ExportReturn implements FromView, ShouldAutoSize, WithEvents
{
    /**
    * @return \Illuminate\Support\Collection
    */

    private $invoices;

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                $lastColumn = $event->sheet->getHighestColumn();
                $lastRow = $event->sheet->getHighestRow();
        
                $range = 'C3:' . $lastColumn . $lastRow;
                $rangei = 'I3:' . $lastColumn . $lastRow;
                $rangej = 'J3:' . $lastColumn . $lastRow;
                $rangek = 'K3:' . $lastColumn . $lastRow;
               
                $event->sheet->getStyle($rangei)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
                $event->sheet->getStyle($rangej)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
                $event->sheet->getStyle($rangek)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
                
                $event->sheet->getStyle($range)->applyFromArray([
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '#000000'],
                        ],
                    ],
                ]);
            }
        ];
    }

    public function __construct($invoices)
    {        
        $this->invoices = $invoices->map(function ($invoice) {
            $id_sales = $invoice->detailInvoices->first()->id_sales;
            $totalqty = $invoice->detailInvoices->where('qty', '>', 0)->sum('qty');
            $totalPrice = $invoice->detailInvoices->sum('total_price');
            $sales = Sales::find($id_sales);

            $invoice->sales_name = $sales->name;
            $invoice->qty = $totalqty;
            $invoice->subtotal = $totalPrice;

            if ($invoice->note) {
                $invoiceNote = json_decode($invoice->note, true);
                $cash = $invoiceNote['cash'];
                $transfer = $invoiceNote['transfer'];
                $invoice->cash = $cash;
                $invoice->transfer = $transfer;
            }
            if ($invoice->cashback !== 'N') {
                $cekvoucher = DB::table('Luv2_promo_voucher')->where('voucher', $invoice->cashback)->first();
                $vouchervalue = $cekvoucher->value;
                $invoice->value = $vouchervalue;
            }

            return $invoice; // Return the modified invoice object
        });
    }

    public function view():View
    {
        return view('export.tablereturn', [
            'invoices' => $this->invoices,
        ]);
    }

}
