<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;


class ExportMarginReport implements FromView, ShouldAutoSize, WithEvents, WithColumnFormatting
{
    private $invoices;

    public function __construct($data)
    {
        $this->invoices = $data;
    }

    public function view(): View
    {
        return view('export.tablemargin', [
            'invoices' => $this->invoices
        ]);
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $lastColumn = $event->sheet->getHighestColumn();
                $lastRow = $event->sheet->getHighestRow();
                $range = 'C3:' . $lastColumn . $lastRow;
                $rangel = 'N3:' . $lastColumn . $lastRow;
                $rangem = 'O3:' . $lastColumn . $lastRow;
                $rangen = 'P3:' . $lastColumn . $lastRow;
                $rangeo = 'Q3:' . $lastColumn . $lastRow;
                $rangek = 'M3:M' . $lastRow;

                $event->sheet->getStyle($range)->applyFromArray([
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            'color' => ['argb' => '#000000'],
                        ],
                    ],
                ]);

                // $event->sheet->getStyle($rangek)
                //     ->getNumberFormat()
                //     ->setFormatCode('@');
                $event->sheet->getStyle($rangel)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
                $event->sheet->getStyle($rangem)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
                $event->sheet->getStyle($rangen)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
                $event->sheet->getStyle($rangeo)
                    ->getNumberFormat()
                    ->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
            }
        ];
    }

    public function columnFormats(): array
    {
        return [];
    }
}
