<?php

namespace App\Console;

use App\Console\Commands\DeleteExpiredVerified;
use App\Console\Commands\SendExpirationReminderEmails;
use App\Console\Commands\SendInvoiceReport;
use App\Console\Commands\ResendYesterdayInvoiceReport;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected $commands = [
        SendExpirationReminderEmails::class,
        SendInvoiceReport::class,
        DeleteExpiredVerified::class,
        ResendYesterdayInvoiceReport::class
    ];

    protected function schedule(Schedule $schedule): void
    {
        $schedule->command('email:send-expiration-reminder')
            ->dailyAt('00:01')
            ->then(fn() => Log::info('email:send-expiration-reminder executed at ' . now()));

         $schedule->command('report:send-invoice')
            ->dailyAt('00:01')
            ->then(fn() => Log::info('report:send-invoice executed at ' . now()));

        $schedule->command('verified:delete-expired')
            ->dailyAt('00:01')
            ->then(fn() => Log::info('verified:delete-expired executed at ' . now()));
        
    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
