<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

class SendExpirationReminderEmails extends Command
{
    protected $signature = 'email:send-expiration-reminder';
    protected $description = 'Send an email reminder to companies two weeks before expiration date';

    public function handle()
    {
        $companies = DB::table('Luv2_company')
            ->whereDate('expired_at', '<=', Carbon::now()->addDays(14))
            ->whereDate('expired_at', '>=', Carbon::now())
            ->get();

        foreach ($companies as $company) {
            Mail::send('email.expiration', compact('company'), function ($message) use ($company) {
                $message->to($company->email)
                        ->subject('Subscription Expiration Reminder');
                        
            });
        }

    }
}
