"use client"

import { useState } from "react"

interface AgentCodeSectionProps {
  currency: string;
  showAgentSection: boolean;
  agentCode: string;
  setAgentCode: (code: string) => void;
  selectedAgent: any;
  setSelectedAgent: (agent: any) => void;
  fetchAgentByCode: (code: string) => void;
  loadingAgent: boolean;
  errors: any;
  validateField: (fieldName: string, value: any) => void;
}

export default function AgentCodeSection({
  currency,
  showAgentSection,
  agentCode,
  setAgentCode,
  selectedAgent,
  setSelectedAgent,
  fetchAgentByCode,
  loadingAgent,
  errors,
  validateField
}: AgentCodeSectionProps) {
  // Don't render if agent section is not shown
  if (!showAgentSection) {
    return null;
  }

  return (
    <>
      {/* Header */}
      <div className="bg-gradient-to-r from-slate-50 to-blue-50 border-l-4 border-blue-400 rounded-lg p-3 sm:p-4 md:p-5 mb-4 sm:mb-5 md:mb-6 shadow-sm">
        <div className="flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-3 md:gap-4">
          <div className="w-8 h-8 sm:w-10 sm:h-10 md:w-12 md:h-12 bg-gradient-to-br from-blue-500 to-sky-500 rounded-lg flex items-center justify-center flex-shrink-0 self-center sm:self-auto">
            <svg className="w-4 h-4 sm:w-5 sm:h-5 md:w-6 md:h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
            </svg>
          </div>
          <div className="text-center sm:text-left flex-1">
            <h2 className="text-base sm:text-lg md:text-xl lg:text-2xl font-semibold text-slate-800 leading-tight">Agent Code</h2>
            <p className="text-xs sm:text-sm md:text-base text-slate-600 mt-1 sm:mt-2 leading-relaxed">Enter your agent referral code for special rates</p>
          </div>
        </div>
      </div>

      <div className="bg-white rounded-xl shadow-sm border border-gray-100 p-4 sm:p-6">
        <div className="space-y-4 sm:space-y-6">  
          {/* Agent Code Input */}
            <div className="space-y-2 sm:space-y-3">
              <label className="block text-xs sm:text-sm font-medium text-gray-700">
                Enter Agent Code <span className="text-red-500">*</span>
              </label>
              <div className="flex flex-col sm:flex-row gap-2 sm:gap-3">
                <input
                  type="text"
                  value={agentCode}
                  onChange={(e) => {
                    const value = e.target.value.toUpperCase();
                    setAgentCode(value);
                    validateField('agentCode', value);
                  }}
                  placeholder="Enter agent code"
                  className={`flex-1 px-2 sm:px-3 md:px-4 py-2 sm:py-3 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-xs sm:text-sm transition-colors ${
                    errors.agentCode ? 'border-red-400 bg-red-50' : 'border-gray-300'
                  }`}
                />
              <button
                type="button"
                onClick={() => fetchAgentByCode(agentCode)}
                disabled={!agentCode.trim() || loadingAgent}
                className="w-full sm:w-auto px-3 sm:px-4 md:px-6 py-2 sm:py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700 disabled:bg-gray-300 disabled:cursor-not-allowed font-medium flex items-center justify-center gap-2 transition-colors text-xs sm:text-sm md:text-base"
              >
                {loadingAgent ? (
                  <>
                    <div className="w-3 h-3 sm:w-4 sm:h-4 border-2 border-white border-t-transparent rounded-full animate-spin"></div>
                    <span className="hidden sm:inline">Searching...</span>
                    <span className="sm:hidden">Search...</span>
                  </>
                ) : (
                  <>
                    <svg className="w-3 h-3 sm:w-4 sm:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                    </svg>
                    <span className="hidden sm:inline">Find</span>
                    <span className="sm:hidden">Find</span>
                  </>
                )}
              </button>
            </div>
            {errors.agentCode && <p className="mt-1 text-xs sm:text-sm text-red-600">{errors.agentCode}</p>}
          </div>

          {/* Selected Agent Info */}
          {selectedAgent && (
            <div className="bg-gradient-to-r from-blue-50 to-blue-50 border border-blue-200 rounded-xl p-4 sm:p-6 shadow-sm">
              <div className="flex flex-col sm:flex-row sm:items-center justify-between gap-3">
                <div className="flex items-center gap-3">
                  <div className="w-6 h-6 sm:w-8 sm:h-8 bg-blue-500 rounded-lg flex items-center justify-center">
                    <svg className="w-3 h-3 sm:w-4 sm:h-4 text-white" fill="currentColor" viewBox="0 0 20 20">
                      <path fillRule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clipRule="evenodd" />
                    </svg>
                  </div>
                  <h4 className="text-sm sm:text-base font-semibold text-gray-900">Agent Selected</h4>
                </div>
                <button
                  type="button"
                  onClick={() => {
                    setSelectedAgent(null);
                    setAgentCode('');
                  }}
                  className="flex items-center gap-1 text-red-600 text-xs sm:text-sm font-medium hover:text-red-800 hover:bg-red-50 px-2 py-1 rounded transition-colors self-start sm:self-auto"
                >
                  <svg className="w-3 h-3 sm:w-4 sm:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M6 18L18 6M6 6l12 12" />
                  </svg>
                  <span className="hidden sm:inline">Remove</span>
                  <span className="sm:hidden">Remove</span>
                </button>
              </div>
              <div className="grid grid-cols-1 lg:grid-cols-2 gap-3 sm:gap-4">
                <div className="space-y-2 sm:space-y-3">
                  <div className="flex flex-col sm:flex-row sm:justify-between sm:items-center py-2 border-b border-blue-100">
                    <span className="text-xs sm:text-sm text-gray-600 mb-1 sm:mb-0">Name</span>
                    <span className="text-xs sm:text-sm font-medium text-gray-900 break-words">{selectedAgent.name}</span>
                  </div>
                  <div className="flex flex-col sm:flex-row sm:justify-between sm:items-center py-2 border-b border-blue-100">
                    <span className="text-xs sm:text-sm text-gray-600 mb-1 sm:mb-0">Email</span>
                    <span className="text-xs sm:text-sm font-medium text-gray-900 break-words">{selectedAgent.email}</span>
                  </div>
                </div>
                <div className="space-y-2 sm:space-y-3">
                  <div className="flex flex-col sm:flex-row sm:justify-between sm:items-center py-2 border-b border-blue-100">
                    <span className="text-xs sm:text-sm text-gray-600 mb-1 sm:mb-0">Phone</span>
                    <span className="text-xs sm:text-sm font-medium text-gray-900">{selectedAgent.phone}</span>
                  </div>
                  <div className="flex flex-col sm:flex-row sm:justify-between sm:items-center py-2 border-b border-blue-100">
                    <span className="text-xs sm:text-sm text-gray-600 mb-1 sm:mb-0">Payment Methods</span>
                    <span className="text-xs sm:text-sm font-medium text-blue-600">
                      {selectedAgent.payment?.split('').map((p: string) => {
                        const labels = { B: 'Bank', C: 'Credit Card', O: 'Onsite', S: 'Saldo' };
                        return labels[p as keyof typeof labels];
                      }).join(', ')}
                    </span>
                  </div>
                </div>
              </div>
            </div>
          )}

          {/* Default Payment Info - HIDDEN */}
          {/* {!selectedAgent && (
            <div className="bg-gray-50 border border-gray-200 rounded-xl p-4 sm:p-6">
              <div className="flex items-center gap-3">
                <div className="w-6 h-6 sm:w-8 sm:h-8 bg-gray-500 rounded-lg flex items-center justify-center">
                  <svg className="w-3 h-3 sm:w-4 sm:h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z" />
                  </svg>
                </div>
                <div>
                  <span className="text-sm sm:text-base font-semibold text-gray-900">Default Payment Methods</span>
                  <div className="text-xs sm:text-sm text-gray-600 mt-1">Midtrans and PayPal payment gateways</div>
                </div>
              </div>
            </div>
          )} */}

          {/* Switch to Default Mode Option - HIDDEN */}
          {/* {selectedAgent && (
            <div className="bg-gradient-to-r from-orange-50 to-orange-50 border border-orange-200 rounded-xl p-3 sm:p-4">
              <div className="flex flex-col sm:flex-row sm:items-center justify-between gap-3">
                <div className="flex items-center gap-3">
                  <div className="w-5 h-5 sm:w-6 sm:h-6 bg-orange-500 rounded-full flex items-center justify-center">
                    <svg className="w-2.5 h-2.5 sm:w-3 sm:h-3 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                    </svg>
                  </div>
                  <div>
                    <span className="text-xs sm:text-sm font-semibold text-orange-800">Want to use default payment?</span>
                    <div className="text-xs text-orange-700 mt-1">Switch back to Midtrans/PayPal</div>
                  </div>
                </div>
                <button
                  type="button"
                  onClick={() => {
                    setSelectedAgent(null);
                    setAgentCode('');
                  }}
                  className="w-full sm:w-auto px-3 sm:px-4 py-2 bg-orange-600 text-white text-xs sm:text-sm font-medium rounded-lg hover:bg-orange-700 transition-colors"
                >
                  <span className="hidden sm:inline">Switch to Default</span>
                  <span className="sm:hidden">Switch</span>
                </button>
              </div>
            </div>
          )} */}
        </div>
      </div>
    </>
  );
}