# Production Setup Guide - Midtrans & PayPal

This guide explains how to switch from **Sandbox/Test mode** to **Live/Production mode** for Midtrans and PayPal payment integrations.

## 🔧 Configuration Overview

The application uses environment variables to control whether to use sandbox or production APIs. The configuration is already set up in `lib/config.ts` and will automatically switch based on your environment variables.

## 📝 Required Environment Variables

Add or update these environment variables in your `.env.local` file (or your deployment platform's environment variables):

### For Midtrans (Production)

```env
# Midtrans Production Configuration
NEXT_PUBLIC_MIDTRANS_CLIENT_KEY=your_live_client_key_here
NEXT_PUBLIC_MIDTRANS_SERVER_KEY=your_live_server_key_here
NEXT_PUBLIC_MIDTRANS_PRODUCTION=true
```

### For PayPal (Production)

```env
# PayPal Production Configuration
NEXT_PUBLIC_PAYPAL_CLIENT_ID=your_live_client_id_here
NEXT_PUBLIC_PAYPAL_PRODUCTION=true
```

## 🔑 How to Get Production Credentials

### Midtrans Production Credentials

1. **Login to Midtrans Dashboard**

   - Go to https://dashboard.midtrans.com/
   - Login with your Midtrans account

2. **Get Production Credentials**

   - Navigate to **Settings** → **Access Keys**
   - Copy your **Production Client Key** → Use for `NEXT_PUBLIC_MIDTRANS_CLIENT_KEY`
   - Copy your **Production Server Key** → Use for `NEXT_PUBLIC_MIDTRANS_SERVER_KEY`

3. **Important Notes:**
   - Production keys are different from sandbox keys
   - Server key should be kept secure (never expose in frontend code)
   - Make sure your account is approved for production use

### PayPal Production Credentials

1. **Login to PayPal Developer Dashboard**

   - Go to https://developer.paypal.com/
   - Login with your PayPal business account

2. **Create or Select Production App**

   - Go to **My Apps & Credentials**
   - If you don't have a production app, click **Create App**
   - Select **Live** environment (not Sandbox)
   - Copy your **Client ID** → Use for `NEXT_PUBLIC_PAYPAL_CLIENT_ID`

3. **Important Notes:**
   - Production Client ID is different from sandbox Client ID
   - Make sure your PayPal account is verified and approved for live payments
   - You may need to complete PayPal's business verification process

## ✅ Verification Steps

After setting up the environment variables:

### 1. Restart Your Development Server

```bash
# Stop your current server (Ctrl+C)
# Then restart
npm run dev
# or
yarn dev
```

### 2. Check Configuration in Browser Console

1. Open your application in the browser
2. Open Developer Tools (F12)
3. Check the console for configuration logs
4. In the payment modals, you should see:
   - **Midtrans**: "Environment: Production" (instead of "Sandbox")
   - **PayPal**: "Environment: Production" (instead of "Sandbox")

### 3. Test with Small Amounts First

⚠️ **IMPORTANT**: Before going fully live, test with small real transactions to ensure everything works correctly.

## 🔄 Switching Back to Sandbox

If you need to switch back to sandbox for testing:

```env
# Midtrans Sandbox
NEXT_PUBLIC_MIDTRANS_CLIENT_KEY=your_sandbox_client_key
NEXT_PUBLIC_MIDTRANS_SERVER_KEY=your_sandbox_server_key
NEXT_PUBLIC_MIDTRANS_PRODUCTION=false

# PayPal Sandbox
NEXT_PUBLIC_PAYPAL_CLIENT_ID=your_sandbox_client_id
NEXT_PUBLIC_PAYPAL_PRODUCTION=false
```

## 🌐 Production URLs

When `NEXT_PUBLIC_MIDTRANS_PRODUCTION=true`:

- **Midtrans Base URL**: `https://app.midtrans.com`
- **Midtrans Snap Script**: `https://app.midtrans.com/snap/snap.js`

When `NEXT_PUBLIC_PAYPAL_PRODUCTION=true`:

- **PayPal Base URL**: `https://www.paypal.com`
- **PayPal SDK Script**: `https://www.paypal.com/sdk/js`

## 🔒 Security Best Practices

1. **Never commit `.env.local` to version control**

   - Make sure `.env.local` is in your `.gitignore`

2. **Use different keys for different environments**

   - Never use production keys in development
   - Never use sandbox keys in production

3. **Rotate keys if compromised**

   - If you suspect keys are compromised, regenerate them immediately

4. **Monitor transactions**
   - Regularly check your Midtrans and PayPal dashboards for suspicious activity

## 🐛 Troubleshooting

### Issue: Still using sandbox URLs

**Solution**:

- Make sure environment variables are set correctly
- Restart your development server
- Clear browser cache
- Check that variables start with `NEXT_PUBLIC_` (required for Next.js client-side access)

### Issue: Payment not working in production

**Solution**:

- Verify your production credentials are correct
- Check that your Midtrans/PayPal accounts are approved for production
- Verify webhook URLs are configured correctly in both dashboards
- Check browser console for errors

### Issue: Environment variable not recognized

**Solution**:

- Ensure variable names match exactly (case-sensitive)
- For `NEXT_PUBLIC_MIDTRANS_PRODUCTION` and `NEXT_PUBLIC_PAYPAL_PRODUCTION`, the value must be the string `"true"` (not boolean true)
- Restart the server after changing environment variables

## 📞 Support

If you encounter issues:

1. Check the browser console for errors
2. Verify environment variables are set correctly
3. Check Midtrans/PayPal dashboards for transaction logs
4. Review the application logs

---

**Last Updated**: Configuration supports both sandbox and production modes. Simply update your environment variables to switch between them.
